/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper.inspres;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.constant.inspres.InspectResProLogConst;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class InspectResultProcessLogHelper {
    public static void batchInsertNew(DynamicObject[] billArr, String operate) {
        if (ArrayUtils.isEmpty((Object[])billArr)) {
            return;
        }
        String entityName = billArr[0].getDynamicObjectType().getName();
        String userName = RequestContext.get().getUserName();
        Date opDate = KDDateUtils.now();
        int arrLength = billArr.length;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"qcbd_inspres_poclog");
        DynamicObject[] inspresultPLogArr = new DynamicObject[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            DynamicObject billObj = billArr[i];
            DynamicObject newObj = new DynamicObject((DynamicObjectType)dataEntityType);
            newObj.set("entity", (Object)entityName);
            newObj.set("billno", (Object)billObj.getString("billno"));
            newObj.set("billid", (Object)billObj.getLong("id"));
            newObj.set("username", (Object)userName);
            newObj.set("opname", (Object)operate);
            newObj.set("opdate", (Object)opDate);
            newObj.set("feedback_status", (Object)InspectResProLogConst.FEEDBACK_STATUS_ENUM.W.name());
            inspresultPLogArr[i] = newObj;
        }
        SaveServiceHelper.save((DynamicObject[])inspresultPLogArr);
    }

    public static List<Long> lockBillIds(List<Long> billIds, String processor) {
        LinkedList<Long> lockedBillIds = new LinkedList<Long>();
        if (CollectionUtils.isNotEmpty(billIds)) {
            DynamicObject[] inspectResPlogObjs;
            QFilter filter = new QFilter("billid", "in", billIds).and("feedback_status", "!=", (Object)Character.valueOf('U'));
            String selectFields = String.join((CharSequence)",", "billid", "feedback_status", "processor", "processstartdate");
            for (DynamicObject inspectResLogObj : inspectResPlogObjs = BusinessDataServiceHelper.load((String)"qcbd_inspres_poclog", (String)selectFields, (QFilter[])filter.toArray())) {
                boolean legal;
                String feedBackStatus = inspectResLogObj.getString("feedback_status");
                if (InspectResProLogConst.FEEDBACK_STATUS_ENUM.P.name().equalsIgnoreCase(feedBackStatus) && !(legal = InspectResultProcessLogHelper.processDateLegal(inspectResLogObj.getDate("processstartdate")))) continue;
                lockedBillIds.add(inspectResLogObj.getLong("billid"));
                inspectResLogObj.set("processor", (Object)processor);
                inspectResLogObj.set("processstartdate", (Object)KDDateUtils.now());
                inspectResLogObj.set("feedback_status", (Object)InspectResProLogConst.FEEDBACK_STATUS_ENUM.P.name());
            }
            SaveServiceHelper.save((DynamicObject[])inspectResPlogObjs);
        }
        return lockedBillIds;
    }

    public static void setFeedBackStatus(List<Long> billIds, String status, String errMsg) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE T_QCBD_INSPRES_PLG SET ", new Object[0]);
        sqlBuilder.append("FFEEDBACK_STATUS = ?", new Object[]{status});
        if (StringUtils.isNotEmpty((String)errMsg)) {
            sqlBuilder.append(",FERRMSG_TAG = ?", new Object[]{errMsg});
        }
        sqlBuilder.append(" WHERE ", new Object[0]);
        sqlBuilder.appendIn("FBILLID", billIds.toArray());
        sqlBuilder.append("AND FFEEDBACK_STATUS != 'U'", new Object[0]);
        DB.execute((DBRoute)new DBRoute("qmc"), (SqlBuilder)sqlBuilder);
    }

    public static void delInspResLogs(List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("DELETE FROM T_QCBD_INSPRES_PLG WHERE ", new Object[0]);
        sqlBuilder.appendIn("FBILLID", billIds.toArray());
        sqlBuilder.append("AND FFEEDBACK_STATUS != 'U'", new Object[0]);
        DB.execute((DBRoute)new DBRoute("qmc"), (SqlBuilder)sqlBuilder);
    }

    public static boolean processDateLegal(Date processStartDate) {
        Date now = KDDateUtils.now();
        int seconds = InspectResultProcessLogHelper.getEffectiveSeconds();
        Date effectiveDate = KDDateUtils.addSeconds((Date)now, (int)(0 - seconds));
        return null == processStartDate || processStartDate.compareTo(effectiveDate) < 0;
    }

    public static int getEffectiveSeconds() {
        String timeOutStr = ParameterUtil.getQmcSystemProp((String)"inspres_proc_config", (String)"timeout");
        return StringUtils.isNumericString((String)timeOutStr) ? Integer.parseInt(timeOutStr) : 300;
    }
}

