/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper.invhelper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.qmc.qcbd.business.commonmodel.custom.ext.IUpdateInspPlanExt;
import kd.qmc.qcbd.business.commonmodel.custom.ext.UpdateInspPlanExt;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class InventoryInspHelper {
    private static final Log logger = LogFactory.getLog(InventoryInspHelper.class);
    private static final String QCBD_INSOBJ_OTHER = "qcbd_insobj_other";
    public static final Long PICK = 1452922898665748480L;
    public static final String QUALIFY = "A";
    public static final String UNQUALIFY = "B";

    public static void updateInspPlanInfo(JSONArray srcObjArray, String entity) {
        if (!StringQMCUtil.inside((String)entity, (String[])new String[]{"qcnp_invbalinspec", "qcnp_invbalbaddeal"}).booleanValue()) {
            return;
        }
        Set<Object> srcBillIds = InventoryInspHelper.getSrcBillIds(srcObjArray, entity);
        if (srcBillIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection billRowInfos = InventoryInspHelper.getBillRowInfos(srcBillIds, entity);
        Map<Long, List<DynamicObject>> inspObjInfoMap = InventoryInspHelper.getCheckObjInfo(srcBillIds, billRowInfos);
        if (inspObjInfoMap.isEmpty()) {
            return;
        }
        UpdateInspPlanExt defaultPlugin = new UpdateInspPlanExt();
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultPlugin, IUpdateInspPlanExt.class, (String)"QMC_QCBD_UPDATE_INSPPLAN_EXT", null);
        LinkedList appendFields = new LinkedList();
        pluginProxy.callAfter(p -> {
            p.appendInspPlanQueryFields(appendFields);
            return null;
        });
        Map<Long, DynamicObject> inspPlanInfoMap = InventoryInspHelper.getInspPlanInfo(inspObjInfoMap, appendFields.toArray(new String[0]));
        String operate = srcObjArray.getJSONObject(0).getString("operate");
        for (DynamicObject billRow : billRowInfos) {
            Long checkObjId = billRow.getLong("chkobjid");
            if (!inspObjInfoMap.containsKey(checkObjId)) continue;
            DynamicObject inspObj = inspObjInfoMap.get(checkObjId).get(0);
            InventoryInspHelper.setInspInfo(inspObj, inspPlanInfoMap, billRow, entity, operate);
        }
        pluginProxy.callAfter(p -> {
            p.beforeSaveBills(srcObjArray, entity, inspPlanInfoMap);
            return null;
        });
        SaveServiceHelper.save((DynamicObject[])inspPlanInfoMap.values().toArray(new DynamicObject[0]));
    }

    public static void updateInvIncheck(JSONArray srcObjArray, String entityNumber) {
        if (!StringQMCUtil.inside((String)entityNumber, (String[])new String[]{"qcnp_invbalinspec", "qcnp_invbalbaddeal"}).booleanValue()) {
            return;
        }
        String operate = ((JSONObject)srcObjArray.get(0)).getString("operate");
        QFilter filter = null;
        String sqlStr = null;
        if ("audit".equals(operate)) {
            filter = new QFilter("materialentry.checkcomstatus", "=", (Object)QUALIFY).and("materialentry.incheck", "=", (Object)"1");
            sqlStr = "update t_qcnp_appinsentry set fincheck = '0' where fcheckcomstatus = 'A' and fincheck = '1'";
        } else if ("unaudit".equals(operate)) {
            filter = new QFilter("materialentry.checkcomstatus", "=", (Object)" ").and("materialentry.incheck", "=", (Object)"0");
            sqlStr = "update t_qcnp_appinsentry set fincheck = '1' where fcheckcomstatus = ' ' and fincheck = '0'";
        }
        if (null == filter || null == sqlStr) {
            return;
        }
        String selectField = "materialentry.nowinvid nowinvid, materialentry.materialid materialid";
        DynamicObjectCollection idInfos = QueryServiceHelper.query((String)"qcnp_invinspectplan", (String)selectField, (QFilter[])filter.toArray());
        Set<Long> invIdSet = idInfos.stream().filter(x -> x.getLong("nowinvid") > 0L).map(x -> x.getLong("nowinvid")).collect(Collectors.toSet());
        Set<Long> materialIdSet = idInfos.stream().filter(x -> x.getLong("nowinvid") == 0L).map(x -> x.getLong("materialid")).collect(Collectors.toSet());
        InventoryInspHelper.updateInvInspInfos(invIdSet, materialIdSet, "unaudit".equals(operate), null);
        DBRoute dbRoute = DBRoute.of((String)MetadataServiceHelper.getDataEntityType((String)"qcnp_invinspectplan").getDBRouteKey());
        DB.execute((DBRoute)dbRoute, (String)sqlStr);
    }

    public static void updateInvInspInfos(Set<Long> invIdSet, Set<Long> materialidSet, Boolean status, Set<Long> ignoreBillIds) {
        int i;
        QFilter invFilter = new QFilter("datasource", "=", (Object)QUALIFY).and("inventoryid", "in", invIdSet);
        DynamicObject[] invObjs = BusinessDataServiceHelper.load((String)"qcnp_invinsp_info", (String)"inventoryid,lastinspdate,incheck", (QFilter[])invFilter.toArray());
        Map<Long, Date> invDateMap = InventoryInspHelper.getInvDateMap(invIdSet, ignoreBillIds, invObjs);
        QFilter matFilter = new QFilter("datasource", "=", (Object)UNQUALIFY).and("materialid", "in", materialidSet);
        DynamicObject[] matObjs = BusinessDataServiceHelper.load((String)"qcnp_invinsp_info", (String)"materialid,lastinspdate,incheck", (QFilter[])matFilter.toArray());
        Map<Long, Date> matDateMap = InventoryInspHelper.getMatDateMap(materialidSet, ignoreBillIds, matObjs);
        int invLength = invObjs.length;
        int matLength = matObjs.length;
        int updateLength = invLength + matLength;
        DynamicObject[] updateObjs = new DynamicObject[updateLength];
        for (i = 0; i < invLength; ++i) {
            updateObjs[i] = invObjs[i];
            updateObjs[i].set("incheck", (Object)status);
            if (CollectionUtils.isEmpty(ignoreBillIds)) continue;
            Long inventoryid = updateObjs[i].getLong("inventoryid");
            updateObjs[i].set("lastinspdate", (Object)invDateMap.get(inventoryid));
        }
        for (i = 0; i < matLength; ++i) {
            int updateIndex = i + invLength;
            updateObjs[updateIndex] = matObjs[i];
            updateObjs[updateIndex].set("incheck", (Object)status);
            if (CollectionUtils.isEmpty(ignoreBillIds)) continue;
            Long materialid = updateObjs[updateIndex].getLong("materialid");
            updateObjs[updateIndex].set("lastinspdate", (Object)matDateMap.get(materialid));
        }
        SaveServiceHelper.save((DynamicObject[])updateObjs);
    }

    public static void deleteImminvEntry(Set<Long> billIdSet, Set<Long> entryidSet) {
        QFilter filter = new QFilter("id", "in", (Object)billIdSet.toArray());
        DynamicObjectCollection imminvInfos = QueryServiceHelper.query((String)"qcnp_imminv_model", (String)"id, exedetail.id entryid, exedetail.inspres inspres", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> imminvInfosGroup = imminvInfos.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        HashSet billIdDelSet = new HashSet(16);
        HashSet entryidDelSet = new HashSet(16);
        imminvInfosGroup.forEach((billId, rowList) -> {
            Set singleObjEntryId = rowList.stream().map(x -> x.getLong("entryid")).collect(Collectors.toSet());
            singleObjEntryId.removeAll(entryidSet);
            if (singleObjEntryId.isEmpty()) {
                billIdDelSet.add(billId);
            } else {
                entryidDelSet.addAll(entryidSet);
            }
        });
        if (!billIdDelSet.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"qcnp_imminv_model"), (Object[])billIdDelSet.toArray());
        }
        if (!entryidDelSet.isEmpty()) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_qcnp_iminv_entry where ", new Object[0]);
            sqlBuilder.appendIn("fentryid", entryidDelSet.toArray());
            DB.execute((DBRoute)new DBRoute("qmc"), (SqlBuilder)sqlBuilder);
        }
    }

    public static void showInspectPlanList(IFormView view, List targetIds) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"qcnp_invinspectpla_layout", (boolean)true, (int)0, (boolean)false);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)targetIds));
        Map customParams = listShowParameter.getCustomParams();
        customParams.put("fromInvScheme", Boolean.TRUE);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static Map<Long, List<DynamicObject>> getCheckObjInfo(Set<Object> srcBillIds, DynamicObjectCollection billInfos) {
        Set checkObjIdSet = billInfos.stream().map(x -> x.getLong("chkobjid")).collect(Collectors.toSet());
        Set srcBillIdStrs = srcBillIds.stream().map(x -> x.toString()).collect(Collectors.toSet());
        QFilter checkObjFilter = new QFilter("id", "in", checkObjIdSet).and("srcentitynumber", "=", (Object)"qcnp_invinspectplan").and(String.format("%s.%s", "entryentity", "ass_billid"), "in", srcBillIdStrs);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s,", "id"));
        sb.append(String.format("%s,", "srcbillid"));
        sb.append(String.format("%s", "srcentryid"));
        DynamicObjectCollection insObjInfos = QueryServiceHelper.query((String)QCBD_INSOBJ_OTHER, (String)sb.toString(), (QFilter[])checkObjFilter.toArray());
        if (insObjInfos.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(16);
        }
        return insObjInfos.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
    }

    public static Map<Long, DynamicObject> getInspPlanInfo(Map<Long, List<DynamicObject>> inspObjInfoMap, String ... otherFields) {
        Set inspPlanIdSet = inspObjInfoMap.values().stream().map(x -> Long.parseLong(((DynamicObject)x.get(0)).getString("srcbillid"))).collect(Collectors.toSet());
        String selectProperties = String.join((CharSequence)",", String.format("%s.%s", "subentryentity", "seq"), "inspresult", "handmethod", "dealqty", "dealqtybase", "newarrdate", "invmodqty", "invmodqtybase");
        if (ArrayUtils.isNotEmpty((Object[])otherFields)) {
            String appendFields = String.join((CharSequence)",", otherFields);
            selectProperties = selectProperties + "," + appendFields;
        }
        DynamicObject[] inspPlanObjArr = BusinessDataServiceHelper.load((String)"qcnp_invinspectplan", (String)selectProperties, (QFilter[])new QFilter("id", "in", inspPlanIdSet).toArray());
        return Arrays.stream(inspPlanObjArr).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
    }

    private static void setInspInfo(DynamicObject inspObj, Map<Long, DynamicObject> inspPlanInfoMap, DynamicObject billRow, String entity, String operate) {
        Long srcBillId = Long.parseLong(inspObj.getString("srcbillid"));
        Long srcEntryId = Long.parseLong(inspObj.getString("srcentryid"));
        DynamicObject inspPlanObj = inspPlanInfoMap.get(srcBillId);
        DynamicObjectCollection materialentry = inspPlanObj.getDynamicObjectCollection("materialentry");
        int size = materialentry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject matRow = (DynamicObject)materialentry.get(i);
            if (!srcEntryId.equals(matRow.getPkValue())) continue;
            if ("qcnp_invbalinspec".equals(entity)) {
                InventoryInspHelper.setInspectRowInfo(matRow, billRow, operate);
                continue;
            }
            if (!"qcnp_invbalbaddeal".equals(entity)) continue;
            InventoryInspHelper.setBadDealRowInfo(matRow, billRow, operate);
        }
    }

    private static void setInspectRowInfo(DynamicObject matRow, DynamicObject inspectRow, String operate) {
        Date newArrDate = inspectRow.getDate("newarrdate");
        BigDecimal qualiQty = inspectRow.getBigDecimal("qualiqty");
        if (null == qualiQty || 0 == BigDecimal.ZERO.compareTo(qualiQty)) {
            return;
        }
        DynamicObjectCollection subentryentity = matRow.getDynamicObjectCollection("subentryentity");
        Optional<DynamicObject> first = subentryentity.stream().filter(x -> QUALIFY.equals(x.getString("inspresult")) && (null == newArrDate && null == x.getDate("newarrdate") || null != newArrDate && newArrDate.equals(x.getDate("newarrdate")))).findFirst();
        if (first.isPresent()) {
            DynamicObject matchRow = first.get();
            if ("audit".equals(operate)) {
                matchRow.set("dealqty", (Object)matchRow.getBigDecimal("dealqty").add(qualiQty));
                matchRow.set("dealqtybase", (Object)matchRow.getBigDecimal("dealqtybase").add(inspectRow.getBigDecimal("basequaliqty")));
            } else if ("unaudit".equals(operate)) {
                BigDecimal dealQty = matchRow.getBigDecimal("dealqty").subtract(qualiQty);
                matchRow.set("dealqty", (Object)dealQty);
                matchRow.set("dealqtybase", (Object)matchRow.getBigDecimal("dealqtybase").subtract(inspectRow.getBigDecimal("basequaliqty")));
                if (dealQty.compareTo(BigDecimal.ZERO) == 0) {
                    subentryentity.remove((Object)matchRow);
                }
            }
        } else if ("audit".equals(operate)) {
            int seq = subentryentity.size() + 1;
            DynamicObject newRow = subentryentity.addNew();
            newRow.set("seq", (Object)seq);
            newRow.set("inspresult", (Object)QUALIFY);
            newRow.set("newarrdate", (Object)newArrDate);
            newRow.set("dealqty", (Object)qualiQty);
            newRow.set("dealqtybase", (Object)inspectRow.getBigDecimal("basequaliqty"));
            if (null != newArrDate) {
                newRow.set("handmethod", (Object)1458731434154988544L);
            }
        }
    }

    private static void setBadDealRowInfo(DynamicObject matRow, DynamicObject badDealRow, String operate) {
        Long newHandModeLong = badDealRow.getLong("newhandmode");
        if (PICK.equals(newHandModeLong)) {
            return;
        }
        DynamicObject newHandMode = BusinessDataServiceHelper.loadSingleFromCache((Object)newHandModeLong, (String)"qcbd_badhandmode");
        DynamicObjectCollection subentryentity = matRow.getDynamicObjectCollection("subentryentity");
        Optional<DynamicObject> first = subentryentity.stream().filter(x -> UNQUALIFY.equals(x.getString("inspresult"))).filter(x -> newHandMode.getPkValue().equals(DynamicObjDataUtil.getDynamicObjectLongData((DynamicObject)x.getDynamicObject("handmethod"), (String)"id"))).findFirst();
        if (first.isPresent()) {
            DynamicObject matchRow = first.get();
            if ("audit".equals(operate)) {
                matchRow.set("dealqty", (Object)matchRow.getBigDecimal("dealqty").add(badDealRow.getBigDecimal("unqualiqty")));
                matchRow.set("dealqtybase", (Object)matchRow.getBigDecimal("dealqtybase").add(badDealRow.getBigDecimal("baseqty")));
            } else if ("unaudit".equals(operate)) {
                BigDecimal dealQty = matchRow.getBigDecimal("dealqty").subtract(badDealRow.getBigDecimal("unqualiqty"));
                matchRow.set("dealqty", (Object)dealQty);
                matchRow.set("dealqtybase", (Object)matchRow.getBigDecimal("dealqtybase").subtract(badDealRow.getBigDecimal("baseqty")));
                if (dealQty.compareTo(BigDecimal.ZERO) == 0) {
                    subentryentity.remove((Object)matchRow);
                }
            }
        } else if ("audit".equals(operate)) {
            int seq = subentryentity.size() + 1;
            DynamicObject newRow = subentryentity.addNew();
            newRow.set("seq", (Object)seq);
            newRow.set("inspresult", (Object)UNQUALIFY);
            newRow.set("handmethod", (Object)newHandMode);
            newRow.set("dealqty", (Object)badDealRow.getBigDecimal("unqualiqty"));
            newRow.set("dealqtybase", (Object)badDealRow.getBigDecimal("baseqty"));
        }
    }

    private static Map<Long, Date> getInvDateMap(Set<Long> invIdSet, Set<Long> ignoreBillIds, DynamicObject[] invObjs) {
        Map<Long, Date> inspectDateMap = new HashMap<Long, Date>(16);
        if (null != ignoreBillIds && !ignoreBillIds.isEmpty() && invObjs.length > 0) {
            QFilter filter = new QFilter("id", "not in", ignoreBillIds).and("materialentry.nowinvid", "in", invIdSet);
            DynamicObjectCollection inspectInfos = QueryServiceHelper.query((String)"qcnp_invinspectplan", (String)"materialentry.nowinvid,createtime", (QFilter[])filter.toArray());
            Map<Long, List<DynamicObject>> inspectInfoMap = inspectInfos.stream().collect(Collectors.groupingBy(x -> x.getLong("materialentry.nowinvid")));
            inspectDateMap = InventoryInspHelper.getMaxDate(inspectInfoMap);
        }
        return inspectDateMap;
    }

    private static Map<Long, Date> getMatDateMap(Set<Long> matIdSet, Set<Long> ignoreBillIds, DynamicObject[] matObjs) {
        Map<Long, Date> inspectDateMap = new HashMap<Long, Date>(16);
        if (null != ignoreBillIds && !ignoreBillIds.isEmpty() && matObjs.length > 0) {
            QFilter filter = new QFilter("id", "not in", ignoreBillIds).and("materialentry.nowinvid", "=", (Object)0L).and("materialentry.materialid", "in", matIdSet);
            DynamicObjectCollection inspectInfos = QueryServiceHelper.query((String)"qcnp_invinspectplan", (String)"materialentry.materialid,createtime", (QFilter[])filter.toArray());
            Map<Long, List<DynamicObject>> inspectInfoMap = inspectInfos.stream().collect(Collectors.groupingBy(x -> x.getLong("materialentry.materialid")));
            inspectDateMap = InventoryInspHelper.getMaxDate(inspectInfoMap);
        }
        return inspectDateMap;
    }

    private static Map<Long, Date> getMaxDate(Map<Long, List<DynamicObject>> inspectInfoMap) {
        Set<Map.Entry<Long, List<DynamicObject>>> entrySet = inspectInfoMap.entrySet();
        HashMap<Long, Date> inspectMaxDate = new HashMap<Long, Date>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : entrySet) {
            Long keyId = entry.getKey();
            List<DynamicObject> inspInfoList = entry.getValue();
            Optional<Date> maxOption = inspInfoList.stream().map(x -> x.getDate("createtime")).max(Comparator.naturalOrder());
            if (maxOption.isPresent()) {
                inspectMaxDate.put(keyId, maxOption.get());
                continue;
            }
            inspectMaxDate.put(keyId, null);
        }
        return inspectMaxDate;
    }

    private static Set<Object> getSrcBillIds(JSONArray srcObjArray, String entity) {
        List srcBillIdList = srcObjArray.stream().filter(x -> x instanceof JSONObject && entity.equals(((JSONObject)x).getString("metaKey"))).map(x -> ((JSONObject)x).getJSONObject("dockParam").getJSONArray("srcBillIDs")).collect(Collectors.toList());
        if (srcBillIdList.isEmpty()) {
            return new HashSet<Object>(16);
        }
        HashSet<Object> srcBillIds = new HashSet<Object>(16);
        for (JSONArray srcBillIdArr : srcBillIdList) {
            srcBillIds.addAll((Collection<Object>)srcBillIdArr);
        }
        return srcBillIds;
    }

    private static DynamicObjectCollection getBillRowInfos(Set<Object> srcBillIds, String entity) {
        StringBuilder sb = new StringBuilder();
        QFilter billFilter = new QFilter("id", "in", srcBillIds);
        if ("qcnp_invbalinspec".equals(entity)) {
            sb.append(String.format("%s.%s %s,", "matintoentity", "chkobjid", "chkobjid"));
            sb.append(String.format("%s.%s %s,", "matintoentity", "srcunitid", "srcunitid"));
            sb.append(String.format("%s.%s %s,", "matintoentity", "qualiqty", "qualiqty"));
            sb.append(String.format("%s.%s %s,", "matintoentity", "basequaliqty", "basequaliqty"));
            sb.append(String.format("%s.%s %s", "matintoentity", "newarrdate", "newarrdate"));
        } else if ("qcnp_invbalbaddeal".equals(entity)) {
            sb.append(String.format("%s.%s %s,", "materialentry", "chkobjid", "chkobjid"));
            sb.append(String.format("%s.%s %s,", "materialentry", "newhandmode", "newhandmode"));
            sb.append(String.format("%s.%s %s,", "materialentry", "srcunitid", "srcunitid"));
            sb.append(String.format("%s.%s %s,", "materialentry", "unqualiqty", "unqualiqty"));
            sb.append(String.format("%s.%s %s", "materialentry", "baseqty", "baseqty"));
        }
        return QueryServiceHelper.query((String)entity, (String)sb.toString(), (QFilter[])billFilter.toArray());
    }

    public static DynamicObject[] getInvSchemes(QFilter schemeFilter, String ... orderby) {
        String selectFileds = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "name", "datasource", "filterstring_tag", "exectime", "execstep", "execres", "execlog_tag", "inspectcyscle", "longmon", "longday", "quaorg", "applyorg", "splitreason", "matergrpsel", "materialsel", "inspectnumstyle", "firstinspectdate", "setdate", "inspectleadtime");
        if (ArrayUtils.isEmpty((Object[])orderby)) {
            return BusinessDataServiceHelper.load((String)"qcbd_invimpschem", (String)selectFileds, (QFilter[])schemeFilter.toArray());
        }
        return BusinessDataServiceHelper.load((String)"qcbd_invimpschem", (String)selectFileds, (QFilter[])schemeFilter.toArray(), (String)String.join((CharSequence)",", orderby));
    }

    public static void setExeLog(DynamicObject invScheme, String execRes, String execLogTag) {
        Date exeTime = KDDateUtils.now();
        DynamicObjectCollection entryLog = invScheme.getDynamicObjectCollection("entryentitylog");
        entryLog.clear();
        DynamicObject logRow = entryLog.addNew();
        logRow.set("exectime", (Object)exeTime);
        logRow.set("execstep", (Object)"C");
        logRow.set("execres", (Object)execRes);
        logRow.set("execlog_tag", (Object)execLogTag);
    }

    public static Map<String, Object> permissionCheck(Collection schemeIds, Long orgId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        Long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isAdminUser((long)userId)) {
            return retMap;
        }
        logger.info("\u67e5\u8be2\u5e93\u5b58\u8bf7\u68c0\u5355\u6743\u9650userId" + userId);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u8bf7\u68c0\u5355\u6743\u9650orgId" + orgId);
        int permission = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"qcnp", (String)"qcnp_invinspectplan", (String)"47156aff000000ac");
        logger.info("\u67e5\u8be2\u5e93\u5b58\u8bf7\u68c0\u5355\u6743\u9650permission" + permission);
        if (0 == permission) {
            DynamicObject[] invSchemes;
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u5e93\u5b58\u8bf7\u68c0\u5355\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InventoryInspHelper_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
            retMap.put("errInvSb", errMsg);
            for (DynamicObject invScheme : invSchemes = InventoryInspHelper.getInvSchemes(new QFilter("id", "in", (Object)schemeIds), new String[0])) {
                InventoryInspHelper.setExeLog(invScheme, UNQUALIFY, errMsg);
            }
            SaveServiceHelper.save((DynamicObject[])invSchemes);
        }
        return retMap;
    }
}

