/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.inspectpro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.match.MatchQfilterArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.match.impl.InspectProDimenBase;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.inspectpro.InspectProPriorityPlugin;
import kd.qmc.qcbd.common.platform.basedata.PlatformBasedateServiceHelper;
import kd.qmc.qcbd.common.platform.org.PlatformOrgUnitServiceHelper;
import kd.qmc.qcbd.common.util.UserUtil;

public class InspectProMatchHelper {
    private static final String FBASEDATAID = "fbasedataid_id";
    private static final String TRANSACTYPE = "transactype";
    private static final String XIAHUAXIAN = "_";
    private static final String XIAOSHUDIAN = ".";
    private static boolean billValueAllDefault;

    public static QFilter getInspectProQFilter(InspectDealArgs args, InspectProGlobalCache inspectProGlobalCache) {
        QFilter inspectProFilter = null;
        InspproVoluationKeyModel keyModel = args.getVoluationKeyModel();
        DynamicObject billData = args.getBillData();
        DynamicObject inspectOrg = billData.getDynamicObject(keyModel.getInspectOrgKey());
        if (Objects.isNull(inspectOrg) || Objects.isNull(billData.get(TRANSACTYPE))) {
            return inspectProFilter;
        }
        long inspectOrgId = inspectOrg.getLong("id");
        String entryKey = keyModel.getEntryKey();
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            DynamicObjectCollection entrys = billData.getDynamicObjectCollection(entryKey);
            int rowIndex = (Integer)args.getRowIndexSet().stream().findFirst().get();
            DynamicObject entry = (DynamicObject)entrys.get(rowIndex);
            inspectProFilter = InspectProMatchHelper.getInspectProFilter(billData, entry, inspectProGlobalCache, inspectOrgId);
        } else {
            inspectProFilter = InspectProMatchHelper.getInspectProFilter(billData, null, inspectProGlobalCache, inspectOrgId);
        }
        return inspectProFilter;
    }

    public static void inspectProDeal(InspectDealArgs args, InspectProGlobalCache inspectProGlobalCache) {
        InspectProVoluationFactory factory = args.getFactory();
        InspproVoluationKeyModel keyModel = args.getVoluationKeyModel();
        InspectDealArgs.VOLUSTIONSCENE volustionScene = args.getVolustionScene();
        DynamicObject billData = args.getBillData();
        DynamicObject inspectOrg = billData.getDynamicObject(keyModel.getInspectOrgKey());
        if (Objects.isNull(inspectOrg) || Objects.isNull(billData.get(TRANSACTYPE))) {
            return;
        }
        long inspectOrgId = inspectOrg.getLong("id");
        String entryKey = keyModel.getEntryKey();
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            DynamicObjectCollection entrys = billData.getDynamicObjectCollection(entryKey);
            for (Integer rowIndex : args.getRowIndexSet()) {
                DynamicObject entry = (DynamicObject)entrys.get(rowIndex.intValue());
                DynamicObject inspectPro = InspectProMatchHelper.getInspectPro(billData, entry, inspectProGlobalCache, inspectOrgId);
                if (Objects.equals((Object)volustionScene, (Object)InspectDealArgs.VOLUSTIONSCENE.FORM)) {
                    factory.voluationFormDeal(args, inspectProGlobalCache, inspectPro, rowIndex);
                    continue;
                }
                if (!Objects.equals((Object)volustionScene, (Object)InspectDealArgs.VOLUSTIONSCENE.OPERATE)) continue;
                factory.voluationOperateDeal(args, inspectProGlobalCache, inspectPro, rowIndex);
            }
        } else {
            DynamicObject inspectPro = InspectProMatchHelper.getInspectPro(billData, null, inspectProGlobalCache, inspectOrgId);
            if (Objects.equals((Object)volustionScene, (Object)InspectDealArgs.VOLUSTIONSCENE.FORM)) {
                factory.voluationFormDeal(args, inspectProGlobalCache, inspectPro, null);
            } else if (Objects.equals((Object)volustionScene, (Object)InspectDealArgs.VOLUSTIONSCENE.OPERATE)) {
                factory.voluationOperateDeal(args, inspectProGlobalCache, inspectPro, null);
            }
        }
    }

    public static QFilter getInspectProFilter(DynamicObject billData, DynamicObject entry, InspectProGlobalCache inspectProGlobalCache, Long orgId) {
        DynamicObject[] queryInspectPros;
        QFilter inspectProQfilter = InspectProMatchHelper.getInspectProOrgQfilter(inspectProGlobalCache, orgId);
        DynamicObject transacType = billData.getDynamicObject(TRANSACTYPE);
        DynamicObjectCollection proMatchDimenMuls = transacType.getDynamicObjectCollection("promatchdimen");
        StringBuilder proCacheKey = new StringBuilder();
        InspectProMatchHelper.oldPriorityDeal(billData, entry, inspectProGlobalCache, inspectProQfilter, proMatchDimenMuls, proCacheKey);
        boolean isBizType = proMatchDimenMuls.stream().allMatch(m -> "BIZTYPE".equals(m.getDynamicObject("fbasedataid").getString("number")));
        if (isBizType) {
            return new QFilter("1", "!=", (Object)1);
        }
        for (DynamicObject proMatchDimenMul : proMatchDimenMuls) {
            DynamicObject proMatchDimen = InspectProMatchHelper.getDimenDetail(inspectProGlobalCache, proMatchDimenMul.getLong(FBASEDATAID));
            long dimenPk = proMatchDimen.getLong("id");
            if (transacType.getBoolean("matchpriority") && (1599303399160004608L == dimenPk || 1599887438686307328L == dimenPk)) continue;
            InspectProDimenBase factory = new InspectProDimenBase();
            MatchQfilterArgs args = new MatchQfilterArgs(billData, entry);
            QFilter qFilter = factory.buildQfilter(args, inspectProGlobalCache, proMatchDimen);
            if (Objects.nonNull(qFilter)) {
                inspectProQfilter.and(qFilter);
                proCacheKey.append(qFilter.getValue());
                proCacheKey.append(XIAHUAXIAN);
                continue;
            }
            return new QFilter("1", "!=", (Object)1);
        }
        inspectProQfilter.and("enable", "=", (Object)"1");
        inspectProQfilter.and("status", "=", (Object)"C");
        HashSet<Long> inspectProIdSet = new HashSet<Long>(16);
        for (DynamicObject queryInspectPro : queryInspectPros = BusinessDataServiceHelper.load((String)"qcbd_inspectpro", (String)"id,promatchdimen", (QFilter[])inspectProQfilter.toArray())) {
            Set billDimenIdSet = proMatchDimenMuls.stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet());
            Set proDimenIdSet = queryInspectPro.getDynamicObjectCollection("promatchdimen").stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet());
            if (billDimenIdSet.size() != proDimenIdSet.size() || !billDimenIdSet.containsAll(proDimenIdSet)) continue;
            inspectProIdSet.add(queryInspectPro.getLong("id"));
        }
        inspectProQfilter.and("id", "in", inspectProIdSet);
        return inspectProQfilter;
    }

    public static DynamicObject getInspectPro(DynamicObject billData, DynamicObject entry, InspectProGlobalCache inspectProGlobalCache, Long orgId) {
        QFilter inspectProQfilter = InspectProMatchHelper.getInspectProOrgQfilter(inspectProGlobalCache, orgId);
        DynamicObject inspectPro = null;
        DynamicObject transacType = billData.getDynamicObject(TRANSACTYPE);
        DynamicObjectCollection proMatchDimenMuls = transacType.getDynamicObjectCollection("promatchdimen");
        StringBuilder proCacheKey = new StringBuilder();
        billValueAllDefault = true;
        InspectProMatchHelper.oldPriorityDeal(billData, entry, inspectProGlobalCache, inspectProQfilter, proMatchDimenMuls, proCacheKey);
        for (DynamicObject proMatchDimenMul : proMatchDimenMuls) {
            DynamicObject proMatchDimen = InspectProMatchHelper.getDimenDetail(inspectProGlobalCache, proMatchDimenMul.getLong(FBASEDATAID));
            long dimenPk = proMatchDimen.getLong("id");
            if (transacType.getBoolean("matchpriority") && (1599303399160004608L == dimenPk || 1599887438686307328L == dimenPk)) continue;
            InspectProDimenBase factory = new InspectProDimenBase();
            MatchQfilterArgs args = new MatchQfilterArgs(billData, entry);
            QFilter qFilter = factory.buildQfilter(args, inspectProGlobalCache, proMatchDimen);
            if (!Objects.nonNull(qFilter)) {
                return null;
            }
            inspectProQfilter.and(qFilter);
            proCacheKey.append(qFilter.getValue());
            proCacheKey.append(XIAHUAXIAN);
            if (args.getValueDefault().booleanValue()) continue;
            billValueAllDefault = false;
        }
        if (!billValueAllDefault) {
            inspectPro = InspectProMatchHelper.getInspro(billData, inspectProGlobalCache, inspectProQfilter, proMatchDimenMuls, proCacheKey.substring(0, proCacheKey.lastIndexOf(XIAHUAXIAN)));
        }
        return inspectPro;
    }

    private static QFilter getInspectProOrgQfilter(InspectProGlobalCache inspectProGlobalCache, Long orgId) {
        QFilter qFilter;
        String cacheKey = "inspectpro_org_qfilter_" + orgId;
        Map<String, QFilter> orgBaseDataAuthCacheMap = inspectProGlobalCache.getOrgBaseDataAuthCacheMap();
        QFilter filterCache = orgBaseDataAuthCacheMap.get(cacheKey);
        if (Objects.nonNull(filterCache)) {
            qFilter = filterCache;
        } else {
            qFilter = PlatformBasedateServiceHelper.getBaseDataFilter((String)"qcbd_inspectpro", (Long)orgId);
            orgBaseDataAuthCacheMap.put(cacheKey, qFilter);
        }
        return qFilter.copy();
    }

    private static DynamicObject getDimenDetail(InspectProGlobalCache inspectProGlobalCache, Long dimenId) {
        DynamicObject result;
        Map<Long, Object> dimenCacheMap = inspectProGlobalCache.getDimenCacheMap();
        Object dimenDyo = dimenCacheMap.get(dimenId);
        if (Objects.nonNull(dimenDyo)) {
            result = (DynamicObject)dimenDyo;
        } else {
            result = QueryServiceHelper.queryOne((String)"qcbd_pro_matchdimen", (String)"id,profield", (QFilter[])new QFilter("id", "=", (Object)dimenId).toArray());
            dimenCacheMap.put(dimenId, result);
        }
        return result;
    }

    private static DynamicObject getInspro(DynamicObject billData, InspectProGlobalCache inspectProGlobalCache, QFilter qFilter, DynamicObjectCollection proMatchDimenMuls, String proCacheKey) {
        boolean matchPriority = billData.getDynamicObject(TRANSACTYPE).getBoolean("matchpriority");
        DynamicObject result = null;
        Map<String, DynamicObject> proCacheMap = inspectProGlobalCache.getProCacheMap();
        DynamicObject cacheValue = proCacheMap.get(proCacheKey);
        if (Objects.nonNull(cacheValue)) {
            result = cacheValue;
        } else {
            DynamicObject finalResult;
            ArrayList<DynamicObject> inspectPros;
            DynamicObject finalBillData;
            List inspectProDynList;
            DynamicObject inspectPro;
            Object supPk;
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            String selectProperties = "id,entryentity.id entryid,entryentity.materielid materielid";
            DynamicObjectCollection queryInspectPros = QueryServiceHelper.query((String)"qcbd_inspectpro", (String)selectProperties, (QFilter[])qFilter.toArray());
            DynamicObject[] loadInspectPros = BusinessDataServiceHelper.load((Object[])queryInspectPros.stream().map(o -> o.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcbd_inspectpro"));
            ArrayList<DynamicObject> inspectProList = new ArrayList<DynamicObject>(10);
            for (DynamicObject loadInspectPro : loadInspectPros) {
                Set billDimenIdSet = proMatchDimenMuls.stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet());
                Set proDimenIdSet = loadInspectPro.getDynamicObjectCollection("promatchdimen").stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet());
                if (billDimenIdSet.size() != proDimenIdSet.size() || !billDimenIdSet.containsAll(proDimenIdSet)) continue;
                inspectProList.add(loadInspectPro);
            }
            if (CollectionUtils.isEmpty(inspectProList)) {
                return null;
            }
            List nests = qFilter.getNests(Boolean.TRUE.booleanValue());
            if (matchPriority) {
                Long matPk = 0L;
                supPk = 0L;
                for (QFilter.QFilterNest nest : nests) {
                    Long value;
                    QFilter filter = nest.getFilter();
                    String property = filter.getProperty();
                    if (StringUtils.equals((CharSequence)"entryentity.materielid", (CharSequence)property)) {
                        matPk = (Long)filter.getValue();
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"entryentity.supplier", (CharSequence)property) || (value = (Long)filter.getValue()) <= 0L) continue;
                    supPk = value;
                }
                result = InspectProMatchHelper.levelSort(inspectProGlobalCache, matPk, (Long)supPk, inspectProList);
            } else {
                List queryInspectProsSorted = queryInspectPros.stream().sorted(Comparator.comparing(o -> o.getLong("materielid"), Comparator.reverseOrder())).collect(Collectors.toList());
                supPk = queryInspectProsSorted.iterator();
                while (supPk.hasNext()) {
                    DynamicObject queryInspectPro = (DynamicObject)supPk.next();
                    long id = queryInspectPro.getLong("id");
                    Optional<DynamicObject> resultOpt = inspectProList.stream().filter(o -> o.getLong("id") == id).findFirst();
                    if (!resultOpt.isPresent()) continue;
                    result = resultOpt.get();
                    break;
                }
            }
            if (!inspectProList.isEmpty()) {
                for (DynamicObject inspectPro2 : inspectProList) {
                    long resultId = inspectPro2.getLong("id");
                    Set inspectProEntryId = queryInspectPros.stream().map(o -> {
                        if (o.getLong("id") == resultId) {
                            return o.getLong("entryid");
                        }
                        return 0L;
                    }).collect(Collectors.toSet());
                    if (inspectProEntryId.isEmpty()) continue;
                    DynamicObjectCollection entrys = inspectPro2.getDynamicObjectCollection("entryentity");
                    entrys.removeIf(o -> !inspectProEntryId.contains(o.getLong("id")));
                }
            }
            ArrayList<DynamicObject> inspectProNewList = new ArrayList<DynamicObject>(10);
            for (DynamicObject inspectPro3 : inspectProList) {
                for (DynamicObject entryEntity : inspectPro3.getDynamicObjectCollection("entryentity")) {
                    CloneUtils cloneUtils = new CloneUtils(false, false);
                    DynamicObject newData = (DynamicObject)cloneUtils.clone((IDataEntityBase)inspectPro3);
                    DynamicObjectCollection entrys = newData.getDynamicObjectCollection("entryentity");
                    entrys.removeIf(o -> o.getLong("id") != entryEntity.getLong("id"));
                    inspectProNewList.add(newData);
                }
            }
            PluginProxy<InspectProPriorityPlugin> pluginProxy = InspectProMatchHelper.getDimensPluginProxy(null);
            if (!CollectionUtils.isEmpty((Collection)pluginProxy.getPlugins()) && (inspectPro = (DynamicObject)(inspectProDynList = pluginProxy.callReplace(arg_0 -> InspectProMatchHelper.lambda$getInspro$11(finalBillData = billData, inspectPros = inspectProNewList, finalResult = result, arg_0))).get(0)) != null) {
                result = inspectPro;
            }
        }
        return result;
    }

    public static List<Long> getMatType(InspectProGlobalCache inspectProGlobalCache, Long matPk) {
        List<Long> matTypeIds;
        Map<Long, List<Long>> matTypeCacheMap = inspectProGlobalCache.getMatTypeCacheMap();
        List<Long> value = matTypeCacheMap.get(matPk);
        if (Objects.nonNull(value)) {
            matTypeIds = value;
        } else {
            QFilter mattypeFilter = new QFilter("material", "=", (Object)matPk);
            DynamicObjectCollection matTypes = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"group", (QFilter[])new QFilter[]{mattypeFilter});
            matTypeIds = matTypes.stream().map(o -> o.getLong("group")).collect(Collectors.toList());
            matTypeCacheMap.put(matPk, matTypeIds);
        }
        return matTypeIds;
    }

    private static void oldPriorityDeal(DynamicObject billData, DynamicObject entry, InspectProGlobalCache inspectProGlobalCache, QFilter inspectProQfilter, DynamicObjectCollection proMatchDimenMuls, StringBuilder proCacheKey) {
        Set fbasedataIds;
        if (billData.getDynamicObject(TRANSACTYPE).getBoolean("matchpriority") && (fbasedataIds = proMatchDimenMuls.stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet())).contains(1599303399160004608L)) {
            InspectProDimenBase inspectProDimen = new InspectProDimenBase();
            MatchQfilterArgs args = new MatchQfilterArgs(billData, entry);
            DynamicObject proMatchDimen = InspectProMatchHelper.getDimenDetail(inspectProGlobalCache, 1599303399160004608L);
            QFilter qFilterMat = inspectProDimen.buildQfilter(args, inspectProGlobalCache, proMatchDimen);
            if (Objects.isNull(qFilterMat)) {
                return;
            }
            InspectProMatchHelper.dealDefaultValueAndCacheKey(proCacheKey, args, qFilterMat);
            DynamicObject matDyo = args.getEntry().getDynamicObject(args.getBillField());
            InspectProMatchHelper.buildMatTypeQfilter(inspectProGlobalCache, qFilterMat, matDyo);
            inspectProQfilter.and(qFilterMat);
            if (fbasedataIds.contains(1599887438686307328L)) {
                proMatchDimen = InspectProMatchHelper.getDimenDetail(inspectProGlobalCache, 1599887438686307328L);
                QFilter qFilterSup = inspectProDimen.buildQfilter(args, inspectProGlobalCache, proMatchDimen);
                if (Objects.isNull(qFilterSup)) {
                    return;
                }
                InspectProMatchHelper.dealDefaultValueAndCacheKey(proCacheKey, args, qFilterSup);
                if (Objects.nonNull(entry.getDynamicObject(args.getBillField()))) {
                    qFilterSup.or("entryentity.supplier", "=", (Object)0L);
                }
                inspectProQfilter.and(qFilterSup);
            }
        }
    }

    private static DynamicObject levelSort(InspectProGlobalCache inspectProGlobalCache, Long matPk, Long supPk, List<DynamicObject> inspros) {
        DynamicObject insproResult = null;
        boolean level1 = false;
        boolean level2 = false;
        boolean level3 = false;
        List<Long> matTypeIds = InspectProMatchHelper.getMatType(inspectProGlobalCache, matPk);
        block0: for (DynamicObject inspro : inspros) {
            DynamicObjectCollection entrys = inspro.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long curMatTypePk;
                if (level1) continue block0;
                DynamicObject curMat = entry.getDynamicObject("materielid");
                long curMatPk = Objects.nonNull(curMat) ? curMat.getLong("id") : 0L;
                DynamicObject curSup = entry.getDynamicObject("supplier");
                long curSupPk = Objects.nonNull(curSup) ? curSup.getLong("id") : 0L;
                DynamicObject curMatType = entry.getDynamicObject("materieltype");
                long l = curMatTypePk = Objects.nonNull(curMatType) ? curMatType.getLong("id") : 0L;
                if (curMatPk > 0L && curSupPk > 0L && matPk == curMatPk && supPk == curSupPk) {
                    level1 = true;
                    insproResult = inspro;
                    continue;
                }
                if (matTypeIds.contains(curMatTypePk) && curSupPk > 0L && supPk == curSupPk) {
                    insproResult = inspro;
                    level2 = true;
                    continue;
                }
                if (curMatPk > 0L && matPk == curMatPk && curSupPk == 0L) {
                    if (level2) continue;
                    insproResult = inspro;
                    level3 = true;
                    continue;
                }
                if (!matTypeIds.contains(curMatTypePk) || curSupPk != 0L || level2 || level3) continue;
                insproResult = inspro;
            }
        }
        return insproResult;
    }

    public static void buildDimenSameQfilter(DynamicObjectCollection dimens, QFilter qFilter) {
        if (CollectionUtils.isEmpty((Collection)dimens)) {
            return;
        }
        Set dimenIds = dimens.stream().map(o -> o.getLong(FBASEDATAID)).collect(Collectors.toSet());
        for (Long dimenId : dimenIds) {
            qFilter.and(QFilter.exists((String)"promatchdimen", (QFilter)new QFilter(FBASEDATAID, "=", (Object)dimenId)));
        }
        qFilter.and(QFilter.notExists((String)"promatchdimen", (QFilter)new QFilter(FBASEDATAID, "not in", dimenIds)));
    }

    public static void buildMatTypeQfilter(InspectProGlobalCache inspectProGlobalCache, QFilter qFilter, DynamicObject matDyo) {
        long matId = Objects.nonNull(matDyo) ? matDyo.getLong("id") : 0L;
        List<Long> matTypeIds = InspectProMatchHelper.getMatType(inspectProGlobalCache, matId);
        if (!CollectionUtils.isEmpty(matTypeIds)) {
            qFilter.or("entryentity.materieltype", "in", matTypeIds);
        }
    }

    private static void dealDefaultValueAndCacheKey(StringBuilder proCacheKey, MatchQfilterArgs args, QFilter qFilter) {
        proCacheKey.append(qFilter.getValue());
        proCacheKey.append(XIAHUAXIAN);
        if (!args.getValueDefault().booleanValue()) {
            billValueAllDefault = false;
        }
    }

    public static boolean isContainDept(DynamicObject org, DynamicObject dept, Map<Long, List<Long>> deptsOfOrg) {
        Long orgId = (Long)org.getPkValue();
        List deptids = deptsOfOrg.containsKey(orgId) ? deptsOfOrg.get(orgId) : PlatformOrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)false);
        if (CollectionUtils.isEmpty(deptids)) {
            return true;
        }
        Long deptId = Objects.isNull(dept) ? null : Long.valueOf(dept.getLong("id"));
        return deptids.contains(deptId);
    }

    public static boolean isContainUser(DynamicObject org, DynamicObject user) {
        QFilter qFilter = UserUtil.getQualityOrgUserByOrgid((Long)((Long)org.getPkValue()));
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty((Collection)users)) {
            List userIds = users.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            Long userId = Objects.isNull(user) ? null : Long.valueOf(user.getLong("id"));
            return userIds.contains(userId);
        }
        return false;
    }

    public static void selectInspectPro(IFormView view, IDataModel model, AbstractFormPlugin plugin, int[] selectRows, InspectDealArgs args) {
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u7269\u6599\u4fe1\u606f\u3002", (String)"InspectProMatchHelper_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject tranSacType = dataEntity.getDynamicObject(TRANSACTYPE);
        if (tranSacType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u4e8b\u52a1\u7c7b\u578b\u3002", (String)"InspectProMatchHelper_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = InspectProMatchHelper.getInspectProQFilter(args, new InspectProGlobalCache());
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("qcbd_inspectpro");
        showParameter.setFormId("bos_templatetreelistf7");
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(qFilter);
        showParameter.setListFilterParameter(lfp);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580");
        inlineStyleCss.setWidth("960");
        showParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setCustomParam("ismergerows", (Object)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "inspectpro"));
        view.showForm((FormShowParameter)showParameter);
    }

    public static void updateInspectPro(ClosedCallBackEvent closedCallBackEvent, int[] selectRows, InspectDealArgs args) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            Object entryPrimaryKeyValue = returnData.get(0).getEntryPrimaryKeyValue();
            DynamicObject inspectPro = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"qcbd_inspectpro");
            inspectPro.getDynamicObjectCollection("entryentity").removeIf(o -> !o.getPkValue().equals(entryPrimaryKeyValue));
            InspectProVoluationFactory factory = args.getFactory();
            factory.voluationFormDeal(args, new InspectProGlobalCache(), inspectPro, selectRows[0]);
        }
    }

    public static PluginProxy<InspectProPriorityPlugin> getDimensPluginProxy(InspectProPriorityPlugin customDeal) {
        PluginProxy pluginProxy = PluginProxy.create(InspectProPriorityPlugin.class, (String)"QMC_QCBD_INSPECTPROPRIORITY");
        if (null != customDeal) {
            pluginProxy = PluginProxy.create((Object)customDeal, InspectProPriorityPlugin.class, (String)"QMC_QCBD_INSPECTPROPRIORITY", null);
        }
        return pluginProxy;
    }

    private static /* synthetic */ DynamicObject lambda$getInspro$11(DynamicObject finalBillData, List inspectPros, DynamicObject finalResult, InspectProPriorityPlugin p) {
        return p.doPriorityMatching(finalBillData, inspectPros, finalResult);
    }
}

