/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.inspectpro.match.impl;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.match.MatchQfilterArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.match.factory.InspectProDimenFactory;

public class InspectProDimenBase
implements InspectProDimenFactory {
    @Override
    public QFilter buildQfilter(MatchQfilterArgs args, InspectProGlobalCache inspectProGlobalCache, DynamicObject proMatchDimen) {
        Object value;
        IDataEntityProperty property;
        DynamicObject billData = args.getBillData();
        DynamicObject entry = args.getEntry();
        long dimenId = proMatchDimen.getLong("id");
        args.setProField(this.getProField(proMatchDimen));
        args.setBillField(this.getBillField(inspectProGlobalCache, dimenId, billData.getDataEntityType().getName()));
        String billField = args.getBillField();
        if (StringUtils.isBlank((CharSequence)billField)) {
            return null;
        }
        DataEntityPropertyCollection billHeadProperties = billData.getDataEntityType().getProperties();
        if (billHeadProperties.containsKey((Object)billField)) {
            property = (IDataEntityProperty)billHeadProperties.get((Object)billField);
            value = billData.get(billField);
        } else {
            property = (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)billField);
            value = entry.get(billField);
        }
        if (property instanceof BasedataProp) {
            if (Objects.nonNull(value)) {
                if (!StringUtils.equals((CharSequence)"biztype", (CharSequence)property.getName())) {
                    args.setValueDefault(Boolean.FALSE);
                }
                value = ((DynamicObject)value).getPkValue();
            } else {
                value = 0L;
            }
        } else if (StringUtils.isNotBlank((Object)value)) {
            args.setValueDefault(Boolean.FALSE);
        }
        QFilter qFilter = new QFilter(args.getProField(), args.getCp(), value);
        this.buildExtraQfilter(args, inspectProGlobalCache, qFilter, dimenId);
        return qFilter;
    }

    protected String getProField(DynamicObject proMatchDimen) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"qcbd_inspectpro");
        String proField = proMatchDimen.getString("profield");
        if (!type.getProperties().containsKey((Object)proField)) {
            proField = "entryentity." + proField;
        }
        return proField;
    }

    protected String getBillField(InspectProGlobalCache inspectProGlobalCache, Long dimenId, String entityName) {
        String key;
        String billField = "";
        Map<String, String> fieldMapCacheMap = inspectProGlobalCache.getFieldMapCacheMap();
        String value = fieldMapCacheMap.get(key = entityName + dimenId);
        if (Objects.nonNull(value)) {
            billField = value;
        } else {
            DynamicObjectCollection fieldMapCol = QueryServiceHelper.query((String)"qcbd_pro_fieldmapconfig", (String)"entryentity.entityobject entityobject,entryentity.billfield billfield", (QFilter[])new QFilter("calfield", "=", (Object)dimenId).toArray());
            Optional<DynamicObject> fieldMapOpt = fieldMapCol.stream().filter(o -> StringUtils.equals((CharSequence)entityName, (CharSequence)o.getString("entityobject"))).findFirst();
            if (fieldMapOpt.isPresent()) {
                billField = fieldMapOpt.get().getString("billfield");
            }
            fieldMapCacheMap.put(key, billField);
        }
        return billField;
    }

    private void buildExtraQfilter(MatchQfilterArgs args, InspectProGlobalCache inspectProGlobalCache, QFilter qFilter, long dimenId) {
        if (!args.getMatchPriority().booleanValue() && 1599303399160004608L == dimenId && args.getMatchMattype().booleanValue()) {
            DynamicObject matDyo = args.getEntry().getDynamicObject(args.getBillField());
            InspectProMatchHelper.buildMatTypeQfilter(inspectProGlobalCache, qFilter, matDyo);
        }
    }
}

