/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationBase;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.ControlUtil;

public class InspectProVoluationJoinInspect
extends InspectProVoluationBase {
    @Override
    public void voluationFormDeal(InspectDealArgs args, InspectProGlobalCache inspectProGlobalCache, DynamicObject inspectPro, Integer rowIndex) {
        IFormView formView = args.getView();
        IDataModel model = formView.getModel();
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        String inspectStdKey = voluationKeyModel.getInspectStdKey();
        if (Objects.nonNull(inspectPro)) {
            DynamicObject proEntry = (DynamicObject)inspectPro.getDynamicObjectCollection("entryentity").get(0);
            DynamicObject inspectStdPro = proEntry.getDynamicObject("inspectstd");
            ControlUtil.setValueWithoutPropchange((IDataModel)model, (IFormView)formView, (String)"inspectionstd", (Object)inspectStdPro, (int)rowIndex);
            this.matchJoinProj(model.getEntryRowEntity("matintoentity", rowIndex.intValue()), proEntry);
            formView.getModel().updateCache();
            InspectCommonHelper.updateSampAndProjSampQtyCommon((int)rowIndex, (IDataModel)model, (IFormView)formView, (BigDecimal)BigDecimal.ZERO, (Boolean)Boolean.FALSE);
            formView.updateView("inspsubentity");
        } else {
            int rowCount = model.getEntryRowCount("matintoentity");
            if (rowCount > 0) {
                model.setValue(inspectStdKey, null, rowIndex.intValue());
            }
        }
    }

    @Override
    public void voluationOperateDeal(InspectDealArgs args, InspectProGlobalCache inspectProGlobalCache, DynamicObject inspectPro, Integer rowIndex) {
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        DynamicObject billData = args.getBillData();
        DynamicObjectCollection entrys = billData.getDynamicObjectCollection(voluationKeyModel.getEntryKey());
        DynamicObject entry = (DynamicObject)entrys.get(rowIndex.intValue());
        if (Objects.nonNull(inspectPro)) {
            DynamicObject proEntry = (DynamicObject)inspectPro.getDynamicObjectCollection("entryentity").get(0);
            DynamicObject inspectStdPro = proEntry.getDynamicObject("inspectstd");
            entry.set("inspectionstd", (Object)inspectStdPro);
            this.matchJoinProj(entry, proEntry);
            BigDecimal matQty = entry.getBigDecimal("materialqty");
            DynamicObject unit = entry.getDynamicObject("unit");
            String sampNumRule = InspectCommonHelper.getSampNumRule((DynamicObject)billData);
            for (DynamicObject projEntry : entry.getDynamicObjectCollection("inspsubentity")) {
                CkSampleCaleModel sampleModel = new CkSampleCaleModel(projEntry.getDynamicObject("projsamp"), matQty, unit, sampNumRule);
                InspectBillSampleHelper.setCKProjectSampleRow((DynamicObject)entry, (DynamicObject)projEntry, (CkSampleCaleResModel)InspectBillHelper.getSampleInfo((CkSampleCaleModel)sampleModel));
            }
        } else {
            entry.set("inspectionstd", null);
        }
    }

    private void matchJoinProj(DynamicObject entry, DynamicObject proEntry) {
        Map<Object, DynamicObject> proEntrySubMap = proEntry.getDynamicObjectCollection("subprojentry").stream().collect(Collectors.toMap(o -> o.get("stdentryid"), o -> o));
        DynamicObjectCollection projEntrys = entry.getDynamicObjectCollection("inspsubentity");
        projEntrys.clear();
        InspectProjModel projModel = new InspectProjModel(true);
        InspectStdHelper.setProjEntryByStd(proEntry.getDynamicObject("inspectstd"), projEntrys, projModel, true);
        for (DynamicObject projEntry : projEntrys) {
            DynamicObject proProjEntry = proEntrySubMap.get(projEntry.get("stdentryid"));
            if (Objects.nonNull(proProjEntry)) {
                projEntry.set("joindept", proProjEntry.get("joindept"));
                projEntry.set("joininspector", proProjEntry.get("joininspector"));
            }
            projEntry.set("uquuid", (Object)Uuid16.create().toString());
            projEntry.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
        }
    }
}

