/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class ImportUtil {
    private static final String BIZTYPE = "biztype";
    private static final String BILLNO = "billno";
    private static final String ORG = "org";

    private ImportUtil() {
    }

    public static boolean billUniqCheck(String billNo, String formid, Long orgId, long id) {
        boolean f = true;
        QFilter qfilter = new QFilter("billentity.billform", "=", (Object)formid);
        DynamicObjectCollection bizidlst = QueryServiceHelper.query((String)"qcbd_biztype", (String)"id", (QFilter[])new QFilter[]{qfilter});
        ArrayList<Long> biztypeid = new ArrayList<Long>();
        if (bizidlst.isEmpty()) {
            biztypeid.add(0L);
        } else {
            for (DynamicObject dynamicObject : bizidlst) {
                biztypeid.add(dynamicObject.getLong("id"));
            }
        }
        QFilter[] q = new QFilter[]{new QFilter(BIZTYPE, "in", biztypeid), new QFilter(BILLNO, "=", (Object)billNo), new QFilter(ORG, "=", (Object)orgId)};
        DynamicObjectCollection query = QueryServiceHelper.query((String)formid, (String)"id", (QFilter[])q);
        for (DynamicObject dynamicObject : query) {
            if (dynamicObject.getLong("id") == id) continue;
            f = false;
            break;
        }
        return f;
    }

    public static void countBaseQty(DynamicObject obj, DynamicObject material, DynamicObject unit, BigDecimal qty, String qtyFeild, Map<String, DynamicObject> cacheMap) {
        long m = Long.parseLong(material.getPkValue().toString());
        long u = Long.parseLong(unit.getPkValue().toString());
        DynamicObject b = material.getDynamicObject("baseunit");
        obj.set("baseunit", (Object)b);
        BigDecimal qtyConvert = BaseUnitQtyConVertUtil.getQtyConvert((Long)m, (Long)u, (BigDecimal)qty, (DynamicObject)b, cacheMap);
        obj.set(qtyFeild, (Object)qtyConvert);
    }

    public static boolean available(DynamicObject d) {
        return d == null || d.getBoolean("enable");
    }

    public static boolean locationCheck(DynamicObject warehouse, DynamicObject location) {
        boolean f = false;
        if (warehouse != null && location != null) {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            for (DynamicObject locDym : locationCol) {
                DynamicObject l = locDym.getDynamicObject("location");
                if (!location.getPkValue().toString().equals(l.getPkValue().toString())) continue;
                f = true;
                break;
            }
        }
        return f;
    }

    public static Map<Long, Set<Long>> getMatrialCfgInfos(DynamicObjectCollection entryEntity, String materialField, Long orgId) {
        Set materialIdSet = entryEntity.stream().filter(x -> null != x.getDynamicObject(materialField)).map(x -> x.getDynamicObject(materialField).getLong("id")).collect(Collectors.toSet());
        HashMap<Long, Set<Long>> materialCfgCache = new HashMap<Long, Set<Long>>(16);
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)orgId);
        qFilter.and("id", "in", materialIdSet);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection inspectTypes = QueryServiceHelper.query((String)"bd_inspect_cfg", (String)"id, entryentity.inspecttype.id inspecttype", (QFilter[])qFilter.toArray());
        for (DynamicObject inspectType : inspectTypes) {
            Long matid = inspectType.getLong("id");
            if (!materialCfgCache.containsKey(matid)) {
                materialCfgCache.put(matid, new HashSet(16));
            }
            ((Set)materialCfgCache.get(matid)).add(inspectType.getLong("inspecttype"));
        }
        return materialCfgCache;
    }

    public static boolean matCfgCheck(DynamicObject matcfg, DynamicObject bizType, Map<Long, Set<Long>> matrialCfgInfos) {
        if (null == bizType) {
            return true;
        }
        if (matcfg == null || matcfg.getPkValue() == null) {
            return false;
        }
        Long matid = matcfg.getLong("id");
        if (null == matrialCfgInfos || !matrialCfgInfos.containsKey(matid)) {
            return false;
        }
        return matrialCfgInfos.get(matid).contains(bizType.getLong("id"));
    }

    public static boolean unitOrgIsFreeze(Long id) {
        QFilter orgFilter = new QFilter(ORG, "=", (Object)id).and("isfreeze", "=", (Object)true);
        Map orgStructureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"id", (QFilter[])orgFilter.toArray());
        return !orgStructureMap.isEmpty();
    }

    public static void orgDealCache(ImportDataEventArgs e, int i, DynamicObject dyncObj, String entityName, String orgField) {
        Map sourceData = e.getSourceData();
        String orgFieldStr = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"number", "name", "enable"});
        if (sourceData != null) {
            Object object = sourceData.get(entityName);
            if (!(object instanceof List)) {
                return;
            }
            List matintoentity = (List)object;
            if (matintoentity.size() <= i) {
                return;
            }
            Object entryRowObj = matintoentity.get(i);
            if (!(entryRowObj instanceof Map)) {
                return;
            }
            Map entryRowObjMap = (Map)entryRowObj;
            Object orgFieldObj = entryRowObjMap.get(orgField);
            if (orgFieldObj instanceof Map) {
                Map orgFieldMap = (Map)orgFieldObj;
                Object id = orgFieldMap.get("id");
                if (null != id) {
                    DynamicObject bo = BusinessDataServiceHelper.loadSingleFromCache(id, (String)"bos_org", (String)orgFieldStr);
                    dyncObj.set(orgField, (Object)bo);
                }
            } else {
                dyncObj.set(orgField, null);
            }
        }
    }
}

