/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.webapi;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcbd.business.commonmodel.webapi.AbstractInspBillBaseApiPlugin;
import kd.qmc.qcbd.business.commonmodel.webapi.bean.InspBillSaveApiEventArgs;
import kd.qmc.qcbd.business.commonmodel.webapi.bean.SingleBillResult;
import org.apache.commons.lang3.ObjectUtils;

public class AbstractInspBillSaveApiPlugin
extends AbstractInspBillBaseApiPlugin {
    private static final Log logger = LogFactory.getLog(AbstractInspBillSaveApiPlugin.class);

    public void initInspBillApi(InspBillSaveApiEventArgs args) {
    }

    private void initInspBillApiAfter(InspBillSaveApiEventArgs args) {
        if (args.getBodyParams() == null || args.getBodyParams().isEmpty()) {
            Map bodyParams = (Map)args.getParams().get("body");
            args.setBodyParams(bodyParams);
            args.setIsResetBodyParams(Boolean.TRUE);
        }
        if (!args.getIsResetBodyParams().booleanValue()) {
            args.setBodyParams(args.getData());
        }
    }

    protected String bizCheck(InspBillSaveApiEventArgs args, Map<String, Object> data) {
        boolean ilegalData;
        List matintoentityDatas = (List)data.get("matintoentity");
        if (CollectionUtils.isNotEmpty((Collection)matintoentityDatas) && (ilegalData = matintoentityDatas.stream().anyMatch(x -> !(x.get("rinsqty") instanceof Integer)))) {
            return ResManager.loadKDString((String)"\u6837\u672c\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"AbstractInspBillSaveApiPlugin_2", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
        }
        return "";
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        super.doCustomService(params);
        logger.info("InspBillSaveApi\u63a5\u53e3\u4f20\u5165\u53c2\u6570\uff1a" + JSON.toJSONString(params));
        InspBillSaveApiEventArgs args = new InspBillSaveApiEventArgs();
        args.setParams(params);
        this.initInspBillApi(args);
        this.initInspBillApiAfter(args);
        this.structInspBills(args);
        ApiResult res = this.getDealSaveResult(args);
        return res;
    }

    public ApiResult getDealSaveResult(InspBillSaveApiEventArgs args) {
        ApiResult result = null;
        Map<String, Object> params = args.getBodyParams();
        if (null == params) {
            return result;
        }
        String entityKey = (String)params.get("formid");
        args.setEntityKey(entityKey);
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            result = ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199formid\u53c2\u6570\u3002", (String)"AbstractInspBillSaveApiPlugin_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), (String)"1001");
        } else {
            logger.info("---param formid = " + entityKey);
            List datas = (List)params.get("datas");
            ArrayList<SingleBillResult> allResults = new ArrayList<SingleBillResult>(datas.size());
            ArrayList<Map<String, Object>> impDatas = new ArrayList<Map<String, Object>>(100);
            TreeMap<Integer, Integer> mapping = new TreeMap<Integer, Integer>();
            int dIndex = 0;
            for (int i = 0; i < datas.size(); ++i) {
                Map data = (Map)datas.get(i);
                String message = null;
                message = this.bizCheck(args, data);
                SingleBillResult billResult = new SingleBillResult();
                billResult.setDIndex(i);
                billResult.setMessage(message);
                allResults.add(billResult);
                if (!StringUtils.isEmpty((CharSequence)message)) continue;
                impDatas.add(data);
                mapping.put(i, dIndex);
                ++dIndex;
            }
            if (!impDatas.isEmpty()) {
                ApiResult exeResult = this.doProcess(args, impDatas, "save");
                result = datas.size() == impDatas.size() ? exeResult : this.mergeResult(allResults, mapping, exeResult);
            } else {
                ArrayList<Map<String, Object>> sDatas = new ArrayList<Map<String, Object>>(allResults.size());
                for (int i = 0; i < allResults.size(); ++i) {
                    SingleBillResult billResult = (SingleBillResult)allResults.get(i);
                    sDatas.add(SingleBillResult.toMap(billResult));
                }
                result = new ApiResult();
                result.setData(sDatas);
                result.setSuccess(false);
                result.setMessage("");
                result.setErrorCode("");
            }
        }
        return result;
    }

    public void structInspBills(InspBillSaveApiEventArgs args) {
        Map<String, Object> param = args.getBodyParams();
        if (null == param) {
            return;
        }
        List datas = (List)param.get("datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map data = (Map)datas.get(i);
            if (data == null) continue;
            this.structInspSingleBill(data);
        }
    }

    private void structInspSingleBill(Map<String, Object> data) {
        List matintoentityDatas = (List)data.get("matintoentity");
        if (matintoentityDatas == null) {
            return;
        }
        for (int i = 0; i < matintoentityDatas.size(); ++i) {
            int sampCount;
            Map matintoentityData = (Map)matintoentityDatas.get(i);
            Object rinsQty = matintoentityData.get("rinsqty");
            if (!(rinsQty instanceof Integer) || (sampCount = ((Integer)rinsQty).intValue()) <= 0) continue;
            ArrayList sampList = new ArrayList(sampCount);
            for (int j = 0; j < sampCount; ++j) {
                HashMap<String, String> sampMap = new HashMap<String, String>(16);
                sampMap.put("samplenum", String.format(ResManager.loadKDString((String)"\u6837\u672c%s", (String)"AbstractInspBillSaveApiPlugin_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), j + 1));
                sampList.add(sampMap);
            }
            matintoentityData.put("subsampleresentity", sampList);
            List inspsubentity = (List)matintoentityData.get("inspsubentity");
            if (inspsubentity == null) continue;
            for (int j = 0; j < inspsubentity.size(); ++j) {
                Map inspsubentityData = (Map)inspsubentity.get(j);
                if (inspsubentityData == null) continue;
                inspsubentityData.put("examples_tag", JSON.toJSONString(inspsubentityData.get("examples")));
                inspsubentityData.put("examples", "");
            }
        }
    }

    protected ApiResult doProcess(InspBillSaveApiEventArgs args, List<Map<String, Object>> impDatas, String opName) {
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(16);
        dataMap.put("datas", impDatas);
        String entityTypeId = FormMetadataCache.getFormConfig((String)args.getEntityKey()).getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)opName);
        webApi.initialize(args.getEntityKey(), dataMap);
        return webApi.execute();
    }

    private ApiResult mergeResult(List<SingleBillResult> allResults, Map<Integer, Integer> mapping, ApiResult exeResult) {
        List exeDatas = (List)exeResult.getData();
        TreeMap<Integer, Map> mappingResult = new TreeMap<Integer, Map>();
        block0: for (int i = 0; i < exeDatas.size(); ++i) {
            HashMap saveData = (HashMap)exeDatas.get(i);
            for (Map.Entry<Integer, Integer> entry : mapping.entrySet()) {
                if (i != entry.getValue()) continue;
                int actIndex = entry.getKey();
                Map actRet = (Map)ObjectUtils.clone((Object)saveData);
                actRet.replace("dindex", actIndex);
                mappingResult.put(actIndex, actRet);
                continue block0;
            }
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(allResults.size());
        for (int i = 0; i < allResults.size(); ++i) {
            SingleBillResult billResult = allResults.get(i);
            int actIndex = billResult.getDIndex();
            Map actRet = (Map)mappingResult.get(actIndex);
            if (actRet != null) {
                datas.add(actRet);
                continue;
            }
            datas.add(SingleBillResult.toMap(billResult));
        }
        ApiResult merge = new ApiResult();
        merge.setData(datas);
        merge.setSuccess(false);
        merge.setMessage("");
        merge.setErrorCode("");
        return merge;
    }
}

