/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.opplugin.evtservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.QcnpFreezeServiceHelper;

public class EventServiceImadjustAction
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(EventServiceImadjustAction.class);

    public Object handleEvent(KDBizEvent evt) {
        try {
            String opKey;
            EntityEvent event = (EntityEvent)evt;
            List businessKeys = event.getBusinesskeys();
            String entityNumber = event.getEntityNumber();
            switch (opKey = ((EntityEvent)evt).getOperation()) {
                case "audit": {
                    this.doAuditImadjust(businessKeys, entityNumber);
                    break;
                }
                case "unaudit": {
                    this.doUnAuditImadjust(businessKeys, entityNumber);
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return evt.getEventId();
    }

    private void doUnAuditImadjust(List<String> businessKeys, String entityNumber) throws Exception {
        Map<Long, List<DynamicObject>> imAdjustBillInfos = this.getImAdjustInfos(businessKeys);
        if (imAdjustBillInfos.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> paraMap = this.getAppPlanEntryIds(businessKeys, entityNumber);
        QcnpFreezeServiceHelper qcnpFreezeServiceHelper = new QcnpFreezeServiceHelper();
        DynamicObject[] appPlanObjs = this.dealComQty(imAdjustBillInfos, qcnpFreezeServiceHelper.getDynamicObjects(paraMap), "unaudit");
        qcnpFreezeServiceHelper.freezeInv(paraMap, appPlanObjs);
    }

    private void doAuditImadjust(List<String> businessKeys, String entityNumber) throws Exception {
        Map<Long, List<DynamicObject>> imAdjustBillInfos = this.getImAdjustInfos(businessKeys);
        if (imAdjustBillInfos.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> paraMap = this.getAppPlanEntryIds(businessKeys, entityNumber);
        QcnpFreezeServiceHelper qcnpFreezeServiceHelper = new QcnpFreezeServiceHelper();
        DynamicObject[] appPlanObjs = this.dealComQty(imAdjustBillInfos, qcnpFreezeServiceHelper.getDynamicObjects(paraMap), "audit");
        qcnpFreezeServiceHelper.unfreezeInv(paraMap, appPlanObjs, true);
    }

    public Map<Long, List<Long>> getAppPlanEntryIds(List<String> businessKeys, String entityNumber) {
        HashMap<Long, List<Long>> paraMap = new HashMap<Long, List<Long>>(16);
        if (businessKeys.isEmpty()) {
            return paraMap;
        }
        List<Long> idList = businessKeys.stream().map(o -> Long.parseLong(o)).collect(Collectors.toList());
        Map inspectMap = BFTrackerServiceHelper.findDirtSourceBills((String)entityNumber, (Long[])idList.toArray(new Long[0]));
        if (inspectMap.isEmpty()) {
            return paraMap;
        }
        HashSet<Long> sourceIds = new HashSet<Long>();
        for (Map.Entry entry : inspectMap.entrySet()) {
            List listBFrow = (List)entry.getValue();
            if (listBFrow.isEmpty()) continue;
            for (BFRow row : listBFrow) {
                Long billId = row.getSId().getBillId();
                sourceIds.add(billId);
            }
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"qcnp_invinspectplan", (String)"id,materialentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIds)});
        if (dynamicObjects.length > 0) {
            for (DynamicObject obj : dynamicObjects) {
                Long id = obj.getLong("id");
                DynamicObjectCollection materialentry = obj.getDynamicObjectCollection("materialentry");
                ArrayList<Long> entryIdList = new ArrayList<Long>();
                for (DynamicObject dyn : materialentry) {
                    entryIdList.add(dyn.getLong("id"));
                }
                paraMap.put(id, entryIdList);
            }
        }
        return paraMap;
    }

    private Map<Long, List<DynamicObject>> getImAdjustInfos(List<String> businessKeys) {
        QFilter filter = new QFilter("billentry.srcbillentity", "=", (Object)"1437089692662117376").and("id", "in", businessKeys.stream().map(o -> Long.parseLong(o)).collect(Collectors.toSet()));
        String selectField = "billentry.srcbillentryid, billentry.baseqty, billentry.qty";
        return QueryServiceHelper.query((String)"im_adjustbill", (String)selectField, (QFilter[])filter.toArray()).stream().collect(Collectors.groupingBy(x -> x.getLong("billentry.srcbillentryid")));
    }

    public DynamicObject[] dealComQty(Map<Long, List<DynamicObject>> imAdjustBillInfos, DynamicObject[] appPlanObjs, String operate) {
        for (DynamicObject appPlanObj : appPlanObjs) {
            DynamicObjectCollection materialentry = appPlanObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject matRow : materialentry) {
                this.dealMatRowComQty(imAdjustBillInfos, operate, matRow);
            }
        }
        SaveServiceHelper.save((DynamicObject[])appPlanObjs);
        return appPlanObjs;
    }

    private void dealMatRowComQty(Map<Long, List<DynamicObject>> imAdjustBillInfos, String operate, DynamicObject matRow) {
        String scsystem = matRow.getString("scsystem");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"inv", (CharSequence)scsystem)) {
            return;
        }
        BigDecimal bcheckcomqty = BigDecimal.ZERO;
        BigDecimal checkcomqty = BigDecimal.ZERO;
        DynamicObjectCollection subEntry = matRow.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subRow : subEntry) {
            Long subRowId = subRow.getLong("id");
            if (!"B".equals(subRow.getString("inspresult")) || !imAdjustBillInfos.containsKey(subRowId)) continue;
            List<DynamicObject> relaObjs = imAdjustBillInfos.get(subRowId);
            for (DynamicObject relaObj : relaObjs) {
                bcheckcomqty = bcheckcomqty.add(relaObj.getBigDecimal("billentry.baseqty"));
                checkcomqty = checkcomqty.add(relaObj.getBigDecimal("billentry.qty"));
            }
        }
        if ("audit".equals(operate)) {
            matRow.set("bcheckcomqty", (Object)matRow.getBigDecimal("bcheckcomqty").add(bcheckcomqty));
            matRow.set("checkcomqty", (Object)matRow.getBigDecimal("checkcomqty").add(checkcomqty));
            if (matRow.getBigDecimal("baseqty").compareTo(matRow.getBigDecimal("bcheckcomqty")) == 0) {
                matRow.set("checkcomstatus", (Object)"A");
            }
        } else if ("unaudit".equals(operate)) {
            matRow.set("bcheckcomqty", (Object)matRow.getBigDecimal("bcheckcomqty").subtract(bcheckcomqty));
            matRow.set("checkcomqty", (Object)matRow.getBigDecimal("checkcomqty").subtract(checkcomqty));
            matRow.set("checkcomstatus", (Object)"");
        }
    }
}

