/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.opplugin.inspectappplan;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.InvPlatformHelper;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.QcnpFreezeServiceHelper;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.dtxmodel.FreezeParam;
import kd.qmc.qcnp.opplugin.validator.ApplyInspectAuditValidators;

public class ApplyInspectAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ApplyInspectAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("materialentry.id");
        e.getFieldKeys().add("materialentry.seq");
        e.getFieldKeys().add("materialentry.applyqty");
        e.getFieldKeys().add("materialentry.baseqty");
        e.getFieldKeys().add("materialentry.materialid");
        e.getFieldKeys().add("materialentry.nowinvid");
        e.getFieldKeys().add("materialentry.execcasenum");
        e.getFieldKeys().add("materialentry.invfrezstatus");
        e.getFieldKeys().add("materialentry.checkcomstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ApplyInspectAuditValidators());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntitys = e.getDataEntities();
        Map freezeParaMap = InvPlatformHelper.getNeedFreezeOrUnFreezePara((DynamicObject[])dataEntitys, (String)"");
        logger.info("\u5ba1\u6838\u51bb\u7ed3\u5355\u636e\u4fe1\u606f\uff1a" + freezeParaMap);
        if (freezeParaMap.isEmpty()) {
            return;
        }
        FreezeParam freezeParam = new FreezeParam();
        freezeParam.setFreezeParamMap(freezeParaMap);
        new QcnpFreezeServiceHelper().freezeInv(freezeParaMap, dataEntitys);
    }
}

