/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.opplugin.validator;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;

public class ApplyInspectAuditValidators
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        RequestContext rc = RequestContext.get();
        Long userId = rc.getCurrUserId();
        HashSet<Long> materIdSet = new HashSet<Long>();
        boolean interFlag = false;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataObj = dataEntity.getDataEntity();
            DynamicObjectCollection materEntry = dataObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject materObj : materEntry) {
                Boolean infreeStatu;
                Long materId = materObj.getDynamicObject("materialid").getLong("id");
                materIdSet.add(materId);
                DynamicObject execSchem = materObj.getDynamicObject("execcasenum");
                if (Objects.isNull(execSchem) || !(infreeStatu = Boolean.valueOf(execSchem.getBoolean("inspectfreezeinv"))).booleanValue()) continue;
                interFlag = true;
            }
        }
        if (interFlag) {
            JSONObject returnObj = ImmInvModelHelper.getInvInfos(materIdSet, (Long)userId);
            JSONArray cols = returnObj.getJSONArray("col");
            this.checkEntry(dataEntities, cols);
        }
    }

    private void checkEntry(ExtendedDataEntity[] dataEntities, JSONArray cols) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataObj = dataEntity.getDataEntity();
            DynamicObjectCollection materEntry = dataObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject materObj : materEntry) {
                Long materId = materObj.getLong("nowinvid");
                DynamicObject execSchem = materObj.getDynamicObject("execcasenum");
                Integer seq = materObj.getInt("seq");
                if (Objects.isNull(materId) || Objects.isNull(execSchem) || !execSchem.getBoolean("inspectfreezeinv")) continue;
                if (Objects.isNull(cols) || cols.isEmpty()) {
                    String finStr = ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5373\u65f6\u5e93\u5b58\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ApplyInspectAuditValidators_1", (String)"qmc-qcnp-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, finStr);
                    return;
                }
                Optional<Object> first = cols.stream().filter(x -> materId.equals(((JSONObject)x).getLong("id"))).findFirst();
                if (!first.isPresent()) continue;
                JSONObject invObj = (JSONObject)first.get();
                String style = execSchem.getString("inspectnumstyle");
                BigDecimal applyQty = materObj.getBigDecimal("applyqty");
                BigDecimal qty = invObj.getBigDecimal("qty");
                BigDecimal lockQty = invObj.getBigDecimal("lockqty");
                if ("B".equals(style)) {
                    BigDecimal subQty = qty.subtract(lockQty);
                    if (applyQty.compareTo(subQty) == 0) continue;
                    this.giveTip(dataEntity, seq);
                    continue;
                }
                if (applyQty.compareTo(qty) == 0) continue;
                this.giveTip(dataEntity, seq);
            }
        }
    }

    private void giveTip(ExtendedDataEntity dataEntity, Integer seq) {
        String finStr = ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\uff1a\u5373\u65f6\u5e93\u5b58\u6570\u91cf\u6216\u53ef\u7528\u91cf\u4e0e\u5e93\u5b58\u8bf7\u68c0\u5355\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u5e93\u5b58\u51bb\u7ed3\uff1f", (String)"ApplyInspectAuditValidators_0", (String)"qmc-qcnp-opplugin", (Object[])new Object[0]);
        String myStr = String.format(finStr, seq);
        this.addWarningMessage(dataEntity, myStr);
    }
}

