/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.opplugin.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class LeftQtyValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String entity = dataEntities[0].getDataEntity().getDataEntityType().getName();
        Stream<ExtendedDataEntity> dataEntityStream = Arrays.stream(dataEntities);
        Set srcBillIds = dataEntityStream.map(x -> x.getBillPkId()).collect(Collectors.toSet());
        DynamicObjectCollection billRowInfos = this.getBillRowInfos(dataEntities, entity);
        Map checkObjInfo = InventoryInspHelper.getCheckObjInfo(srcBillIds, (DynamicObjectCollection)billRowInfos);
        Map inspPlanInfo = InventoryInspHelper.getInspPlanInfo((Map)checkObjInfo, (String[])new String[0]);
        Map<Long, Map<Long, Map<DynamicObject, BigDecimal>>> inspPlanLeftQty = this.getInspPlanLeftQty(inspPlanInfo);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if ("qcnp_invbalinspec".equals(entity)) {
                this.validateInspectObj(checkObjInfo, inspPlanLeftQty, dataEntity);
                continue;
            }
            if (!"qcnp_invbalbaddeal".equals(entity)) continue;
            this.validateIBadDealObj(checkObjInfo, inspPlanLeftQty, dataEntity);
        }
    }

    private void validateInspectObj(Map<Long, List<DynamicObject>> checkObjInfo, Map<Long, Map<Long, Map<DynamicObject, BigDecimal>>> inspPlanLeftQty, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        DynamicObjectCollection matEntry = billObj.getDynamicObjectCollection("matintoentity");
        int size = matEntry.size();
        for (int i = 0; i < size; ++i) {
            Map<Long, Map<DynamicObject, BigDecimal>> billLeftQty;
            DynamicObject matRow = (DynamicObject)matEntry.get(i);
            Date newArrDate = matRow.getDate("newarrdate");
            Long chkObjId = matRow.getLong("chkobjid");
            if (!checkObjInfo.containsKey(chkObjId)) continue;
            DynamicObject chkObj = checkObjInfo.get(chkObjId).get(0);
            Long srcBillId = chkObj.getLong("srcbillid");
            Long srcEntryId = chkObj.getLong("srcentryid");
            if (!inspPlanLeftQty.containsKey(srcBillId) || !(billLeftQty = inspPlanLeftQty.get(srcBillId)).containsKey(srcEntryId)) continue;
            Map<DynamicObject, BigDecimal> matRowLeftQty = billLeftQty.get(srcEntryId);
            Set<Map.Entry<DynamicObject, BigDecimal>> entries = matRowLeftQty.entrySet();
            for (Map.Entry<DynamicObject, BigDecimal> entry : entries) {
                DynamicObject subEntryRow = entry.getKey();
                Date newArrDateTemp = subEntryRow.getDate("newarrdate");
                String inspResult = subEntryRow.getString("inspresult");
                Boolean isMatch = "A".equals(inspResult) && (null == newArrDate && null == newArrDateTemp || null != newArrDate && newArrDate.equals(newArrDateTemp));
                if (!isMatch.booleanValue()) continue;
                BigDecimal baseQualiQty = matRow.getBigDecimal("basequaliqty");
                matRowLeftQty.put(subEntryRow, entry.getValue().subtract(baseQualiQty));
                if (matRowLeftQty.get(subEntryRow).compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\uff1a\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u5e93\u5b58\u8c03\u6574\u6570\u91cf\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InspectLeftQtyValidator_0", (String)"qmc-qcnp-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }

    private void validateIBadDealObj(Map<Long, List<DynamicObject>> checkObjInfo, Map<Long, Map<Long, Map<DynamicObject, BigDecimal>>> inspPlanLeftQty, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        DynamicObjectCollection matEntry = billObj.getDynamicObjectCollection("materialentry");
        int size = matEntry.size();
        for (int i = 0; i < size; ++i) {
            Map<Long, Map<DynamicObject, BigDecimal>> billLeftQty;
            Long chkObjId;
            DynamicObject matRow = (DynamicObject)matEntry.get(i);
            DynamicObject newHandMode = matRow.getDynamicObject("newhandmode");
            if (InventoryInspHelper.PICK.equals(DynamicObjDataUtil.getDynamicObjectLongData((DynamicObject)newHandMode, (String)"id")) || !checkObjInfo.containsKey(chkObjId = Long.valueOf(matRow.getLong("chkobjid")))) continue;
            DynamicObject chkObj = checkObjInfo.get(chkObjId).get(0);
            Long srcBillId = chkObj.getLong("srcbillid");
            Long srcEntryId = chkObj.getLong("srcentryid");
            if (!inspPlanLeftQty.containsKey(srcBillId) || !(billLeftQty = inspPlanLeftQty.get(srcBillId)).containsKey(srcEntryId)) continue;
            Map<DynamicObject, BigDecimal> matRowLeftQty = billLeftQty.get(srcEntryId);
            Set<Map.Entry<DynamicObject, BigDecimal>> entries = matRowLeftQty.entrySet();
            for (Map.Entry<DynamicObject, BigDecimal> entry : entries) {
                DynamicObject subEntryRow = entry.getKey();
                String inspResult = subEntryRow.getString("inspresult");
                DynamicObject handMethod = subEntryRow.getDynamicObject("handmethod");
                if (!"B".equals(inspResult) || !newHandMode.getPkValue().equals(handMethod.getPkValue())) continue;
                BigDecimal baseQty = matRow.getBigDecimal("baseqty");
                matRowLeftQty.put(subEntryRow, entry.getValue().subtract(baseQty));
                if (matRowLeftQty.get(subEntryRow).compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\uff1a\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u5e93\u5b58\u8c03\u6574\u6570\u91cf\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InspectLeftQtyValidator_0", (String)"qmc-qcnp-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }

    private Map<Long, Map<Long, Map<DynamicObject, BigDecimal>>> getInspPlanLeftQty(Map<Long, DynamicObject> inspPlanInfo) {
        HashMap<Long, Map<Long, Map<DynamicObject, BigDecimal>>> leftQtyMap = new HashMap<Long, Map<Long, Map<DynamicObject, BigDecimal>>>(16);
        inspPlanInfo.forEach((billId, inspPlanObj) -> {
            HashMap billQtyMap = new HashMap(16);
            leftQtyMap.put((Long)billId, billQtyMap);
            DynamicObjectCollection matEntry = inspPlanObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject matRow : matEntry) {
                HashMap<DynamicObject, BigDecimal> matQtyMap = new HashMap<DynamicObject, BigDecimal>(16);
                billQtyMap.put(matRow.getLong("id"), matQtyMap);
                DynamicObjectCollection subEntry = matRow.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subObj : subEntry) {
                    matQtyMap.put(subObj, subObj.getBigDecimal("dealqtybase").subtract(subObj.getBigDecimal("invmodqtybase")));
                }
            }
        });
        return leftQtyMap;
    }

    private DynamicObjectCollection getBillRowInfos(ExtendedDataEntity[] dataEntities, String entity) {
        DynamicObjectCollection retCollection = new DynamicObjectCollection();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            if ("qcnp_invbalinspec".equals(entity)) {
                retCollection.addAll((Collection)billObj.getDynamicObjectCollection("matintoentity"));
                continue;
            }
            if (!"qcnp_invbalbaddeal".equals(entity)) continue;
            retCollection.addAll((Collection)billObj.getDynamicObjectCollection("materialentry"));
        }
        return retCollection;
    }
}

