/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.formplugin.inspectbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.InvPlatformHelper;

public class InvInspectBillPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener {
    private static final String MATERIALID = "materialid";
    private static final String NEWARRDATE = "newarrdate";
    private static final String INVORG = "invorg";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void initialize() {
        super.initialize();
        EntryGrid matEntryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        if (matEntryGrid != null) {
            matEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        if ("matintoentity".equals(entityName)) {
            for (RowDataEntity rowData : e.getRowDataEntities()) {
                int rowIndex = rowData.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{NEWARRDATE});
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String status = this.getModel().getDataEntity().getString("billstatus");
        if (!"A".equals(status)) {
            return;
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.name().equals(operationStatus.name())) {
            return;
        }
        if (e.getRows().size() <= 0) {
            return;
        }
        ArrayList paraList = new ArrayList();
        for (RowDataEntity row : e.getRows()) {
            DynamicObject rowDy = row.getDataEntity();
            if (rowDy != null && rowDy.getDynamicObject(MATERIALID) != null && rowDy.getDynamicObject(INVORG) != null) {
                HashMap<String, Long> paraMap = new HashMap<String, Long>(16);
                paraMap.put("materielId", DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)rowDy.getDynamicObject(MATERIALID)));
                paraMap.put("orgId", DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)rowDy.getDynamicObject(INVORG)));
                paraList.add(paraMap);
            }
            if (rowDy == null) continue;
            this.setFieldLock(NEWARRDATE, rowDy.getInt("seq") - 1, false);
        }
        if (paraList.isEmpty()) {
            return;
        }
        Map resMap = InvPlatformHelper.checkShelfLife(paraList);
        for (RowDataEntity rowDataEntity : e.getRows()) {
            int rowIndex = rowDataEntity.getRowIndex();
            DynamicObject rowDy = rowDataEntity.getDataEntity();
            if (rowDy == null || rowDy.getDynamicObject(MATERIALID) == null || rowDy.getDynamicObject(INVORG) == null) continue;
            DynamicObject invOrg = rowDy.getDynamicObject(INVORG);
            Long materId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)rowDy.getDynamicObject(MATERIALID));
            Long orgId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)invOrg);
            String key = orgId + "_" + materId;
            HashMap mapObj = (HashMap)resMap.get(key);
            if (Objects.isNull(mapObj) || mapObj.isEmpty()) continue;
            Boolean flag = (Boolean)mapObj.get("success");
            this.setFieldLock(NEWARRDATE, rowIndex, flag);
        }
    }

    private void setFieldLock(String name, int index, Boolean flag) {
        this.getView().setEnable(flag, index, new String[]{name});
    }
}

