/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.formplugin.inventory;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcnp.business.helper.datasource.AbstractDataSource;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;

public class ImmInvModelBotp
extends AbstractConvertPlugIn {
    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        super.beforeBuildGroupMode(e);
        DynamicObject invScheme = this.getInvScheme();
        if (null == invScheme) {
            return;
        }
        AbstractDataSource dataSource = ImmInvModelHelper.getDataSource((String)invScheme.getString("datasource"));
        List splitReasons = invScheme.getDynamicObjectCollection("entryentity").stream().map(x -> String.format("%s.%s", "exedetail", dataSource.getSplitStr(x.getString("splitreason")))).collect(Collectors.toList());
        for (String splitReason : splitReasons) {
            int indexPoint = splitReason.lastIndexOf(".");
            String groupKey = splitReason.substring(indexPoint + 1);
            if (StringUtils.isEmpty((CharSequence)e.getHeadGroupKey())) {
                e.setHeadGroupKey(groupKey);
                continue;
            }
            e.setHeadGroupKey(String.format("%s,%s", e.getHeadGroupKey(), groupKey));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        DynamicObject invScheme = this.getInvScheme();
        if (null == invScheme) {
            return;
        }
        String dataSource = invScheme.getString("datasource");
        String scSystem = "sbd";
        if ("A".equals(dataSource)) {
            scSystem = "inv";
        }
        ExtendedDataEntitySet targetSet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        for (ExtendedDataEntity entity : entitys = targetSet.FindByEntityKey(tgtMainType)) {
            DynamicObject dataObj = entity.getDataEntity();
            DynamicObjectCollection matEntry = dataObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject matRow : matEntry) {
                matRow.set("scsystem", (Object)scSystem);
            }
        }
    }

    private DynamicObject getInvScheme() {
        String invSchemeId = this.getOption().getVariableValue("invSchemeId", "");
        if (StringUtils.isEmpty((CharSequence)invSchemeId)) {
            return null;
        }
        DynamicObject[] invSchemes = InventoryInspHelper.getInvSchemes((QFilter)new QFilter("id", "=", (Object)Long.parseLong(invSchemeId)), (String[])new String[0]);
        if (0 == invSchemes.length) {
            return null;
        }
        return invSchemes[0];
    }
}

