/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.formplugin.inventory;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcbd.common.util.ControlUtil;

public class InspectPlanBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    public void initialize() {
        super.initialize();
        EntryGrid matEntryGrid = (EntryGrid)this.getView().getControl("materialentry");
        if (matEntryGrid != null) {
            matEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid eg = (EntryGrid)this.getView().getControl("materialentry");
        if (eg != null) {
            eg.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"applyqty", null, (boolean)true);
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"baseqty", null, (boolean)true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShowValue();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("mattab");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"materialentry", (CharSequence)entryGrid.getKey())) {
            this.setShowValue();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            Long pkValue = this.getModel().getDataEntity().getLong("id");
            if (0L == pkValue) {
                return;
            }
            DynamicObject objFromDb = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.getView().getEntityId());
            DynamicObjectCollection materialEntryFormDb = objFromDb.getDynamicObjectCollection("materialentry");
            DynamicObjectCollection materialEntry = this.getModel().getEntryEntity("materialentry");
            Set entryIdSet = materialEntry.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
            Set removedEntry = materialEntryFormDb.stream().filter(x -> !entryIdSet.contains(x.getPkValue())).collect(Collectors.toSet());
            Set billDelSet = removedEntry.stream().filter(x -> "qcnp_imminv_model".equals(x.getString("srcbillentity"))).map(x -> x.getLong("srcbillid")).collect(Collectors.toSet());
            Set entryDelSet = removedEntry.stream().filter(x -> "qcnp_imminv_model".equals(x.getString("srcbillentity"))).map(x -> x.getLong("srcbillentryid")).collect(Collectors.toSet());
            InventoryInspHelper.deleteImminvEntry(billDelSet, entryDelSet);
            HashSet<Long> invIdSet = new HashSet<Long>();
            HashSet<Long> materialidSet = new HashSet<Long>();
            for (DynamicObject entryRow : removedEntry) {
                if (!entryRow.getBoolean("incheck")) continue;
                Long invId = entryRow.getLong("nowinvid");
                if (invId > 0L) {
                    invIdSet.add(invId);
                    continue;
                }
                DynamicObject material = entryRow.getDynamicObject("materialid");
                if (null == material) continue;
                materialidSet.add(material.getLong("id"));
            }
            HashSet<Long> ignoreIds = new HashSet<Long>();
            ignoreIds.add(pkValue);
            InventoryInspHelper.updateInvInspInfos(invIdSet, materialidSet, (Boolean)Boolean.FALSE, ignoreIds);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "previousentry": {
                this.clickMaterialRow();
                break;
            }
            case "nextentry": {
                this.clickMaterialRow();
                break;
            }
            case "audit": {
                this.refreshFreezeStatus();
                break;
            }
            case "unaudit": {
                this.refreshFreezeStatus();
                break;
            }
        }
    }

    private void clickMaterialRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        entryGrid.entryRowClick(Integer.valueOf(this.getModel().getEntryCurrentRowIndex("materialentry")));
    }

    private void setShowValue() {
        IDataModel model = this.getModel();
        int matRowIndex = model.getEntryCurrentRowIndex("materialentry");
        model.setValue("materialcfgshow", model.getValue("materialcfgid", matRowIndex));
        model.setValue("qualifqtyshow", model.getValue("qualifqty", matRowIndex));
        model.setValue("unqualifqtyshow", model.getValue("unqualifqty", matRowIndex));
    }

    private void refreshFreezeStatus() {
        Long id = this.getModel().getDataEntity().getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"qcnp_invinspectplan", (String)"billno,materialentry.id,materialentry.invfrezstatus,materialentry.seq", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("materialentry");
        for (DynamicObject entry : entryEntity) {
            Long entryId = entry.getLong("id");
            Optional<DynamicObject> resObjOpt = dynamicObjects.stream().filter(e -> entryId.equals(e.getLong("materialentry.id"))).findFirst();
            DynamicObject resObj = resObjOpt.get();
            this.getModel().setValue("invfrezstatus", resObj.get("materialentry.invfrezstatus"), entry.getInt("seq") - 1);
        }
    }
}

