/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.formplugin.inventory;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.OrgUnitUtil;
import kd.qmc.qcnp.business.helper.datasource.AbstractDataSource;
import kd.qmc.qcnp.business.helper.datasource.IDataSource;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;
import kd.qmc.qcnp.business.helper.datasource.args.InvGlobalArgs;
import kd.qmc.qcnp.business.helper.datasource.args.SchemeParamArgs;

public class InventoryExePlanFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(InventoryExePlanFormPlugin.class);
    private static final String INSPINFO_CACHEID = "inspinfoCacheid";
    private static final String PLANDETAIL_CACHEID = "plandetailCacheid";
    private static final String SHOW_INSPECT_APPLAN = "showInspectApplan";
    private static final String FILTERCONTAINER = "filtercontainerap";
    private static final String DRAW_CALLID = "drawCallid";
    private static final String MUST_INPUT_ERR = "mustInputErr";
    private static final String REPEAT_ERR = "repeatErr";
    private static final String INCHECK_ERR = "incheckErr";
    private static final String EXESCHEME_NAME = "exescheme.name";

    public void initialize() {
        super.initialize();
        this.initCondContainer();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "inspecorg", "unit", "applyorg");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refresh();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "inspecorg": {
                this.inspectOrgBeforeF7(e);
                break;
            }
            case "unit": {
                this.unitBeforeF7(e);
                break;
            }
            case "applyorg": {
                this.applyOrgBeforeF7(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDataArr;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        block6: for (ChangeData changeData : changeDataArr = e.getChangeSet()) {
            switch (name) {
                case "applyorg": {
                    this.applyOrgChange(changeData);
                    continue block6;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "refresh": {
                this.refresh();
                break;
            }
            case "draw": {
                this.beforeDraw();
                break;
            }
            case "dispose": 
            case "close": {
                this.clearCache();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (SHOW_INSPECT_APPLAN.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String targetIdStr = this.getPageCache().get("targetIds");
            List targetIds = (List)JSON.parse((String)targetIdStr);
            InventoryInspHelper.showInspectPlanList((IFormView)this.getView(), (List)targetIds);
        } else if (DRAW_CALLID.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.draw();
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private void initCondContainer() {
        FilterContainer container = (FilterContainer)this.getControl(FILTERCONTAINER);
        if (null == container) {
            return;
        }
        container.setBillFormId("qcnp_invinsp_filtermodel");
        container.setEntityId("qcnp_invinsp_filtermodel");
        this.addSearchClickListener(container);
        container.addSetFilterListeners(evt -> {
            CommonBaseDataFilterColumn col = (CommonBaseDataFilterColumn)evt.getSource();
            ArrayList<QFilter> qfilterLst = new ArrayList<QFilter>();
            switch (col.getFieldName()) {
                case "exescheme.name": {
                    this.setExeschemeFilter(qfilterLst);
                    break;
                }
            }
            if (qfilterLst.size() > 0) {
                evt.setCustomQFilters(qfilterLst);
            }
        });
        container.addBeforeF7SelectListener(evt -> evt.getCustomParams().put("isshowdisabled", "true"));
        container.addFilterContainerInitListener(evt -> {
            Object[] invSchemes = this.getInvSchemes(new LinkedList<QFilter>(), null, "number");
            if (ArrayUtils.isNotEmpty((Object[])invSchemes)) {
                List filterColums = evt.getCommonFilterColumns();
                FilterColumn exeSchemeFilter = filterColums.stream().filter(x -> EXESCHEME_NAME.equalsIgnoreCase(x.getFieldName())).findFirst().get();
                exeSchemeFilter.setDefaultValues(new Object[]{invSchemes[0].getPkValue().toString()});
            }
        });
    }

    private void getExePlanDetail(InvGlobalArgs invGlobalArgs, Map<Object, AbstractDataSource> sourceMap, DynamicObject[] invSchemeArr, List<QFilter> dataSetFilters, List<QFilter> clickSearchFilter) {
        PluginProxy pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy(null);
        List dataSetBuilders = pluginProxy.callReplaceIfPresent(p -> p.getDataSetBuilder());
        DataSetBuilder dataSetBuilder = (DataSetBuilder)dataSetBuilders.get(dataSetBuilders.size() - 1);
        HashMap<Long, List<Long>> matMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject invScheme : invSchemeArr) {
            logger.info("\u6267\u884c\u65b9\u6848" + invScheme.toString());
            AbstractDataSource dataSource = sourceMap.get(invScheme.getPkValue());
            DataSet dataSet = ImmInvModelHelper.getSchemeDataSet((InvGlobalArgs)invGlobalArgs, (DynamicObject)invScheme, (AbstractDataSource)dataSource);
            if (null == dataSet || dataSet.isEmpty()) continue;
            List<Long> matIdList = this.getMatInspList(null, matMap);
            logger.info("\u8fc7\u6ee4\u7528\u7269\u6599id" + matIdList);
            DataSet filterDataSet = ImmInvModelHelper.filterMatInsp((DynamicObject)invScheme, (DataSet)dataSet, matIdList);
            if (null == filterDataSet || !filterDataSet.hasNext()) continue;
            CachedDataSet inspInfoDataSet = this.getInspInfoDataSet();
            SchemeParamArgs schemeParamArgs = new SchemeParamArgs(invScheme, inspInfoDataSet, dataSetFilters, clickSearchFilter);
            ImmInvModelHelper.buildRow((DynamicObject)invScheme, (IDataSource)dataSource, (DataSet)filterDataSet, (SchemeParamArgs)schemeParamArgs, (DataSetBuilder)dataSetBuilder, null);
        }
        DataSet orderByDataSet = dataSetBuilder.build().orderBy(new String[]{"invscheme", "nextinspdate"});
        CachedDataSet cachedDataSet = ImmInvModelHelper.cacheDataSet((DataSet)orderByDataSet, (String)PLANDETAIL_CACHEID, (IPageCache)this.getPageCache());
        logger.info("\u7f13\u5b58dataset\u6570\u636e\u5927\u5c0f" + cachedDataSet.getRowCount());
        DataSet resultDataSet = ImmInvModelHelper.completeInvInfo((CachedDataSet)cachedDataSet, (DynamicObject[])invSchemeArr, (Long)invGlobalArgs.getUserId());
        logger.info("\u8865\u5168\u9884\u7559\u6570\u91cf\u548c\u53ef\u7528\u6570\u91cf\u7ed3\u675f");
        this.createEntry(resultDataSet);
        logger.info("\u5237\u65b0\u68c0\u9a8c\u660e\u7ec6");
    }

    private void refresh() {
        FilterContainer container = (FilterContainer)this.getControl(FILTERCONTAINER);
        FilterContainerFilterValues cachedFilter = container.getCachedFilterValues();
        FilterKeyValueCollections fasetFilter = cachedFilter.getFastFilterValues();
        FilterKeyValueCollections otherFilter = cachedFilter.getOtherFilterValues();
        if ("customfilter".equalsIgnoreCase(otherFilter.getFilterKey())) {
            container.commonSearch(fasetFilter.createFilterValuesList(), otherFilter.createFilterValuesList(), this.getView().getEntityId());
        } else {
            container.schemeSearch(fasetFilter.createFilterValuesList(), otherFilter.createFilterValuesList(), this.getView().getEntityId());
        }
    }

    private void createEntry(DataSet dataSet) {
        PluginProxy pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy(null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.createEntry(dataSet, (AbstractFormPlugin)this);
            return null;
        });
    }

    private void draw() {
        List<DynamicObject> selectList = this.getSelectData();
        LinkedList targetIds = new LinkedList();
        Long curUserId = RequestContext.get().getCurrUserId();
        Long curOrgId = RequestContext.get().getOrgId();
        InvGlobalArgs invGlobalArgs = new InvGlobalArgs(curUserId, curOrgId, ((Object)((Object)this)).getClass().getName(), targetIds);
        Map<Object, List<DynamicObject>> schemeGroup = selectList.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject("invscheme").getPkValue()));
        Set<Object> invSchemeIdSet = schemeGroup.keySet();
        DynamicObject[] invSchemes = BusinessDataServiceHelper.load((Object[])invSchemeIdSet.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcbd_invimpschem"));
        Map<Object, DynamicObject> invSchemeMap = Arrays.stream(invSchemes).collect(Collectors.toMap(x -> x.getPkValue(), x -> x));
        String errInfo = "";
        try (TXHandle h1 = TX.requiresNew();){
            Set<Map.Entry<Object, List<DynamicObject>>> schemeEntrys = schemeGroup.entrySet();
            for (Map.Entry<Object, List<DynamicObject>> entry : schemeEntrys) {
                try {
                    Object invSchemeId = entry.getKey();
                    targetIds.addAll(this.buildExeDetail(invGlobalArgs, invSchemeMap.get(invSchemeId), entry.getValue()));
                }
                catch (Exception e) {
                    errInfo = e.getMessage();
                    InventoryInspHelper.setExeLog((DynamicObject)invSchemeMap.get(entry.getKey()), (String)"B", (String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            if (StringUtils.isNotEmpty((String)errInfo)) {
                h1.markRollback();
                targetIds.clear();
                logger.error("errInfo" + errInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])invSchemeMap.values().toArray(new DynamicObject[0]));
        if (StringUtils.isEmpty((String)errInfo)) {
            this.refresh();
            this.getPageCache().put("targetIds", JSON.toJSONString(targetIds));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(SHOW_INSPECT_APPLAN, (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210%s\u5f20\u5e93\u5b58\u8bf7\u68c0\u5355\u3002\u8bf7\u70b9\u51fb\u786e\u8ba4\uff0c\u67e5\u770b\u5e93\u5b58\u8bf7\u68c0\u5355\u5217\u8868\u3002", (String)"InventoryExePlanFormPlugin_1", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]), targetIds.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5e93\u5b58\u8bf7\u68c0\u5355\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u8be6\u7ec6\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"InventoryExePlanFormPlugin_7", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean validSelectData() {
        List<DynamicObject> selectList = this.getSelectData();
        if (selectList.isEmpty()) {
            return Boolean.FALSE;
        }
        Map<String, Boolean> validResMap = this.validSelectData(selectList);
        if (Boolean.TRUE.equals(validResMap.get(MUST_INPUT_ERR))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u3002", (String)"InventoryExePlanFormPlugin_3", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
        }
        if (Boolean.TRUE.equals(validResMap.get(REPEAT_ERR))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u884c\u5b58\u5728\u91cd\u590d\u7684\u5373\u65f6\u5e93\u5b58\u6216\u7269\u6599\u4e3b\u6570\u636e\u4fe1\u606f\u3002", (String)"InventoryExePlanFormPlugin_4", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
        }
        if (Boolean.TRUE.equals(validResMap.get(INCHECK_ERR))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u884c\u4e2d\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u68c0\u9a8c\u7684\u6570\u636e\u3002", (String)"InventoryExePlanFormPlugin_5", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
        return validResMap.isEmpty();
    }

    private List buildExeDetail(InvGlobalArgs invGlobalArgs, DynamicObject invScheme, List<DynamicObject> dataList) {
        logger.error("buildExeDetail");
        DynamicObject invModel = ImmInvModelHelper.initInvModel((InvGlobalArgs)invGlobalArgs, (DynamicObject)invScheme);
        DynamicObjectCollection exeDetails = invModel.getDynamicObjectCollection("exedetail");
        DynamicObjectType objectType = exeDetails.getDynamicObjectType();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject planRow = dataList.get(i);
            DynamicObject invModelRow = new DynamicObject(objectType);
            ImmInvModelHelper.setInvModelValue((DynamicObject)planRow, (DynamicObject)invModelRow, (int)(i + 1));
            exeDetails.add((Object)invModelRow);
        }
        OperationResult operationResult = ImmInvModelHelper.saveInvModel((DynamicObject)invModel, (DynamicObjectCollection)exeDetails);
        logger.error("\u4fdd\u5b58\u6267\u884c\u660e\u7ec6");
        List inspApplanIds = ImmInvModelHelper.autoPushInspApply((OperationResult)operationResult, (DynamicObject)invScheme);
        int applyCount = inspApplanIds.size();
        InventoryInspHelper.setExeLog((DynamicObject)invScheme, (String)"A", (String)"");
        ImmInvModelHelper.saveInspInfo((DynamicObject)invScheme, (DynamicObjectCollection)exeDetails, (int)applyCount);
        logger.error("\u8bb0\u5f55\u68c0\u9a8c\u660e\u7ec6");
        return inspApplanIds;
    }

    private List<QFilter> buildFilter(SearchClickEvent event) {
        FilterParameter filterParameter = event.getFilterParameter();
        List qFilters = filterParameter.getQFilters();
        List formatFilter = ImmInvModelHelper.formatFastFilter((List)event.getFastQFilters());
        qFilters.addAll(formatFilter);
        return qFilters;
    }

    private DynamicObject[] getInvSchemes(List<QFilter> filters, List<QFilter> dataSetFilters, String ... orderBy) {
        QFilter schemeFilter = BaseDataServiceHelper.getBaseDataFilter((String)"qcbd_invimpschem", (Long)RequestContext.get().getOrgId());
        schemeFilter.and("status", "=", (Object)"C");
        schemeFilter.and("enable", "=", (Object)"1");
        LinkedList filterRemove = new LinkedList();
        for (QFilter filter : filters) {
            Map propmap = ImmInvModelHelper.analysisProp((QFilter)filter);
            String property = (String)propmap.get("property");
            String attr = (String)propmap.get("attr");
            switch (property) {
                case "applyorg": {
                    ImmInvModelHelper.dealFilter((QFilter)schemeFilter, (QFilter)ImmInvModelHelper.buildFilter((String)"applyorg", (String)attr, (QFilter)filter), filterRemove, (QFilter)filter);
                    break;
                }
                case "inspecorg": {
                    ImmInvModelHelper.dealFilter((QFilter)schemeFilter, (QFilter)ImmInvModelHelper.buildFilter((String)"quaorg", (String)attr, (QFilter)filter), filterRemove, (QFilter)filter);
                    break;
                }
                case "exescheme": {
                    ImmInvModelHelper.dealFilter((QFilter)schemeFilter, (QFilter)ImmInvModelHelper.buildFilter((String)"", (String)attr, (QFilter)filter), filterRemove, (QFilter)filter);
                    break;
                }
                case "datasource": {
                    ImmInvModelHelper.dealFilter((QFilter)schemeFilter, (QFilter)ImmInvModelHelper.buildFilter((String)"datasource", (String)attr, (QFilter)filter), filterRemove, (QFilter)filter);
                    break;
                }
                case "lastinspdate": 
                case "nextinspdate": 
                case "incheck": {
                    this.getPageCache().put("incheck", String.valueOf(filter.getValue()));
                    ImmInvModelHelper.dealFilter(dataSetFilters, (QFilter)filter, filterRemove, (QFilter)filter);
                    break;
                }
            }
        }
        filters.removeAll(filterRemove);
        return InventoryInspHelper.getInvSchemes((QFilter)schemeFilter, (String[])orderBy);
    }

    private Map<Object, AbstractDataSource> getSourceMap(DynamicObject[] invSchemeArr, List<QFilter> filters) {
        HashMap<Object, AbstractDataSource> resourceMap = new HashMap<Object, AbstractDataSource>(16);
        for (DynamicObject invScheme : invSchemeArr) {
            String dataSourceStr = invScheme.getString("datasource");
            AbstractDataSource dataSource = ImmInvModelHelper.getDataSource((String)dataSourceStr);
            PluginProxy pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy((IDataSource)dataSource);
            pluginProxy.callAfter(p -> {
                p.buildFilter(filters, dataSource.getMetaFilter(), invScheme);
                return null;
            });
            resourceMap.put(invScheme.getPkValue(), dataSource);
        }
        return resourceMap;
    }

    private CachedDataSet getInspInfoDataSet() {
        String inspCacheId = this.getPageCache().get(INSPINFO_CACHEID);
        if (StringUtils.isNotEmpty((String)inspCacheId)) {
            return Algo.getCacheDataSet((String)inspCacheId);
        }
        DataSet inspInfoDataSet = ImmInvModelHelper.getInspInfos((String)((Object)((Object)this)).getClass().getName(), null);
        return ImmInvModelHelper.cacheDataSet((DataSet)inspInfoDataSet, (String)INSPINFO_CACHEID, (IPageCache)this.getPageCache());
    }

    private List<Long> getMatInspList(Long inspOrg, Map<Long, List<Long>> matMap) {
        return ImmInvModelHelper.getInvMat((String)((Object)((Object)this)).getClass().getName(), (Long)inspOrg, matMap);
    }

    private void clearCache() {
        this.getModel().deleteEntryData("plandetail");
        IPageCache pageCache = this.getPageCache();
        this.removeDatasetCache(PLANDETAIL_CACHEID);
        this.removeDatasetCache(INSPINFO_CACHEID);
        pageCache.remove("incheck");
    }

    private void removeDatasetCache(String plandetailCacheid) {
        IPageCache pageCache = this.getPageCache();
        String cacheId = pageCache.get(plandetailCacheid);
        if (StringUtils.isNotEmpty((String)cacheId)) {
            Algo.removeCacheDataSet((String)cacheId);
            pageCache.remove(plandetailCacheid);
        }
    }

    private void addSearchClickListener(FilterContainer container) {
        container.addSearchClickListener(searchClickEvent -> {
            this.clearCache();
            List<QFilter> clickSearchFilter = this.buildFilter(searchClickEvent);
            this.excuteQuery(clickSearchFilter);
        });
    }

    private void excuteQuery(List<QFilter> clickSearchFilter) {
        LinkedList<QFilter> dataSetFilter = new LinkedList<QFilter>();
        DynamicObject[] invSchemeArr = this.getInvSchemes(clickSearchFilter, dataSetFilter, new String[0]);
        if (0 == invSchemeArr.length) {
            return;
        }
        Map<Object, AbstractDataSource> sourceMap = this.getSourceMap(invSchemeArr, clickSearchFilter);
        this.getExePlanDetail(ImmInvModelHelper.getCurrGlobalParamArgs(), sourceMap, invSchemeArr, dataSetFilter, clickSearchFilter);
    }

    private void applyOrgChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        Object applyOrg = changeData.getNewValue();
        if (null == applyOrg) {
            model.setValue("inspecorg", null, rowIndex);
        } else {
            HashMap orgMap = new HashMap(16);
            Long applyOrgId = ((DynamicObject)applyOrg).getLong("id");
            List inspIdList = ImmInvModelHelper.getInspIdList(orgMap, (Long)applyOrgId);
            if (!inspIdList.isEmpty()) {
                model.setValue("inspecorg", inspIdList.get(0), rowIndex);
            } else {
                DynamicObject invScheme = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"invscheme", (int)rowIndex);
                DynamicObject quaOrg = invScheme.getDynamicObject("quaorg");
                if (null != quaOrg) {
                    model.setValue("inspecorg", (Object)quaOrg, rowIndex);
                } else {
                    model.setValue("inspecorg", null, rowIndex);
                }
            }
        }
    }

    private void inspectOrgBeforeF7(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject applyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"applyorg", (int)rowIndex);
        if (null == applyOrg) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"InventoryExePlanFormPlugin_0", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            HashMap orgMap = new HashMap(16);
            Long applyOrgId = applyOrg.getLong("id");
            List inspIdList = ImmInvModelHelper.getInspIdList(orgMap, (Long)applyOrgId);
            if (inspIdList.isEmpty()) {
                filterParameter.setFilter(new QFilter("fisqc", "=", (Object)"1"));
            } else {
                filterParameter.setFilter(new QFilter("id", "in", (Object)inspIdList));
            }
        }
    }

    private Map<String, Boolean> validSelectData(List<DynamicObject> selectList) {
        QFilter filter;
        Boolean incheck;
        HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(16);
        HashSet<Long> invIdSet = new HashSet<Long>();
        HashSet<Long> matIdSet = new HashSet<Long>();
        for (DynamicObject selectRow : selectList) {
            String dataSource;
            boolean mustInptErr;
            boolean bl = mustInptErr = selectRow.getBigDecimal("applyqty").compareTo(BigDecimal.ZERO) <= 0 || null == selectRow.get("applyorg") || null == selectRow.get("unit");
            if (mustInptErr) {
                validResult.put(MUST_INPUT_ERR, Boolean.TRUE);
            }
            if ("A".equals(dataSource = selectRow.getString("datasource"))) {
                Long invId = selectRow.getLong("inventoryid");
                if (invIdSet.contains(invId)) {
                    validResult.put(REPEAT_ERR, Boolean.TRUE);
                }
                invIdSet.add(invId);
                continue;
            }
            if (!"B".equals(dataSource)) continue;
            Long matId = selectRow.getDynamicObject("materialid").getLong("id");
            if (matIdSet.contains(matId)) {
                validResult.put(REPEAT_ERR, Boolean.TRUE);
            }
            matIdSet.add(matId);
        }
        if (!invIdSet.isEmpty() && (incheck = this.validIncheck(filter = new QFilter("inventoryid", "in", invIdSet).and("datasource", "=", (Object)"A"), validResult)).booleanValue()) {
            return validResult;
        }
        if (!matIdSet.isEmpty() && (incheck = this.validIncheck(filter = new QFilter("materialid", "in", matIdSet).and("datasource", "=", (Object)"B"), validResult)).booleanValue()) {
            return validResult;
        }
        return validResult;
    }

    private Boolean validIncheck(QFilter filter, Map<String, Boolean> validResult) {
        DataSet inspInfos = ImmInvModelHelper.getInspInfos((String)((Object)((Object)this)).getClass().getName(), (QFilter[])filter.toArray());
        while (inspInfos.hasNext()) {
            Row inspInfo = inspInfos.next();
            Boolean inCheck = inspInfo.getBoolean("incheck");
            if (!inCheck.booleanValue()) continue;
            validResult.put(INCHECK_ERR, Boolean.TRUE);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<DynamicObject> getSelectData() {
        EntryGrid grid = (EntryGrid)this.getControl("plandetail");
        int[] rows = grid.getSelectRows();
        int length = rows.length;
        if (0 == length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u5206\u5f55\u3002", (String)"InventoryExePlanFormPlugin_2", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection planDetails = this.getModel().getEntryEntity("plandetail");
        LinkedList<DynamicObject> selectList = new LinkedList<DynamicObject>();
        for (int rowIndex : rows) {
            selectList.add((DynamicObject)planDetails.get(rowIndex));
        }
        return selectList;
    }

    private void beforeDraw() {
        if (this.validSelectData().booleanValue()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(DRAW_CALLID, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u751f\u6210\u5355\u636e\u7c7b\u578b\uff1a\u5e93\u5b58\u8bf7\u68c0\u5355\uff0c\u70b9\u51fb\u786e\u8ba4\u7ee7\u7eed\u3002", (String)"InventoryExePlanFormPlugin_8", (String)"qmc-qcnp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private void unitBeforeF7(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel model = this.getModel();
        DynamicObject materialId = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"materialid", (int)rowIndex);
        DynamicObject baseunit = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"baseunit", (int)rowIndex);
        if (null == materialId || null == baseunit) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)-1));
        } else {
            QFilter qFilter = new QFilter("materialid", "=", materialId.getPkValue());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
            List unitIds = dynamicObjects.stream().map(o -> o.getLong("measureunitid")).collect(Collectors.toList());
            unitIds.add(baseunit.getLong("id"));
            qFilter = new QFilter("id", "in", unitIds);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void applyOrgBeforeF7(BeforeF7SelectEvent e) {
        long userId = UserServiceHelper.getCurrentUserId();
        String entityName = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean allOrgPer = OrgUnitUtil.getHasAllOrgPer((Long)userId, (String)appId, (String)entityName);
        ListShowParameter showPara = (ListShowParameter)e.getFormShowParameter();
        if (allOrgPer) {
            return;
        }
        List orgList = OrgUnitUtil.getHasPerOrg((Long)userId, (String)appId, (String)entityName);
        QFilter filter = new QFilter("id", "in", (Object)orgList);
        showPara.getListFilterParameter().setFilter(filter);
    }

    private void setExeschemeFilter(List<QFilter> qfilterLst) {
        QFilter qfilter = new QFilter("status", "=", (Object)"C");
        qfilter.and("enable", "=", (Object)"1");
        qfilterLst.add(qfilter);
    }
}

