/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcnp.business.helper.datasource.IDataSource;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractDataSource
extends IDataSource {
    private String sourceType;
    private List<QFilter> metaFilter;
    private Map<String, String> reflexMap;

    public abstract MainEntityType getDataSourceMeta();

    public String getSplitStr(String splitstr) {
        if (this.getReflexMap().containsKey(splitstr)) {
            return this.getReflexMap().get(splitstr);
        }
        return splitstr;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    protected void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<QFilter> getMetaFilter() {
        if (CollectionUtils.isEmpty(this.metaFilter)) {
            this.metaFilter = new LinkedList<QFilter>();
        }
        return this.metaFilter;
    }

    public Map<String, String> getReflexMap() {
        if (MapUtils.isEmpty(this.reflexMap)) {
            this.reflexMap = new HashMap<String, String>(16);
        }
        return this.reflexMap;
    }

    public void setReflexMap(Map<String, String> reflexMap) {
        this.reflexMap = reflexMap;
    }

    protected void setFieldValue(Object[] newRow, Object rowField, String dataFieldName) {
        int index = fieldList.indexOf(dataFieldName);
        if (index >= 0) {
            newRow[index] = rowField;
        }
    }

    @Override
    public DataSetBuilder getDataSetBuilder() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldList.toArray(new String[0]), (DataType[])typeList.toArray(new DataType[0]));
        return Algo.create((String)ImmInvModelHelper.class.getName()).createDataSetBuilder(rowMeta);
    }

    @Override
    public void createEntry(DataSet dataSet, AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        TableValueSetter valueSetter = this.getValueSetter();
        while (dataSet.hasNext()) {
            this.addValueSetterRow(valueSetter, dataSet.next());
        }
        model.beginInit();
        model.batchCreateNewEntryRow("plandetail", valueSetter);
        model.endInit();
        view.updateView("plandetail");
    }

    public void addValueSetterRow(TableValueSetter valueSetter, Row row) {
        int size = fieldList.size();
        Object[] valueArr = new Object[size];
        for (int i = 0; i < size; ++i) {
            valueArr[i] = row.get((String)fieldList.get(i));
        }
        valueSetter.addRow(valueArr);
    }

    public TableValueSetter getValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String field : fieldList) {
            vs.addField(field, new Object[0]);
        }
        return vs;
    }
}

