/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcnp.business.helper.datasource.AbstractDataSource;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;
import kd.qmc.qcnp.business.helper.datasource.args.DataRowParamArgs;

public class DataSourceInv
extends AbstractDataSource {
    @Override
    public void init() {
        this.setSourceType("A");
        Map<String, String> reflexMap = this.getReflexMap();
        reflexMap.put("org", "invorg");
        reflexMap.put("material", "materialid");
        reflexMap.put("lotnum", "lotnumber");
        reflexMap.put("quaorg", "inspecorg");
    }

    @Override
    public MainEntityType getDataSourceMeta() {
        return EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
    }

    @Override
    public void buildFilter(List<QFilter> filters, List<QFilter> metaFilter, DynamicObject invScheme) {
        for (QFilter filter : filters) {
            Map<String, String> propmap = ImmInvModelHelper.analysisProp(filter);
            String property = propmap.get("property");
            String attr = propmap.get("attr");
            switch (property) {
                case "materialid": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("material", attr, filter));
                    break;
                }
                case "warehouse": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("warehouse", attr, filter));
                    break;
                }
                case "location": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("location", attr, filter));
                    break;
                }
                case "lotnumber": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("lotnum", attr, filter));
                    break;
                }
                case "tracknumber": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("tracknumber", attr, filter));
                    break;
                }
                case "configuredcode": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("configuredcode", attr, filter));
                    break;
                }
                case "project": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("project", attr, filter));
                    break;
                }
                case "invorg": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("org", attr, filter));
                    break;
                }
            }
        }
    }

    @Override
    public String getSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s,", "id"));
        sb.append(String.format("%s,", "material"));
        sb.append(String.format("%s.number,", "material"));
        sb.append(String.format("%s,", "auxpty"));
        sb.append(String.format("%s,", "warehouse"));
        sb.append(String.format("%s,", "location"));
        sb.append(String.format("%s,", "invstatus"));
        sb.append(String.format("%s,", "invtype"));
        sb.append(String.format("%s,", "unit"));
        sb.append(String.format("%s,", "qty"));
        sb.append(String.format("%s,", "avbqty"));
        sb.append(String.format("%s,", "lotnum"));
        sb.append(String.format("%s,", "configuredcode"));
        sb.append(String.format("%s,", "tracknumber"));
        sb.append(String.format("%s,", "project"));
        sb.append(String.format("%s,", "producedate"));
        sb.append(String.format("%s,", "expirydate"));
        sb.append(String.format("%s,", "org"));
        sb.append(String.format("%s,", "baseunit"));
        sb.append(String.format("%s,", "baseqty"));
        sb.append(String.format("%s,", "avbbaseqty"));
        sb.append(String.format("%s,", "unit2nd"));
        sb.append(String.format("%s,", "qty2nd"));
        sb.append(String.format("%s,", "avbqty2nd"));
        sb.append(String.format("%s,", "ownertype"));
        sb.append(String.format("%s,", "owner"));
        sb.append(String.format("%s,", "keepertype"));
        sb.append(String.format("%s", "keeper"));
        return sb.toString();
    }

    @Override
    public void appendRow(DataRowParamArgs paramModel, DataSetBuilder dataSetBuilder, Map<String, Object> cacheMap) {
        Row row = paramModel.getRow();
        DynamicObject invScheme = paramModel.getGlobalParamArgs().getInvScheme();
        Object[] newRow = new Object[fieldList.size()];
        this.setFieldValue(newRow, invScheme.getPkValue(), "invscheme");
        this.setFieldValue(newRow, invScheme.getString("datasource"), "datasource");
        this.setFieldValue(newRow, row.get("id"), "inventoryid");
        this.setFieldValue(newRow, row.get("material"), "materialid");
        this.setFieldValue(newRow, row.get("auxpty"), "auxpty");
        this.setFieldValue(newRow, row.get("warehouse"), "warehouse");
        this.setFieldValue(newRow, row.get("location"), "location");
        this.setFieldValue(newRow, row.get("invstatus"), "invstatus");
        this.setFieldValue(newRow, row.get("invtype"), "invtype");
        this.setFieldValue(newRow, row.get("unit"), "unit");
        this.setFieldValue(newRow, row.get("qty"), "qty");
        this.setFieldValue(newRow, row.get("avbqty"), "avbqty");
        this.setFieldValue(newRow, row.get("qty"), "applyqty");
        this.setFieldValue(newRow, row.get("baseqty"), "baseapplyqty");
        this.setFieldValue(newRow, paramModel.getApplyOrg(), "applyorg");
        this.setFieldValue(newRow, paramModel.getInspOrg(), "inspecorg");
        this.setFieldValue(newRow, row.get("lotnum"), "lotnumber");
        this.setFieldValue(newRow, row.get("configuredcode"), "configuredcode");
        this.setFieldValue(newRow, row.get("tracknumber"), "tracknumber");
        this.setFieldValue(newRow, row.get("project"), "project");
        this.setFieldValue(newRow, row.get("producedate"), "producedate");
        this.setFieldValue(newRow, row.get("expirydate"), "expirydate");
        this.setFieldValue(newRow, row.get("org"), "invorg");
        this.setFieldValue(newRow, paramModel.getLastCheckDate(), "lastinspdate");
        Boolean inCheck = paramModel.getInCheck();
        this.setFieldValue(newRow, inCheck, "incheck");
        this.setFieldValue(newRow, inCheck != false ? "Y" : "", "incheck_show");
        this.setFieldValue(newRow, paramModel.getNextCheckDate(), "nextinspdate");
        this.setFieldValue(newRow, row.get("baseunit"), "baseunit");
        this.setFieldValue(newRow, row.get("baseqty"), "baseqty");
        this.setFieldValue(newRow, row.get("avbbaseqty"), "baseavbqty");
        this.setFieldValue(newRow, row.get("unit2nd"), "unit2nd");
        this.setFieldValue(newRow, row.get("qty2nd"), "qty2nd");
        this.setFieldValue(newRow, row.get("avbqty2nd"), "avb2ndqty");
        this.setFieldValue(newRow, row.get("ownertype"), "ownertype");
        this.setFieldValue(newRow, row.get("owner"), "owner");
        this.setFieldValue(newRow, row.get("keepertype"), "keepertype");
        this.setFieldValue(newRow, row.get("keeper"), "keeper");
        dataSetBuilder.append(newRow);
    }

    @Override
    public void appendEntry(DataRowParamArgs paramModel, DynamicObjectCollection entry, Map<String, Object> cacheMap) {
        Row row = paramModel.getRow();
        int seq = entry.size() + 1;
        DynamicObject invModelRow = entry.addNew();
        invModelRow.set("seq", (Object)seq);
        invModelRow.set("inventoryid", row.get("id"));
        invModelRow.set("materialid", row.get("material"));
        invModelRow.set("auxpty", row.get("auxpty"));
        invModelRow.set("warehouse", row.get("warehouse"));
        invModelRow.set("location", row.get("location"));
        invModelRow.set("invstatus", row.get("invstatus"));
        invModelRow.set("invtype", row.get("invtype"));
        invModelRow.set("unit", row.get("unit"));
        invModelRow.set("applyqty", row.get("qty"));
        invModelRow.set("baseapplyqty", row.get("baseqty"));
        invModelRow.set("qty", row.get("qty"));
        invModelRow.set("avbqty", row.get("avbqty"));
        invModelRow.set("lotnumber", row.get("lotnum"));
        invModelRow.set("configuredcode", row.get("configuredcode"));
        invModelRow.set("tracknumber", row.get("tracknumber"));
        invModelRow.set("project", row.get("project"));
        invModelRow.set("producedate", row.get("producedate"));
        invModelRow.set("expirydate", row.get("expirydate"));
        invModelRow.set("invorg", row.get("org"));
        invModelRow.set("applyorg", (Object)paramModel.getApplyOrg());
        invModelRow.set("inspecorg", (Object)paramModel.getInspOrg());
        invModelRow.set("invunit", row.get("unit"));
        invModelRow.set("baseunit", row.get("baseunit"));
        invModelRow.set("baseqty", row.get("baseqty"));
        invModelRow.set("baseavbqty", row.get("avbbaseqty"));
        invModelRow.set("unit2nd", row.get("unit2nd"));
        invModelRow.set("qty2nd", row.get("qty2nd"));
        invModelRow.set("avb2ndqty", row.get("avbqty2nd"));
        invModelRow.set("ownertype", row.get("ownertype"));
        invModelRow.set("owner", row.get("owner"));
        invModelRow.set("keepertype", row.get("keepertype"));
        invModelRow.set("keeper", row.get("keeper"));
        invModelRow.set("inspres", (Object)"suc");
    }
}

