/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcnp.business.helper.datasource.AbstractDataSource;
import kd.qmc.qcnp.business.helper.datasource.ImmInvModelHelper;
import kd.qmc.qcnp.business.helper.datasource.args.DataRowParamArgs;

public class DataSourceMaterial
extends AbstractDataSource {
    @Override
    public void init() {
        this.setSourceType("B");
        Map<String, String> reflexMap = this.getReflexMap();
        reflexMap.put("quaorg", "inspecorg");
        reflexMap.put("material", "materialid");
    }

    @Override
    public MainEntityType getDataSourceMeta() {
        return EntityMetadataCache.getDataEntityType((String)"bd_material");
    }

    @Override
    public void buildFilter(List<QFilter> filters, List<QFilter> metaFilter, DynamicObject invScheme) {
        QFilter defaultFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("baseunit", "!=", (Object)0);
        metaFilter.add(defaultFilter);
        for (QFilter filter : filters) {
            Map<String, String> propmap = ImmInvModelHelper.analysisProp(filter);
            String property = propmap.get("property");
            String attr = propmap.get("attr");
            switch (property) {
                case "materialid": {
                    metaFilter.add(ImmInvModelHelper.buildFilter("", attr, filter));
                    break;
                }
                case "warehouse": 
                case "location": 
                case "lotnumber": 
                case "tracknumber": 
                case "configuredcode": 
                case "project": 
                case "invorg": {
                    metaFilter.add(new QFilter("1", "=", (Object)"0"));
                    break;
                }
            }
        }
    }

    @Override
    public String getSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s,", "id"));
        sb.append(String.format("%s,", "number"));
        sb.append(String.format("%s,", "org"));
        sb.append(String.format("%s", "baseunit"));
        return sb.toString();
    }

    @Override
    public void appendRow(DataRowParamArgs paramModel, DataSetBuilder dataSetBuilder, Map<String, Object> cacheMap) {
        Row row = paramModel.getRow();
        DynamicObject invScheme = paramModel.getGlobalParamArgs().getInvScheme();
        Object[] newRow = new Object[fieldList.size()];
        this.setFieldValue(newRow, invScheme.getPkValue(), "invscheme");
        this.setFieldValue(newRow, invScheme.getString("datasource"), "datasource");
        this.setFieldValue(newRow, row.get("id"), "materialid");
        this.setFieldValue(newRow, row.get("baseunit"), "unit");
        this.setFieldValue(newRow, paramModel.getApplyOrg(), "applyorg");
        this.setFieldValue(newRow, paramModel.getInspOrg(), "inspecorg");
        this.setFieldValue(newRow, paramModel.getLastCheckDate(), "lastinspdate");
        Boolean inCheck = paramModel.getInCheck();
        this.setFieldValue(newRow, inCheck, "incheck");
        this.setFieldValue(newRow, inCheck != false ? "Y" : "", "incheck_show");
        this.setFieldValue(newRow, paramModel.getNextCheckDate(), "nextinspdate");
        this.setFieldValue(newRow, row.get("baseunit"), "baseunit");
        dataSetBuilder.append(newRow);
    }

    @Override
    public void appendEntry(DataRowParamArgs paramModel, DynamicObjectCollection entry, Map<String, Object> cacheMap) {
        Row row = paramModel.getRow();
        int seq = entry.size() + 1;
        DynamicObject invModelRow = entry.addNew();
        invModelRow.set("seq", (Object)seq);
        invModelRow.set("materialid", row.get("id"));
        invModelRow.set("unit", row.get("baseunit"));
        invModelRow.set("applyorg", (Object)paramModel.getApplyOrg());
        invModelRow.set("inspecorg", (Object)paramModel.getInspOrg());
        invModelRow.set("baseunit", row.get("baseunit"));
        invModelRow.set("inspres", (Object)"suc");
    }
}

