/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcnp.business.helper.datasource.args.DataRowParamArgs;
import kd.qmc.qcnp.business.helper.datasource.args.SchemeParamArgs;

public abstract class IDataSource {
    public static List<String> fieldList = new LinkedList<String>();
    public static List<DataType> typeList = new LinkedList<DataType>();

    public IDataSource() {
        this.executeInit();
    }

    private final void executeInit() {
        this.init();
    }

    public abstract void init();

    public abstract void buildFilter(List<QFilter> var1, List<QFilter> var2, DynamicObject var3);

    public abstract String getSelectFields();

    public abstract DataSetBuilder getDataSetBuilder();

    public abstract void createEntry(DataSet var1, AbstractFormPlugin var2);

    public void formatCachedDataSet(CachedDataSet cachedDataSet, Map<String, Object> cacheMap, SchemeParamArgs schemeParamArgs) {
        cacheMap.put("formatCachedDataSet", cachedDataSet.toDataSet(Algo.create((String)this.getClass().getName()), Boolean.TRUE.booleanValue()));
    }

    public void beforeAppendRow(DataRowParamArgs paramModel, Map<String, Object> cacheMap) {
    }

    public abstract void appendRow(DataRowParamArgs var1, DataSetBuilder var2, Map<String, Object> var3);

    public abstract void appendEntry(DataRowParamArgs var1, DynamicObjectCollection var2, Map<String, Object> var3);

    public static void addField(String fieldname, DataType dataType) {
        if (!fieldList.contains(fieldname)) {
            fieldList.add(fieldname);
            typeList.add(dataType);
        }
    }

    static {
        IDataSource.addField("invscheme", (DataType)DataType.LongType);
        IDataSource.addField("datasource", (DataType)DataType.StringType);
        IDataSource.addField("inventoryid", (DataType)DataType.LongType);
        IDataSource.addField("materialid", (DataType)DataType.LongType);
        IDataSource.addField("auxpty", (DataType)DataType.StringType);
        IDataSource.addField("warehouse", (DataType)DataType.LongType);
        IDataSource.addField("location", (DataType)DataType.LongType);
        IDataSource.addField("invstatus", (DataType)DataType.LongType);
        IDataSource.addField("invtype", (DataType)DataType.LongType);
        IDataSource.addField("unit", (DataType)DataType.LongType);
        IDataSource.addField("qty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("reservqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("avbqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("applyqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("baseapplyqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("maxapplyqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("applyorg", (DataType)DataType.LongType);
        IDataSource.addField("inspecorg", (DataType)DataType.LongType);
        IDataSource.addField("lotnumber", (DataType)DataType.StringType);
        IDataSource.addField("lotid", (DataType)DataType.LongType);
        IDataSource.addField("configuredcode", (DataType)DataType.LongType);
        IDataSource.addField("tracknumber", (DataType)DataType.LongType);
        IDataSource.addField("project", (DataType)DataType.LongType);
        IDataSource.addField("producedate", (DataType)DataType.DateType);
        IDataSource.addField("expirydate", (DataType)DataType.DateType);
        IDataSource.addField("invorg", (DataType)DataType.LongType);
        IDataSource.addField("lastinspdate", (DataType)DataType.DateType);
        IDataSource.addField("incheck", (DataType)DataType.BooleanType);
        IDataSource.addField("incheck_show", (DataType)DataType.StringType);
        IDataSource.addField("nextinspdate", (DataType)DataType.DateType);
        IDataSource.addField("baseunit", (DataType)DataType.LongType);
        IDataSource.addField("baseqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("basereservqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("baseavbqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("unit2nd", (DataType)DataType.LongType);
        IDataSource.addField("qty2nd", (DataType)DataType.BigDecimalType);
        IDataSource.addField("reserv2ndqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("avb2ndqty", (DataType)DataType.BigDecimalType);
        IDataSource.addField("ownertype", (DataType)DataType.StringType);
        IDataSource.addField("owner", (DataType)DataType.LongType);
        IDataSource.addField("keepertype", (DataType)DataType.StringType);
        IDataSource.addField("keeper", (DataType)DataType.LongType);
    }
}

