/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.commonmodel.billpush.BillPushHelper;
import kd.qmc.qcbd.business.commonmodel.billpush.BillPushResult;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcnp.business.helper.datasource.AbstractDataSource;
import kd.qmc.qcnp.business.helper.datasource.DataSourceInv;
import kd.qmc.qcnp.business.helper.datasource.DataSourceMaterial;
import kd.qmc.qcnp.business.helper.datasource.IDataSource;
import kd.qmc.qcnp.business.helper.datasource.args.DataRowParamArgs;
import kd.qmc.qcnp.business.helper.datasource.args.InvGlobalArgs;
import kd.qmc.qcnp.business.helper.datasource.args.SchemeParamArgs;

public class ImmInvModelHelper {
    private static final Log logger = LogFactory.getLog(ImmInvModelHelper.class);
    private static final Long TIMEOUT = 86400000L;
    private static final Long NO_GROUP = 1447104395471812609L;
    private static final String SYSTEM_TYPE = "qmc-qcnp-business";
    private static final String TRUE = "true";
    private static final String SUCCESS = "success";
    private static final String[] INSP_INFO_FIELDS = new String[]{"datasource", "inventoryid", "materialid", "incheck", "lastinspdate"};
    private static final String LIKE_FILTERSTR = "%%%s%%";
    public static Map<String, Map<String, String>> sourceMatchKey = new HashMap<String, Map<String, String>>(16);
    public static final String ROWKEY = "rowKey";
    public static final String FILTERKEY = "filterKey";

    private ImmInvModelHelper() {
    }

    public static InvGlobalArgs getCurrGlobalParamArgs() {
        LinkedList<Long> targetIds = new LinkedList<Long>();
        String algoKey = ImmInvModelHelper.class.getName();
        Long userId = RequestContext.get().getCurrUserId();
        Long orgId = RequestContext.get().getOrgId();
        return new InvGlobalArgs(userId, orgId, algoKey, targetIds);
    }

    public static List<Long> exeInvScheme(List<Long> schemeIds) throws KDException {
        InvGlobalArgs invGlobalArgs = ImmInvModelHelper.getCurrGlobalParamArgs();
        QFilter schememfilter = new QFilter("id", "in", schemeIds);
        DynamicObject[] invSchemes = InventoryInspHelper.getInvSchemes((QFilter)schememfilter, (String[])new String[0]);
        Map<Object, String> inspectNumMap = Arrays.stream(invSchemes).collect(Collectors.toMap(DataEntityBase::getPkValue, x -> x.getString("inspectnumstyle")));
        HashMap<Long, List<Long>> invMatMap = new HashMap<Long, List<Long>>(16);
        ImmInvModelHelper.getInvMat(invGlobalArgs.getAlgoKey(), null, invMatMap);
        logger.info("\u904d\u5386\u6267\u884c\u65b9\u6848");
        for (DynamicObject invScheme : invSchemes) {
            try (TXHandle h1 = TX.requiresNew();){
                try {
                    ImmInvModelHelper.exeSingleInvScheme(invGlobalArgs, inspectNumMap, invMatMap, invScheme);
                }
                catch (Exception e) {
                    InventoryInspHelper.setExeLog((DynamicObject)invScheme, (String)"B", (String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    h1.markRollback();
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])invSchemes);
        return invGlobalArgs.getTargetIds();
    }

    public static String buildRow(DynamicObject invScheme, IDataSource dataSource, DataSet dataSet, SchemeParamArgs schemeParamArgs, DataSetBuilder dataSetBuilder, DynamicObjectCollection exeDetails) {
        Long applyOrg;
        logger.info("----buildRow---");
        String sourceType = invScheme.getString("datasource");
        StringBuilder sb = new StringBuilder();
        DynamicObject applyOrgObj = invScheme.getDynamicObject("applyorg");
        Long l = applyOrg = null == applyOrgObj ? null : Long.valueOf(applyOrgObj.getLong("id"));
        if (null == applyOrg && "B".equals(sourceType)) {
            applyOrg = RequestContext.get().getOrgId();
        }
        PluginProxy<IDataSource> pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy(dataSource);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        CachedDataSet cachedDataSet = dataSet.cache(new CacheHint());
        pluginProxy.callReplaceIfPresent(p -> {
            p.formatCachedDataSet(cachedDataSet, cacheMap, schemeParamArgs);
            return null;
        });
        int count = 0;
        DataSet formatDataset = (DataSet)cacheMap.get("formatCachedDataSet");
        while (formatDataset.hasNext()) {
            List<Long> idList;
            Long inspOrg;
            Row row = formatDataset.next();
            logger.info(String.format("-----\u67e5\u8be2\u7ed3\u679c\u884c-----%s", ++count));
            DynamicObject inspOrgObj = invScheme.getDynamicObject("quaorg");
            Long l2 = inspOrg = null == inspOrgObj ? null : Long.valueOf(inspOrgObj.getLong("id"));
            if ("A".equals(sourceType)) {
                applyOrg = row.getLong("org");
                idList = ImmInvModelHelper.getInspIdList(schemeParamArgs.getInvInspectOrgMap(), applyOrg);
            } else {
                idList = ImmInvModelHelper.getInspIdList(schemeParamArgs.getInvInspectOrgMap(), applyOrg);
            }
            if (!idList.isEmpty()) {
                inspOrg = idList.get(0);
            }
            DataRowParamArgs paramModel = new DataRowParamArgs(row, schemeParamArgs, applyOrg, inspOrg, sb, cacheMap);
            pluginProxy.callReplaceIfPresent(p -> {
                p.beforeAppendRow(paramModel, cacheMap);
                return null;
            });
            ImmInvModelHelper.completeDataModel(paramModel);
            if (paramModel.getPassCheck().booleanValue() && null != dataSetBuilder) {
                logger.info("\u6821\u9a8c\u901a\u8fc7" + paramModel.getGlobalParamArgs().getInvScheme().getPkValue() + ":" + paramModel.getKeyId());
                pluginProxy.callReplaceIfPresent(p -> {
                    p.appendRow(paramModel, dataSetBuilder, cacheMap);
                    return null;
                });
                continue;
            }
            if (!paramModel.getPassCheck().booleanValue()) continue;
            logger.info("\u6821\u9a8c\u901a\u8fc7" + paramModel.getGlobalParamArgs().getInvScheme().getPkValue() + ":" + paramModel.getKeyId());
            pluginProxy.callAfter(p -> {
                p.appendEntry(paramModel, exeDetails, cacheMap);
                return null;
            });
        }
        cachedDataSet.close();
        return sb.toString();
    }

    public static void saveInspInfo(DynamicObject invScheme, DynamicObjectCollection exeDetails, int applyCount) {
        if (applyCount > 0) {
            String dataSourceStr = invScheme.getString("datasource");
            Map<String, String> matchKeyMap = sourceMatchKey.get(dataSourceStr);
            String filterKey = matchKeyMap.get(FILTERKEY);
            Set filterIdSet = exeDetails.stream().map(x -> x.get(filterKey)).collect(Collectors.toSet());
            DynamicObjectCollection idCollections = QueryServiceHelper.query((String)"qcnp_invinsp_info", (String)"id", (QFilter[])new QFilter(filterKey, "in", filterIdSet).toArray());
            Set idSet = idCollections.stream().map(x -> x.get("id")).collect(Collectors.toSet());
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"qcnp_invinsp_info");
            DynamicObject[] invInspArr = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)mainEntityType);
            Set updatedIdSet = Arrays.stream(invInspArr).map(x -> x.get(filterKey)).collect(Collectors.toSet());
            filterIdSet.removeAll(updatedIdSet);
            int orginCount = invInspArr.length;
            int newCount = filterIdSet.size();
            DynamicObject[] saveArr = new DynamicObject[orginCount + newCount];
            Date lastInspDate = KDDateUtils.now();
            for (int i = 0; i < orginCount; ++i) {
                saveArr[i] = invInspArr[i];
                saveArr[i].set("lastinspdate", (Object)lastInspDate);
                saveArr[i].set("incheck", (Object)Boolean.TRUE);
            }
            for (Object id : filterIdSet) {
                int index = orginCount++;
                saveArr[index] = new DynamicObject((DynamicObjectType)mainEntityType);
                saveArr[index].set("datasource", (Object)dataSourceStr);
                if ("A".equals(dataSourceStr)) {
                    saveArr[index].set("inventoryid", id);
                } else if ("B".equals(dataSourceStr)) {
                    saveArr[index].set("materialid", id);
                }
                saveArr[index].set("lastinspdate", (Object)lastInspDate);
                saveArr[index].set("incheck", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.save((DynamicObject[])saveArr);
        }
    }

    public static DataSet getSchemeDataSet(InvGlobalArgs invGlobalArgs, DynamicObject invScheme, AbstractDataSource dataSource) {
        List<QFilter> metaFilter = dataSource.getMetaFilter();
        MainEntityType mainEntity = dataSource.getDataSourceMeta();
        if (null == mainEntity) {
            return null;
        }
        boolean neverMatch = metaFilter.stream().anyMatch(x -> "1".equals(x.getProperty()) && "=".equals(x.getCP()) && "0".equals(x.getValue()));
        if (neverMatch) {
            return null;
        }
        PluginProxy<IDataSource> pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy(dataSource);
        List fieldLists = pluginProxy.callAfter(p -> p.getSelectFields());
        fieldLists.removeIf(x -> StringUtils.isEmpty((CharSequence)x));
        String selectFields = String.join((CharSequence)",", fieldLists);
        String dataSoueceStr = invScheme.getString("datasource");
        if ("B".equals(dataSoueceStr)) {
            DynamicObjectCollection materGrpSel;
            DynamicObjectCollection materialSel = invScheme.getDynamicObjectCollection("materialsel");
            if (!materialSel.isEmpty()) {
                metaFilter.add(new QFilter("id", "in", materialSel.stream().map(x -> x.get(2)).collect(Collectors.toSet())));
            }
            if (!(materGrpSel = invScheme.getDynamicObjectCollection("matergrpsel")).isEmpty()) {
                Set<Object> materGrpIdSet = materGrpSel.stream().map(x -> x.get(2)).collect(Collectors.toSet());
                if (materGrpIdSet.remove(NO_GROUP)) {
                    materGrpIdSet.add(0);
                    Set<Object> materialIdSet = ImmInvModelHelper.getGroupMaterial(materGrpIdSet);
                    metaFilter.add(new QFilter("id", "in", materialIdSet));
                } else {
                    metaFilter.add(new QFilter("id", "in", ImmInvModelHelper.getGroupMaterial(materGrpIdSet)));
                }
            }
        } else if ("A".equals(dataSoueceStr)) {
            String filterStrTag = invScheme.getString("filterstring_tag");
            if (StringUtils.isNotEmpty((CharSequence)filterStrTag)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStrTag, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(mainEntity, filterCondition);
                filterBuilder.buildFilter(false);
                QFilter qFilter = filterBuilder.getQFilter();
                metaFilter.add(qFilter);
            }
            if (!invGlobalArgs.isAdmin().booleanValue()) {
                List<Long> viewOrgs = ImmInvModelHelper.getPermissionOrgs(invGlobalArgs.getUserId());
                metaFilter.add(new QFilter("org", "in", viewOrgs));
            }
        }
        logger.info("\u67e5\u8be2\u6570\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a" + metaFilter);
        return QueryServiceHelper.queryDataSet((String)invGlobalArgs.getAlgoKey(), (String)mainEntity.getName(), (String)selectFields, (QFilter[])metaFilter.toArray(new QFilter[0]), (String)"id");
    }

    public static AbstractDataSource getDataSource(String source) {
        AbstractDataSource dataSource = "A".equals(source) ? new DataSourceInv() : new DataSourceMaterial();
        return dataSource;
    }

    public static List<Long> getInvMat(String algoKey, Long inspOrg, Map<Long, List<Long>> masteridCacheMap) {
        if (masteridCacheMap.containsKey(inspOrg)) {
            return masteridCacheMap.get(inspOrg);
        }
        LinkedList<Long> masteridList = new LinkedList<Long>();
        masteridCacheMap.put(inspOrg, masteridList);
        QFilter invMatFilter = new QFilter("status", "=", (Object)"C");
        invMatFilter.and("enable", "=", (Object)"1");
        invMatFilter.and("stockflg", "=", (Object)"1");
        if (null != inspOrg) {
            invMatFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)inspOrg));
        }
        DataSet invMatDataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_inspect_cfg", (String)"masterid", (QFilter[])invMatFilter.toArray(), null);
        while (invMatDataset.hasNext()) {
            masteridList.add(invMatDataset.next().getLong("masterid"));
        }
        return masteridCacheMap.get(inspOrg);
    }

    public static DataSet filterMatInsp(DynamicObject invScheme, DataSet dataSet, List<Long> masteridList) {
        if (null == masteridList || masteridList.isEmpty()) {
            return null;
        }
        String dataSourceStr = invScheme.getString("datasource");
        if ("A".equals(dataSourceStr)) {
            return dataSet.filter(new QFilter("material", "in", masteridList).toString());
        }
        return dataSet.filter(new QFilter("id", "in", masteridList).toString());
    }

    public static DataSet getInspInfos(String algoKey, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"qcnp_invinsp_info", (String)StringUtils.join((Object[])INSP_INFO_FIELDS, (String)","), (QFilter[])filters, null);
    }

    public static CachedDataSet cacheDataSet(DataSet inspInfoDataSet, String inspinfoCacheid, IPageCache pageCache) {
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout(TIMEOUT.longValue());
        CachedDataSet cachedDataSet = inspInfoDataSet.cache(cacheHint);
        if (StringUtils.isNotEmpty((CharSequence)inspinfoCacheid) && null != pageCache) {
            pageCache.put(inspinfoCacheid, cachedDataSet.getCacheId());
        }
        return cachedDataSet;
    }

    public static List<QFilter> formatFastFilter(List<QFilter> fastQFilters) {
        LinkedList<QFilter> formatFilter = new LinkedList<QFilter>();
        for (QFilter filter : fastQFilters) {
            String[] filterValues = String.valueOf(filter.getValue()).split("#");
            if (2 != filterValues.length) continue;
            String filterKey = filterValues[0];
            if (-1 == filterKey.indexOf(",")) {
                formatFilter.add(new QFilter(filterKey, "like", (Object)String.format(LIKE_FILTERSTR, filterValues[1])));
                continue;
            }
            String[] filterKeyArr = filterKey.split(",");
            formatFilter.add(new QFilter(filterKeyArr[0], "like", (Object)String.format(LIKE_FILTERSTR, filterValues[1])).or(filterKeyArr[1], "like", (Object)String.format(LIKE_FILTERSTR, filterValues[1])));
        }
        return formatFilter;
    }

    public static Map<String, String> analysisProp(QFilter filter) {
        HashMap<String, String> propMap = new HashMap<String, String>(16);
        String propertyFullName = filter.getProperty();
        int indexPoint = propertyFullName.indexOf(".");
        if (-1 == indexPoint) {
            propMap.put("property", propertyFullName);
            propMap.put("attr", "");
        } else {
            propMap.put("property", propertyFullName.substring(0, indexPoint));
            propMap.put("attr", propertyFullName.substring(indexPoint + 1));
        }
        return propMap;
    }

    public static void dealFilter(QFilter filter, QFilter filterNew, List<QFilter> filterRemove, QFilter filterOld) {
        filter.and(filterNew);
        filterRemove.add(filterOld);
    }

    public static void dealFilter(List<QFilter> filterList, QFilter filterNew, List<QFilter> filterRemove, QFilter filterOld) {
        filterList.add(filterNew);
        filterRemove.add(filterOld);
    }

    public static QFilter buildFilter(String property, String attr, QFilter filter) {
        String qcpKey = "";
        qcpKey = StringUtils.isEmpty((CharSequence)property) || StringUtils.isEmpty((CharSequence)attr) ? property.concat(attr) : property.concat(".").concat(attr);
        QFilter qFilter = new QFilter(qcpKey, filter.getCP(), filter.getValue());
        List nests = filter.getNests(true);
        if (nests.isEmpty()) {
            return qFilter;
        }
        String qcpNestKey = qcpKey.replace("number", "name");
        return qFilter.or(qcpNestKey, qFilter.getCP(), qFilter.getValue());
    }

    public static void completeDataModel(DataRowParamArgs paramModel) {
        CachedDataSet inspInfoSet = paramModel.getGlobalParamArgs().getInspInfoDataSet();
        LinkedList<Row> inspInfos = new LinkedList<Row>();
        int rowCount = inspInfoSet.getRowCount();
        if (rowCount > 0) {
            inspInfos.addAll(inspInfoSet.getList(0, rowCount));
        }
        if (!ImmInvModelHelper.inCheckJudge(inspInfos, paramModel).booleanValue()) {
            return;
        }
        if (!ImmInvModelHelper.lastCheckDateJudge(inspInfos, paramModel).booleanValue()) {
            return;
        }
        if (!ImmInvModelHelper.nextCheckDateJudge(paramModel).booleanValue()) {
            return;
        }
        paramModel.setPassCheck(Boolean.TRUE);
    }

    public static void setInvModelValue(DynamicObject planRow, DynamicObject invModelRow, int seq) {
        invModelRow.set("seq", (Object)seq);
        invModelRow.set("inventoryid", planRow.get("inventoryid"));
        invModelRow.set("materialid", ImmInvModelHelper.getDynamicObjectId(planRow, "materialid"));
        invModelRow.set("auxpty", planRow.get("auxpty"));
        invModelRow.set("warehouse", ImmInvModelHelper.getDynamicObjectId(planRow, "warehouse"));
        invModelRow.set("location", ImmInvModelHelper.getDynamicObjectId(planRow, "location"));
        invModelRow.set("invstatus", ImmInvModelHelper.getDynamicObjectId(planRow, "invstatus"));
        invModelRow.set("invtype", ImmInvModelHelper.getDynamicObjectId(planRow, "invtype"));
        invModelRow.set("unit", ImmInvModelHelper.getDynamicObjectId(planRow, "unit"));
        invModelRow.set("applyqty", planRow.get("applyqty"));
        invModelRow.set("baseapplyqty", planRow.get("baseapplyqty"));
        invModelRow.set("qty", planRow.get("qty"));
        invModelRow.set("reservqty", planRow.get("reservqty"));
        invModelRow.set("avbqty", planRow.get("avbqty"));
        invModelRow.set("lotnumber", planRow.get("lotnumber"));
        invModelRow.set("configuredcode", ImmInvModelHelper.getDynamicObjectId(planRow, "configuredcode"));
        invModelRow.set("tracknumber", ImmInvModelHelper.getDynamicObjectId(planRow, "tracknumber"));
        invModelRow.set("project", ImmInvModelHelper.getDynamicObjectId(planRow, "project"));
        invModelRow.set("producedate", planRow.get("producedate"));
        invModelRow.set("expirydate", planRow.get("expirydate"));
        invModelRow.set("invorg", ImmInvModelHelper.getDynamicObjectId(planRow, "invorg"));
        invModelRow.set("applyorg", ImmInvModelHelper.getDynamicObjectId(planRow, "applyorg"));
        invModelRow.set("inspecorg", ImmInvModelHelper.getDynamicObjectId(planRow, "inspecorg"));
        invModelRow.set("invunit", ImmInvModelHelper.getDynamicObjectId(planRow, "unit"));
        invModelRow.set("baseunit", ImmInvModelHelper.getDynamicObjectId(planRow, "baseunit"));
        invModelRow.set("baseqty", planRow.get("baseqty"));
        invModelRow.set("basereservqty", planRow.get("basereservqty"));
        invModelRow.set("baseavbqty", planRow.get("baseavbqty"));
        invModelRow.set("unit2nd", planRow.get("unit2nd"));
        invModelRow.set("qty2nd", planRow.get("qty2nd"));
        invModelRow.set("reserv2ndqty", planRow.get("reserv2ndqty"));
        invModelRow.set("avb2ndqty", planRow.get("avb2ndqty"));
        invModelRow.set("ownertype", planRow.get("ownertype"));
        invModelRow.set("owner", planRow.get("owner"));
        invModelRow.set("keepertype", planRow.get("keepertype"));
        invModelRow.set("keeper", planRow.get("keeper"));
        invModelRow.set("inspres", (Object)"suc");
    }

    public static Object getDynamicObjectId(DynamicObject planRow, String fieldName) {
        DynamicObject fieldObj = planRow.getDynamicObject(fieldName);
        if (null == fieldObj) {
            return null;
        }
        return fieldObj.getPkValue();
    }

    public static DynamicObject initInvModel(InvGlobalArgs invGlobalArgs, DynamicObject invScheme) {
        Date now = KDDateUtils.now();
        DynamicObject invModel = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcnp_imminv_model"));
        invModel.set("billtype", (Object)1428081149527213056L);
        invModel.set("biztype", (Object)1176040910430171136L);
        invModel.set("exedate", (Object)now);
        invModel.set("org", (Object)invGlobalArgs.getOrgId());
        invModel.set("creator", (Object)invGlobalArgs.getUserId());
        invModel.set("auditor", (Object)invGlobalArgs.getUserId());
        invModel.set("auditdate", (Object)now);
        invModel.set("billstatus", (Object)"C");
        invModel.set("invimpscheme", invScheme.getPkValue());
        return invModel;
    }

    public static OperationResult saveInvModel(DynamicObject invModel, DynamicObjectCollection exeDetails) {
        if (!exeDetails.isEmpty()) {
            logger.info("\u6267\u884c\u660e\u7ec6\u6761\u6570" + exeDetails.size());
            logger.info("\u6267\u884c\u660e\u7ec6\u8868\u5934\u4fe1\u606f" + invModel);
            for (DynamicObject dynamicObject : exeDetails) {
                logger.info("\u6267\u884c\u660e\u7ec6\u4fe1\u606f" + dynamicObject);
            }
            if (null == invModel.get("org") || 0L == invModel.getLong("org")) {
                Object applyOrg = ((DynamicObject)exeDetails.get(0)).get("applyorg");
                invModel.set("org", applyOrg);
            }
            return SaveServiceHelper.saveOperate((String)"qcnp_imminv_model", (DynamicObject[])new DynamicObject[]{invModel}, (OperateOption)OperateOption.create());
        }
        return null;
    }

    public static List autoPushInspApply(OperationResult operationResult, DynamicObject invScheme) {
        if (null != operationResult && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            Long sourceId = (Long)successPkIds.get(0);
            HashMap<String, String> customParams = new HashMap<String, String>(16);
            customParams.put("invSchemeId", String.valueOf(invScheme.getPkValue()));
            BillPushResult billPushResult = BillPushHelper.autoPush((String)"qcnp_imminv_model", (String)"qcnp_invinspectplan", (Long)sourceId, null, customParams);
            String errMsg = billPushResult.getErrMsg();
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                throw new KDBizException(errMsg);
            }
            List targetBillObjs = billPushResult.getTargetBillObjs();
            HashSet<Object> schemeId = new HashSet<Object>();
            schemeId.add(invScheme.getPkValue());
            HashMap<Long, Map> permissionRes = new HashMap<Long, Map>(16);
            for (DynamicObject targetObj : targetBillObjs) {
                Long orgId = DynamicObjDataUtil.getDynamicObjectLongData((DynamicObject)targetObj.getDynamicObject("org"), (String)"id");
                if (permissionRes.containsKey(orgId)) continue;
                Map permissionCheck = InventoryInspHelper.permissionCheck(schemeId, (Long)orgId);
                if (!permissionCheck.isEmpty()) {
                    throw new KDBizException(permissionCheck.get("errInvSb").toString());
                }
                permissionRes.put(orgId, permissionCheck);
            }
            return targetBillObjs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        return new LinkedList();
    }

    public static List<Long> getInspIdList(Map<Long, List<Long>> orgMap, Long applyOrg) {
        List idList;
        if (orgMap.containsKey(applyOrg)) {
            idList = orgMap.get(applyOrg);
        } else {
            idList = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)applyOrg, (boolean)true);
            orgMap.put(applyOrg, idList);
        }
        return idList;
    }

    public static JSONObject getInvInfos(Set<Long> materiIds, Long userId) {
        logger.info("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u6c42\u7269\u6599id\uff1a" + materiIds);
        logger.info("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u6c42userId\uff1a" + userId);
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(16);
        params.put("material", materiIds);
        params.put("org", ImmInvModelHelper.getPermissionOrgs(userId));
        logger.info("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f\uff1a" + params);
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"getInventoryAvbQty", (Object[])new Object[]{"im_inv_realbalance", params});
        logger.info("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c:" + resultStr);
        return (JSONObject)JSON.parse((String)resultStr);
    }

    public static DataSet completeInvInfo(CachedDataSet cachedDataSet, DynamicObject[] invSchemeArr, Long userId) {
        PluginProxy<IDataSource> pluginProxy = ImmInvModelHelper.getDataSourcePluginProxy(null);
        pluginProxy.callAfter(p -> {
            p.init();
            return null;
        });
        List dataSetBuilderList = pluginProxy.callReplaceIfPresent(p -> p.getDataSetBuilder());
        DataSetBuilder dataSetBuilder = (DataSetBuilder)dataSetBuilderList.get(dataSetBuilderList.size() - 1);
        List rowList = cachedDataSet.getList(0, cachedDataSet.getRowCount());
        int rowListSize = rowList.size();
        logger.info("----\u8865\u5168\u5373\u65f6\u5e93\u5b58\u4fe1\u606f rowList.size-----" + rowListSize);
        Set<Long> materialIds = rowList.stream().filter(x -> "A".equals(x.getString("datasource"))).map(x -> x.getLong("materialid")).collect(Collectors.toSet());
        if (materialIds.isEmpty()) {
            return cachedDataSet.toDataSet(Algo.create((String)ImmInvModelHelper.class.getName()), Boolean.TRUE.booleanValue());
        }
        JSONObject searchResult = ImmInvModelHelper.getInvInfos(materialIds, userId);
        if (!TRUE.equalsIgnoreCase(searchResult.getString(SUCCESS))) {
            return cachedDataSet.toDataSet(Algo.create((String)ImmInvModelHelper.class.getName()), Boolean.TRUE.booleanValue());
        }
        JSONArray cols = searchResult.getJSONArray("col");
        Field[] fields = cachedDataSet.getRowMeta().getFields();
        Map<Object, String> inspectNumMap = Arrays.stream(invSchemeArr).collect(Collectors.toMap(DataEntityBase::getPkValue, x -> x.getString("inspectnumstyle")));
        for (int i = 0; i < rowListSize; ++i) {
            logger.info("----\u8865\u5168\u5373\u65f6\u5e93\u5b58\u4fe1\u606f i-----" + i);
            Row row = (Row)rowList.get(i);
            String dataSourceStr = row.getString("datasource");
            if ("B".equals(dataSourceStr)) {
                dataSetBuilder.append(row);
                continue;
            }
            if (!"A".equals(dataSourceStr)) continue;
            String applyQtyFrom = inspectNumMap.get(row.getLong("invscheme"));
            logger.info("----\u8865\u5168\u5373\u65f6\u5e93\u5b58\u4fe1\u606f\u5373\u65f6\u5e93\u5b58id-----" + row.getLong("inventoryid"));
            HashMap<String, Object> replaceValues = new HashMap<String, Object>(16);
            Optional<Object> first = cols.stream().filter(x -> row.getLong("inventoryid").equals(((JSONObject)x).getLong("id"))).findFirst();
            if (!first.isPresent()) continue;
            logger.info("----\u8865\u5168\u5373\u65f6\u5e93\u5b58\u4fe1\u606f\u5373\u65f6\u5e93\u5b58id\u5339\u914d-----" + row.getLong("inventoryid"));
            JSONObject invObj = (JSONObject)first.get();
            replaceValues.put("reservqty", invObj.getBigDecimal("lockqty"));
            replaceValues.put("basereservqty", invObj.getBigDecimal("lockbaseqty"));
            replaceValues.put("reserv2ndqty", invObj.getBigDecimal("lockqty2nd"));
            replaceValues.put("avbqty", invObj.getBigDecimal("qty").subtract(invObj.getBigDecimal("lockqty")));
            replaceValues.put("baseavbqty", invObj.getBigDecimal("baseqty").subtract(invObj.getBigDecimal("lockbaseqty")));
            replaceValues.put("avb2ndqty", invObj.getBigDecimal("qty2nd").subtract(invObj.getBigDecimal("lockqty2nd")));
            if ("B".equals(applyQtyFrom)) {
                replaceValues.put("applyqty", replaceValues.get("avbqty"));
                replaceValues.put("baseapplyqty", replaceValues.get("baseavbqty"));
                replaceValues.put("maxapplyqty", replaceValues.get("avbqty"));
            } else {
                replaceValues.put("applyqty", invObj.getBigDecimal("qty"));
                replaceValues.put("baseapplyqty", invObj.getBigDecimal("baseqty"));
                replaceValues.put("maxapplyqty", invObj.getBigDecimal("qty"));
            }
            BigDecimal applyQty = (BigDecimal)replaceValues.get("applyqty");
            logger.info("----\u8865\u5168\u5373\u65f6\u5e93\u5b58\u4fe1\u606fapplyQty-----" + applyQty);
            if (applyQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            Object[] newRow = ImmInvModelHelper.replaceRowValue(fields, row, replaceValues);
            dataSetBuilder.append(newRow);
        }
        cachedDataSet.close();
        return dataSetBuilder.build();
    }

    public static void completeInvInfo(DynamicObject invModel, Map<Object, String> inspectNumMap, Long userId) {
        DynamicObjectCollection entrys = invModel.getDynamicObjectCollection("exedetail");
        Set<Long> materialIds = entrys.stream().map(x -> x.getLong("materialid")).collect(Collectors.toSet());
        JSONObject searchResult = ImmInvModelHelper.getInvInfos(materialIds, userId);
        if (!TRUE.equalsIgnoreCase(searchResult.getString(SUCCESS))) {
            return;
        }
        JSONArray cols = searchResult.getJSONArray("col");
        String applyQtyFrom = inspectNumMap.get(invModel.getLong("invimpscheme"));
        for (DynamicObject row : entrys) {
            Optional<Object> first = cols.stream().filter(x -> row.getLong("inventoryid") == ((JSONObject)x).getLong("id").longValue()).findFirst();
            if (!first.isPresent()) continue;
            JSONObject invObj = (JSONObject)first.get();
            row.set("reservqty", (Object)invObj.getBigDecimal("lockqty"));
            row.set("basereservqty", (Object)invObj.getBigDecimal("lockbaseqty"));
            row.set("reserv2ndqty", (Object)invObj.getBigDecimal("lockqty2nd"));
            row.set("avbqty", (Object)invObj.getBigDecimal("qty").subtract(invObj.getBigDecimal("lockqty")));
            row.set("baseavbqty", (Object)invObj.getBigDecimal("baseqty").subtract(invObj.getBigDecimal("lockbaseqty")));
            row.set("avb2ndqty", (Object)invObj.getBigDecimal("qty2nd").subtract(invObj.getBigDecimal("lockqty2nd")));
            if ("B".equals(applyQtyFrom)) {
                row.set("applyqty", row.get("avbqty"));
                row.set("baseapplyqty", row.get("baseavbqty"));
                continue;
            }
            row.set("applyqty", (Object)invObj.getBigDecimal("qty"));
            row.set("baseapplyqty", (Object)invObj.getBigDecimal("baseqty"));
        }
        entrys.removeIf(x -> x.getBigDecimal("applyqty").compareTo(BigDecimal.ZERO) <= 0);
    }

    public static Object[] replaceRowValue(Field[] fields, Row row, Map<String, Object> replaceValues) {
        int length = fields.length;
        Object[] newRow = new Object[length];
        for (int i = 0; i < length; ++i) {
            String field = fields[i].getName();
            newRow[i] = replaceValues.containsKey(field) ? replaceValues.get(field) : row.get(field);
        }
        return newRow;
    }

    public static PluginProxy<IDataSource> getDataSourcePluginProxy(IDataSource dataSource) {
        if (null == dataSource) {
            return PluginProxy.create((Object)ImmInvModelHelper.getDataSource("B"), IDataSource.class, (String)"QMC_QCNP_INVENTORY_DATASOURCE_INV_EXT", null);
        }
        if (dataSource instanceof DataSourceInv) {
            return PluginProxy.create((Object)dataSource, IDataSource.class, (String)"QMC_QCNP_INVENTORY_DATASOURCE_INV_EXT", null);
        }
        return PluginProxy.create((Object)dataSource, IDataSource.class, (String)"QMC_QCNP_INVENTORY_DATASOURCE_MAT_EXT", null);
    }

    private static void exeSingleInvScheme(InvGlobalArgs invGlobalArgs, Map<Object, String> inspectNumMap, Map<Long, List<Long>> invMatMap, DynamicObject invScheme) {
        DynamicObject invModel = ImmInvModelHelper.initInvModel(invGlobalArgs, invScheme);
        DynamicObjectCollection exeDetails = invModel.getDynamicObjectCollection("exedetail");
        String dataSouceStr = invScheme.getString("datasource");
        AbstractDataSource dataSource = ImmInvModelHelper.getDataSource(dataSouceStr);
        DataSet dataSet = ImmInvModelHelper.getSchemeDataSet(invGlobalArgs, invScheme, dataSource);
        logger.info("\u83b7\u53d6\u6267\u884c\u660e\u7ec6");
        DataSet filterDataSet = ImmInvModelHelper.filterMatInsp(invScheme, dataSet, invMatMap.get(null));
        if (null == filterDataSet || !filterDataSet.hasNext()) {
            InventoryInspHelper.setExeLog((DynamicObject)invScheme, (String)"B", (String)ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u9700\u8981\u68c0\u9a8c\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6267\u884c\u65b9\u6848\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImmInvModelHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DataSet inCheckInsp = ImmInvModelHelper.getInspInfos(invGlobalArgs.getAlgoKey(), null);
        CachedDataSet inCheckInspCacheset = ImmInvModelHelper.cacheDataSet(inCheckInsp, null, null);
        logger.info("\u83b7\u53d6\u5e93\u5b58\u68c0\u9a8c\u4fe1\u606f");
        LinkedList<QFilter> filters = new LinkedList<QFilter>();
        filters.add(new QFilter("incheck", "=", (Object)"0"));
        Date today = KDDateUtils.today();
        QFilter nextCheckFilter = new QFilter("nextinspdate", ">=", (Object)KDDateUtils.addYears((Date)today, (int)-2000));
        nextCheckFilter.addFirstNest(new QFilter("nextinspdate", "<", (Object)KDDateUtils.addDays((Date)today, (int)1)), "and");
        filters.add(nextCheckFilter);
        SchemeParamArgs schemeParamArgs = new SchemeParamArgs(invScheme, inCheckInspCacheset, filters, null);
        String incheckInfo = ImmInvModelHelper.buildRow(invScheme, dataSource, filterDataSet, schemeParamArgs, null, exeDetails);
        if ("A".equals(dataSouceStr)) {
            ImmInvModelHelper.completeInvInfo(invModel, inspectNumMap, invGlobalArgs.getUserId());
        }
        OperationResult operationResult = ImmInvModelHelper.saveInvModel(invModel, exeDetails);
        logger.info("\u4fdd\u5b58\u6267\u884c\u660e\u7ec6");
        inCheckInspCacheset.close();
        List inspApplanIds = ImmInvModelHelper.autoPushInspApply(operationResult, invScheme);
        int applyCount = inspApplanIds.size();
        logger.info("\u4e0b\u63a8\u5e93\u5b58\u8bf7\u68c0\u5355");
        ImmInvModelHelper.saveInspInfo(invScheme, exeDetails, applyCount);
        logger.info("\u8bb0\u5f55\u68c0\u9a8c\u660e\u7ec6\u8868");
        if (applyCount > 0) {
            String logMessage = incheckInfo.isEmpty() ? "" : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u68c0\u4fe1\u606f\uff1a%s", (String)"ImmInvModelHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), incheckInfo);
            InventoryInspHelper.setExeLog((DynamicObject)invScheme, (String)"A", (String)logMessage);
        } else {
            InventoryInspHelper.setExeLog((DynamicObject)invScheme, (String)"B", (String)ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u6ca1\u6709\u9700\u8981\u68c0\u9a8c\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u65b9\u6848\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"ImmInvModelHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        invGlobalArgs.getTargetIds().addAll(inspApplanIds);
    }

    private static Boolean inCheckJudge(List<Row> inspInfos, DataRowParamArgs paramModel) {
        Boolean passCheck = Boolean.FALSE;
        String dataSource = paramModel.getGlobalParamArgs().getDataSource();
        Long keyId = paramModel.getKeyId();
        String filterKey = paramModel.getGlobalParamArgs().getFilterKey();
        Optional<Row> matchOption = inspInfos.stream().filter(x -> dataSource.equals(x.getString("datasource")) && keyId.equals(x.getLong(filterKey))).findFirst();
        if (matchOption.isPresent()) {
            String tipStr;
            paramModel.setInCheck(matchOption.get().getBoolean("incheck"));
            Row row = paramModel.getRow();
            if ("A".equals(dataSource)) {
                tipStr = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a%1$s\uff0c\u5373\u65f6\u5e93\u5b58id\uff1a%2$s;", (String)"ImmInvModelHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), row.getString("material.number"), row.getLong("id"));
                paramModel.getSb().append(tipStr);
            } else {
                tipStr = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a%s;", (String)"ImmInvModelHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), row.getString("number"));
                paramModel.getSb().append(tipStr);
            }
        } else {
            paramModel.setInCheck(Boolean.FALSE);
        }
        Optional<QFilter> filterOption = paramModel.getGlobalParamArgs().getDataSetFilters().stream().filter(x -> "incheck".equals(x.getProperty())).findFirst();
        if (!filterOption.isPresent()) {
            passCheck = Boolean.TRUE;
        } else {
            Object inCheckValue = filterOption.get().getValue();
            if ("1".equals(inCheckValue)) {
                passCheck = paramModel.getInCheck();
            } else if ("0".equals(inCheckValue)) {
                passCheck = paramModel.getInCheck() == false;
            }
        }
        return passCheck;
    }

    private static Boolean lastCheckDateJudge(List<Row> inspInfos, DataRowParamArgs paramModel) {
        Optional<QFilter> filterOption;
        Boolean passCheck = Boolean.FALSE;
        String dataSource = paramModel.getGlobalParamArgs().getDataSource();
        Long keyId = paramModel.getKeyId();
        String filterKey = paramModel.getGlobalParamArgs().getFilterKey();
        DynamicObject invScheme = paramModel.getGlobalParamArgs().getInvScheme();
        Optional<Row> matchOption = inspInfos.stream().filter(x -> dataSource.equals(x.getString("datasource")) && keyId.equals(x.getLong(filterKey))).findFirst();
        Date lastDate = null;
        if (matchOption.isPresent() && null != (lastDate = matchOption.get().getDate("lastinspdate"))) {
            paramModel.setLastCheckDate(lastDate);
            Date nextCheckDate = paramModel.getGlobalParamArgs().getExeDate();
            Object inspectCyle = invScheme.get("inspectcyscle");
            if ("A".equals(inspectCyle)) {
                nextCheckDate = KDDateUtils.addDays((Date)KDDateUtils.addMonths((Date)lastDate, (int)invScheme.getInt("longmon")), (int)(0 - invScheme.getInt("inspectleadtime")));
            } else if ("B".equals(inspectCyle)) {
                nextCheckDate = KDDateUtils.addDays((Date)lastDate, (int)(invScheme.getInt("longday") - invScheme.getInt("inspectleadtime")));
            }
            paramModel.setNextCheckDate(nextCheckDate);
        }
        if (null == lastDate) {
            Date firstInspectDate = ImmInvModelHelper.getFirstInspDate(dataSource, invScheme.getString("firstinspectdate"), paramModel.getRow(), paramModel.getGlobalParamArgs().getExeDate(), invScheme);
            if (Objects.isNull(firstInspectDate)) {
                return Boolean.FALSE;
            }
            paramModel.setNextCheckDate(firstInspectDate);
        }
        if (!(filterOption = paramModel.getGlobalParamArgs().getDataSetFilters().stream().filter(x -> "lastinspdate".equals(x.getProperty())).findFirst()).isPresent()) {
            passCheck = Boolean.TRUE;
        } else if (matchOption.isPresent()) {
            passCheck = ImmInvModelHelper.dateJudge(paramModel.getLastCheckDate(), filterOption.get());
        }
        return passCheck;
    }

    private static Boolean nextCheckDateJudge(DataRowParamArgs paramModel) {
        Optional<QFilter> nextDateOption = paramModel.getGlobalParamArgs().getDataSetFilters().stream().filter(x -> "nextinspdate".equals(x.getProperty())).findFirst();
        if (!nextDateOption.isPresent()) {
            return Boolean.TRUE;
        }
        return ImmInvModelHelper.dateJudge(paramModel.getNextCheckDate(), nextDateOption.get());
    }

    private static Boolean dateJudge(Date lastDate, QFilter filter) {
        Date endDate;
        Date beginDate = (Date)filter.getValue();
        if (null == lastDate || lastDate.before(beginDate)) {
            return Boolean.FALSE;
        }
        List nests = filter.getNests(true);
        if (!nests.isEmpty() && lastDate.compareTo(endDate = (Date)((QFilter.QFilterNest)nests.get(0)).getFilter().getValue()) >= 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Date getFirstInspDate(String dataSouceStr, String firstInspectDateType, Row row, Date exeDate, DynamicObject invScheme) {
        Date initDate = null;
        Date firstInspDate = exeDate;
        if ("A".equals(dataSouceStr)) {
            String inspectCycle;
            switch (firstInspectDateType) {
                case "A": {
                    initDate = row.getDate("producedate");
                    break;
                }
                case "B": {
                    initDate = row.getDate("expirydate");
                    break;
                }
                case "C": {
                    initDate = invScheme.getDate("setdate");
                    break;
                }
            }
            if (null == initDate) {
                return null;
            }
            switch (inspectCycle = invScheme.getString("inspectcyscle")) {
                case "A": {
                    firstInspDate = KDDateUtils.addDays((Date)KDDateUtils.addMonths((Date)initDate, (int)invScheme.getInt("longmon")), (int)(0 - invScheme.getInt("inspectleadtime")));
                    break;
                }
                case "B": {
                    firstInspDate = KDDateUtils.addDays((Date)KDDateUtils.addDays((Date)initDate, (int)invScheme.getInt("longday")), (int)(0 - invScheme.getInt("inspectleadtime")));
                    break;
                }
                default: {
                    firstInspDate = KDDateUtils.addDays((Date)initDate, (int)(0 - invScheme.getInt("inspectleadtime")));
                }
            }
        }
        return firstInspDate;
    }

    private static List<Long> getPermissionOrgs(Long userId) {
        List viewOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)"im_real_bal_rpt", (String)"47150e89000000ac");
        logger.info("\u7528\u6237userId" + userId);
        logger.info("\u7528\u6237\u6709\u5982\u4e0b\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650" + viewOrgs);
        return viewOrgs;
    }

    private static Set<Object> getGroupMaterial(Set<Object> materGrpIdSet) {
        DynamicObjectCollection materialIdInfos = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material", (QFilter[])new QFilter("group", "in", materGrpIdSet).toArray());
        return materialIdInfos.stream().map(x -> x.get("material")).collect(Collectors.toSet());
    }

    private static Map<String, Long> getLotReflex(Set<String> lotnums) {
        HashMap<String, Long> lotnumReflex = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty(lotnums)) {
            DynamicObjectCollection lotInfos = QueryServiceHelper.query((String)"bd_lot", (String)"id,number", (QFilter[])new QFilter("number", "in", lotnums).toArray());
            Map<String, List<DynamicObject>> lotInfoGroup = lotInfos.stream().collect(Collectors.groupingBy(x -> x.getString("number")));
            Set<Map.Entry<String, List<DynamicObject>>> entrySet = lotInfoGroup.entrySet();
            for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
                lotnumReflex.put(entry.getKey(), entry.getValue().get(0).getLong("id"));
            }
        }
        return lotnumReflex;
    }

    static {
        HashMap<String, String> invMatchMap = new HashMap<String, String>(16);
        invMatchMap.put(ROWKEY, "id");
        invMatchMap.put(FILTERKEY, "inventoryid");
        sourceMatchKey.put("A", invMatchMap);
        HashMap<String, String> matMatchMap = new HashMap<String, String>(16);
        matMatchMap.put(ROWKEY, "id");
        matMatchMap.put(FILTERKEY, "materialid");
        sourceMatchKey.put("B", matMatchMap);
    }
}

