/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcnp.business.helper.datasource.freezeservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.InvPlatformHelper;
import kd.qmc.qcnp.business.helper.datasource.freezeservice.dtxmodel.FreezeParam;

public class QcnpFreezeServiceHelper {
    private static final String FREEZE = "freeze";
    private static final String UNFREEZE = "unfreeze";

    public void freezeInv(Map<Long, List<Long>> paraMap, DynamicObject[] planObjArr) {
        if (paraMap.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> mapList = this.getDealMap(paraMap, planObjArr, FREEZE, true);
        FreezeParam freezeParam = new FreezeParam();
        freezeParam.setFreezeParamMap(mapList);
        try (TXHandle h1 = TX.requiresNew();){
            try {
                ECServiceHelper.execute((String)"qcnp_event_freeze", null, (String)"qmc", (String)"qcnp", (String)"DtxFreezeService", (Param)freezeParam);
            }
            catch (Exception e) {
                h1.markRollback();
                String finStr = ResManager.loadKDString((String)"\u5e93\u5b58\u51bb\u7ed3\u5931\u8d25\u3002", (String)"QcnpFreezeServiceHelper_1", (String)"qmc-qcnp-business", (Object[])new Object[0]);
                throw new KDBizException(finStr);
            }
        }
        LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("qmc_region", "qcnp");
        String id = freezeParam.cacheId;
        JSONObject jsonObject = (JSONObject)localcache.get(id);
        localcache.remove(new String[]{id});
        if (!Objects.isNull(jsonObject)) {
            JSONObject resMap = jsonObject;
            DynamicObject[] objCol = BusinessDataServiceHelper.load((String)"qcnp_invinspectplan", (String)"id,name,billno,materialentry.id,materialentry.seq,materialentry.invfrezstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", mapList.keySet())});
            InvPlatformHelper.updateFreezeStatus(objCol, (Map<String, Object>)resMap, "A");
        }
    }

    public void unfreezeInv(Map<Long, List<Long>> paraMap, DynamicObject[] planObjArr, boolean validCheckComstatus) {
        if (paraMap.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> mapList = this.getDealMap(paraMap, planObjArr, UNFREEZE, validCheckComstatus);
        FreezeParam freezeParam = new FreezeParam();
        freezeParam.setFreezeParamMap(mapList);
        try (TXHandle h1 = TX.requiresNew();){
            try {
                ECServiceHelper.execute((String)"qcnp_event_unfreeze", null, (String)"qmc", (String)"qcnp", (String)"DtxUnFreezeService", (Param)freezeParam);
            }
            catch (Exception e) {
                h1.markRollback();
                String finStr = ResManager.loadKDString((String)"\u5e93\u5b58\u51bb\u7ed3\u5931\u8d25\u3002", (String)"QcnpFreezeServiceHelper_1", (String)"qmc-qcnp-business", (Object[])new Object[0]);
                throw new KDBizException(finStr);
            }
        }
        LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("qmc_region", "qcnp");
        String id = freezeParam.cacheId;
        JSONObject jsonObject = (JSONObject)localcache.get(id);
        localcache.remove(new String[]{id});
        if (!Objects.isNull(jsonObject)) {
            JSONObject resMap = jsonObject;
            DynamicObject[] objCol = BusinessDataServiceHelper.load((String)"qcnp_invinspectplan", (String)"id,name,billno,materialentry.id,materialentry.seq,materialentry.invfrezstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", mapList.keySet())});
            InvPlatformHelper.updateFreezeStatus(objCol, (Map<String, Object>)resMap, "");
        }
    }

    private Map<Long, List<Long>> getDealMap(Map<Long, List<Long>> paraMap, DynamicObject[] planObjArr, String flag, boolean validCheckComstatus) {
        HashMap<Long, List<Long>> returnMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject obj : planObjArr) {
            ArrayList<Long> idList = new ArrayList<Long>();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("materialentry");
            Long id = obj.getLong("id");
            List<Long> entryIdList = paraMap.get(id);
            for (DynamicObject entry : entryCol) {
                Long entryId = entry.getLong("id");
                if (!entryIdList.contains(entryId)) continue;
                if (FREEZE.equals(flag)) {
                    this.getNeedTofreezeInvId(idList, entry);
                }
                if (!UNFREEZE.equals(flag)) continue;
                this.getNeedToUnfreezeInvId(idList, entry, validCheckComstatus);
            }
            if (idList.isEmpty()) continue;
            returnMap.put(id, idList);
        }
        return returnMap;
    }

    public DynamicObject[] getDynamicObjects(Map<Long, List<Long>> paraMap) {
        if (paraMap.isEmpty()) {
            return null;
        }
        HashSet<Long> mainIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Long>> entry : paraMap.entrySet()) {
            mainIdSet.add(entry.getKey());
        }
        DynamicObject[] planObjArr = BusinessDataServiceHelper.load((String)"qcnp_invinspectplan", (String)"id, materialentry.id, materialentry.invfrezstatus , materialentry.scsystem, materialentry.checkcomstatus, materialentry.nowinvid, materialentry.execcasenum,baseqty, bcheckcomqty, checkcomqty, qualifbaseqty, unqualifbaseqty, inspresult, invmodqtybase, subentryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", mainIdSet)});
        return planObjArr;
    }

    private void getNeedTofreezeInvId(List<Long> idList, DynamicObject entry) {
        DynamicObject execSchem = entry.getDynamicObject("execcasenum");
        if (Objects.isNull(execSchem)) {
            return;
        }
        if ("".equals(entry.getString("invfrezstatus")) && "".equals(entry.getString("checkcomstatus")) && execSchem.getBoolean("inspectfreezeinv")) {
            Long id = entry.getLong("id");
            idList.add(id);
        }
    }

    private void getNeedToUnfreezeInvId(List<Long> idList, DynamicObject entry, boolean validCheckComstatus) {
        if (validCheckComstatus && !"A".equals(entry.getString("checkcomstatus"))) {
            return;
        }
        if ("A".equals(entry.getString("invfrezstatus"))) {
            Long id = entry.getLong("id");
            idList.add(id);
        }
    }
}

