/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcp.formplugin.inspection;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.qmc.qcbd.business.commonmodel.helper.SuspiciousValidateHelper;
import kd.qmc.qcbd.common.enums.SuspiciousValidateRuleEnum;

public class IncomingInspctBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("matintoentity");
        boolean isDraw = entryEntity.stream().anyMatch(x -> null != x.get("sourcebillno") && StringUtils.isNotEmpty((CharSequence)String.valueOf(x.get("sourcebillno"))));
        boolean isFromDb = dynamicObject.getDataEntityState().getFromDatabase();
        if (isDraw && !isFromDb) {
            Set validateRuleSet = SuspiciousValidateHelper.getValidateRule((DynamicObject)dynamicObject);
            for (int i = 0; i < entryEntity.size(); ++i) {
                SuspiciousValidateHelper.valSuspicious((IFormView)this.getView(), (DynamicObject)dynamicObject, (int)i, (Set)validateRuleSet);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String fieldName = e.getProperty().getName();
        block12: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            switch (fieldName) {
                case "materialid": {
                    SuspiciousValidateHelper.validateSuspicious((IFormView)this.getView(), (DynamicObject)dataEntity, (int)rowIndex, (String[])new String[]{SuspiciousValidateRuleEnum.MATERIAL.getValue(), SuspiciousValidateRuleEnum.MATERIAL_NUMBER.getValue(), SuspiciousValidateRuleEnum.PN.getValue()});
                    continue block12;
                }
                case "supplier": {
                    SuspiciousValidateHelper.validateSuspicious((IFormView)this.getView(), (DynamicObject)dataEntity, (int)rowIndex, (String[])new String[]{SuspiciousValidateRuleEnum.SUPPLIER.getValue()});
                    continue block12;
                }
                case "lotnumber": {
                    SuspiciousValidateHelper.validateSuspicious((IFormView)this.getView(), (DynamicObject)dataEntity, (int)rowIndex, (String[])new String[]{SuspiciousValidateRuleEnum.LOTNUMBER.getValue()});
                    continue block12;
                }
                case "transactype": {
                    this.transactypeChange(dataEntity, changeData);
                    continue block12;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "save": 
            case "submit": {
                this.refreshSuspiciousStatus();
                break;
            }
        }
    }

    private void refreshSuspiciousStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection matEntity = dataEntity.getDynamicObjectCollection("matintoentity");
        for (int i = 0; i < matEntity.size(); ++i) {
            this.getView().updateView("suspiciousstatus", i);
        }
    }

    private void transactypeChange(DynamicObject dataEntity, ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("matintoentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject rowObj = (DynamicObject)entryEntity.get(i);
                rowObj.set("suspiciousstatus", (Object)"");
                this.getView().updateView("suspiciousstatus", i);
            }
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("matintoentity");
        int index = 0;
        Set validateRule = SuspiciousValidateHelper.getValidateRule((DynamicObject)dataEntity);
        while (index < rowCount) {
            SuspiciousValidateHelper.valSuspicious((IFormView)this.getView(), (DynamicObject)dataEntity, (int)index++, (Set)validateRule);
        }
    }
}

