/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcp.formplugin.tginspection;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.qmc.qcp.common.tginspection.InspectConst;

public class InspectEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("joininspstatusview", this.getModel().getValue("joininspstatus", 0));
        this.getModel().setValue("unjoininspstatusview", this.getModel().getValue("unjoininspstatus", 0));
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        if (source == null) {
            return;
        }
        String entryKey = source.getEntryKey();
        int row = evt.getRow();
        if (StringUtils.equals((CharSequence)entryKey, (CharSequence)"matintoentity")) {
            this.getModel().setValue("joininspstatusview", this.getModel().getValue("joininspstatus", row));
            this.getModel().setValue("unjoininspstatusview", this.getModel().getValue("unjoininspstatus", row));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
                if (billType != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"InspectEdit_0", (String)"qmc-qcp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "newentry": {
                this.getModel().setValue("joininspstatusview", (Object)InspectConst.JOININSPSTATUSENUM.donot.name());
                this.getModel().setValue("unjoininspstatusview", (Object)InspectConst.JOININSPSTATUSENUM.donot.name());
                break;
            }
            case "newentry-inspitem": 
            case "deleteentry-inspitem": {
                this.computeJoinInspectStatus(this.getModel().getEntryCurrentRowIndex("matintoentity"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        block9: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            int parentRowIndex = changeData.getParentRowIndex();
            switch (fieldName) {
                case "isjoininspect": 
                case "projckresult": {
                    this.computeJoinInspectStatus(parentRowIndex);
                    continue block9;
                }
                case "inspectionstd": {
                    this.inspectionstdChange(newValue, rowIndex);
                    this.computeJoinInspectStatus(rowIndex);
                    continue block9;
                }
            }
        }
    }

    private void computeJoinInspectStatus(int matRowIndex) {
        DynamicObjectCollection proSubEntrys = this.getSubEntrys(matRowIndex, "inspsubentity");
        Map<Boolean, List<DynamicObject>> statusMap = proSubEntrys.stream().collect(Collectors.groupingBy(o -> o.getBoolean("isjoininspect")));
        IDataModel model = this.getModel();
        if (!statusMap.containsKey(Boolean.TRUE)) {
            model.setValue("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.donot.name(), matRowIndex);
        } else if (statusMap.get(Boolean.TRUE).stream().allMatch(o -> StringUtils.isNotBlank((CharSequence)o.getString("projckresult")))) {
            model.setValue("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.finish.name(), matRowIndex);
        } else {
            model.setValue("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.executing.name(), matRowIndex);
        }
        if (!statusMap.containsKey(Boolean.FALSE)) {
            model.setValue("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.donot.name(), matRowIndex);
        } else if (statusMap.get(Boolean.FALSE).stream().allMatch(o -> StringUtils.isNotBlank((CharSequence)o.getString("projckresult")))) {
            model.setValue("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.finish.name(), matRowIndex);
        } else {
            model.setValue("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.executing.name(), matRowIndex);
        }
        model.setValue("joininspstatusview", model.getValue("joininspstatus", model.getEntryCurrentRowIndex("matintoentity")));
        model.setValue("unjoininspstatusview", model.getValue("unjoininspstatus", model.getEntryCurrentRowIndex("matintoentity")));
    }

    private void inspectionstdChange(Object newValue, int rowIndex) {
        DynamicObjectCollection stdEntrys;
        DynamicObject inspectionstd = (DynamicObject)newValue;
        DynamicObjectCollection subEntrys = this.getSubEntrys(rowIndex, "inspsubentity");
        if (null != inspectionstd && !(stdEntrys = inspectionstd.getDynamicObjectCollection("entryentity")).isEmpty()) {
            for (int i = 0; i < stdEntrys.size(); ++i) {
                DynamicObject inspsubEntry = (DynamicObject)subEntrys.get(i);
                inspsubEntry.set("isjoininspect", ((DynamicObject)stdEntrys.get(i)).get("isjoininspect"));
            }
        }
        this.getModel().updateEntryCache(subEntrys);
        this.getView().updateView("inspsubentity");
    }

    private DynamicObjectCollection getSubEntrys(int rowIndex, String subEntryKey) {
        DynamicObjectCollection matEntrys = this.getModel().getEntryEntity("matintoentity");
        return ((DynamicObject)matEntrys.get(rowIndex)).getDynamicObjectCollection(subEntryKey);
    }
}

