/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcp.opplugin;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.login.utils.StringUtils;
import kd.qmc.qcbd.business.commonmodel.helper.SuspiciousValidateHelper;
import kd.qmc.qcbd.common.enums.SuspiciousStatusEnum;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcp.opplugin.validator.IncomingInspectBillValidator;

public class IncomingInspctBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("suspiciousstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        SuspiciousValidateHelper suspiciousValidate = new SuspiciousValidateHelper();
        for (DynamicObject billObj : dataEntities) {
            DynamicObjectCollection entryObj = billObj.getDynamicObjectCollection("matintoentity");
            Set validateRuleSet = SuspiciousValidateHelper.getValidateRule((DynamicObject)billObj);
            if (validateRuleSet == null || validateRuleSet.isEmpty()) {
                return;
            }
            List checkList = suspiciousValidate.setValidateFields(validateRuleSet);
            Set checkResultSet = suspiciousValidate.checkSuspicious(billObj, validateRuleSet);
            for (DynamicObject dynObj : entryObj) {
                String suspicious = dynObj.getString("suspiciousstatus");
                if (!StringUtils.isEmpty((String)suspicious)) continue;
                String onlyObjStr = DynamicObjUtil.getOnlyObjStr((DynamicObject)dynObj, (List)checkList);
                if (checkResultSet.contains(onlyObjStr)) {
                    dynObj.set("suspiciousstatus", (Object)SuspiciousStatusEnum.SUSPICIOUS.getValue());
                    continue;
                }
                dynObj.set("suspiciousstatus", (Object)SuspiciousStatusEnum.NON_SUSPICIOUS.getValue());
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new IncomingInspectBillValidator());
    }
}

