/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcp.opplugin.tginspection;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcp.common.tginspection.InspectConst;

public class InspectSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isjoininspect");
        e.getFieldKeys().add("joininspstatus");
        e.getFieldKeys().add("unjoininspstatus");
        e.getFieldKeys().add("projckresult");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Boolean apiFlag = OppUtil.isFromApi((OperateOption)this.operateOption);
        Boolean importFlag = OppUtil.isImport((OperateOption)this.operateOption);
        for (DynamicObject billObj : dataEntities) {
            DynamicObjectCollection matEntrys = billObj.getDynamicObjectCollection("matintoentity");
            for (DynamicObject matEntry : matEntrys) {
                if (!importFlag.booleanValue() && !apiFlag.booleanValue()) continue;
                DynamicObjectCollection subProjentrys = matEntry.getDynamicObjectCollection("inspsubentity");
                this.computeJoinInspectStatus(matEntry, subProjentrys);
            }
        }
    }

    private void computeJoinInspectStatus(DynamicObject matRow, DynamicObjectCollection proSubEntrys) {
        Map<Boolean, List<DynamicObject>> statusMap = proSubEntrys.stream().collect(Collectors.groupingBy(o -> o.getBoolean("isjoininspect")));
        if (!statusMap.containsKey(Boolean.TRUE)) {
            matRow.set("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.donot.name());
        } else if (statusMap.get(Boolean.TRUE).stream().allMatch(o -> StringUtils.isNotBlank((CharSequence)o.getString("projckresult")))) {
            matRow.set("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.finish.name());
        } else {
            matRow.set("joininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.executing.name());
        }
        if (!statusMap.containsKey(Boolean.FALSE)) {
            matRow.set("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.donot.name());
        } else if (statusMap.get(Boolean.FALSE).stream().allMatch(o -> StringUtils.isNotBlank((CharSequence)o.getString("projckresult")))) {
            matRow.set("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.finish.name());
        } else {
            matRow.set("unjoininspstatus", (Object)InspectConst.JOININSPSTATUSENUM.executing.name());
        }
    }
}

