/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcp.opplugin.validator;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.business.commonmodel.helper.SuspiciousValidateHelper;
import kd.qmc.qcbd.common.enums.SuspiciousStatusEnum;
import kd.qmc.qcbd.common.util.DynamicObjUtil;

public class IncomingInspectBillValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            SuspiciousValidateHelper suspiciousValidate = new SuspiciousValidateHelper();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject billObj = dataEntity.getDataEntity();
                Set validateRuleSet = SuspiciousValidateHelper.getValidateRule((DynamicObject)billObj);
                if (validateRuleSet == null || validateRuleSet.isEmpty()) {
                    return;
                }
                List checkList = suspiciousValidate.setValidateFields(validateRuleSet);
                Set checkResultSet = suspiciousValidate.checkSuspicious(billObj, validateRuleSet);
                DynamicObjectCollection entryObj = billObj.getDynamicObjectCollection("matintoentity");
                for (int i = 0; i < entryObj.size(); ++i) {
                    DynamicObject object = (DynamicObject)entryObj.get(i);
                    String suspicious = object.getString("suspiciousstatus");
                    String onlyObjStr = DynamicObjUtil.getOnlyObjStr((DynamicObject)object, (List)checkList);
                    if (checkResultSet.contains(onlyObjStr) && SuspiciousStatusEnum.NON_SUSPICIOUS.getValue().equals(suspicious)) {
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\u5728\u53ef\u7591\u4ef6\u6e05\u5355\u4e2d\uff0c\u662f\u5426\u5c06\u68c0\u9a8c\u5355\u4e2d\u7684\u53ef\u7591\u4ef6\u72b6\u6001\u4fee\u6539\u4e3a\u201c\u975e\u53ef\u7591\u4ef6\u201d\uff1f", (String)"IncomingInspectBillValidator_0", (String)"qmc-qcp-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (checkResultSet.contains(onlyObjStr) || !SuspiciousStatusEnum.SUSPICIOUS.getValue().equals(suspicious)) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\u4e0d\u5728\u53ef\u7591\u4ef6\u6e05\u5355\u4e2d\uff0c\u662f\u5426\u5c06\u68c0\u9a8c\u5355\u4e2d\u7684\u53ef\u7591\u4ef6\u72b6\u6001\u4fee\u6539\u4e3a\u201c\u53ef\u7591\u4ef6\u201d\uff1f", (String)"IncomingInspectBillValidator_1", (String)"qmc-qcp-opplugin", (Object[])new Object[0]), i + 1));
                }
            }
        }
    }
}

