/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.opplugin.corandpre;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.qmc.qcqi.common.utils.CorrectAndPrevenUtil;

public class CorAndPreAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("planclosetime");
        e.getFieldKeys().add("infactclosetime");
        e.getFieldKeys().add("progress");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject billObj : dataEntities = e.getDataEntities()) {
            if (Objects.isNull(billObj.get("infactclosetime"))) {
                Date auditDate = billObj.getDate("auditdate");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(auditDate);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                billObj.set("infactclosetime", (Object)calendar.getTime());
            }
            String status = billObj.getString("billstatus");
            Date planClose = billObj.getDate("planclosetime");
            Date infactClose = billObj.getDate("infactclosetime");
            String progress = CorrectAndPrevenUtil.computeProgress((String)status, (Date)planClose, (Date)infactClose);
            billObj.set("progress", (Object)progress);
        }
        e.setDataEntities(dataEntities);
    }
}

