/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.opplugin.corandpre;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcqi.business.helper.SendMsgHelper;
import kd.qmc.qcqi.business.helper.UpdateStatusHelper;
import kd.qmc.qcqi.opplugin.validator.CorrentAndPreventValidator;

public class CorrectAndPreventOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("planclosetime");
        e.getFieldKeys().add("infactclosetime");
        e.getFieldKeys().add("progress");
        e.getFieldKeys().add("srcordernum");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("badinfoentry");
        e.getFieldKeys().add("srcbillentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CorrentAndPreventValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("delete".equals(operationKey)) {
            for (DynamicObject dynamicObject : dataEntities) {
                UpdateStatusHelper updateDelHelper = new UpdateStatusHelper();
                updateDelHelper.setValueByDelete(dynamicObject, "badinfoentry");
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operation = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] problemNotice = null;
        switch (operation) {
            case "save": 
            case "submit": {
                UpdateStatusHelper saveAndSubmitHelper = new UpdateStatusHelper();
                for (DynamicObject dynamicObject : dataEntities) {
                    problemNotice = saveAndSubmitHelper.setValueBySave(dynamicObject, "badinfoentry");
                    if (problemNotice == null) continue;
                    SaveServiceHelper.save((DynamicObject[])problemNotice);
                }
                break;
            }
            case "audit": {
                String infactCloseTime = "infactclosetime";
                UpdateStatusHelper auditHelper = new UpdateStatusHelper();
                for (DynamicObject dynamicObject : dataEntities) {
                    Set entryId = auditHelper.getEntryId(dynamicObject, "badinfoentry");
                    problemNotice = auditHelper.setValueByAudit(dynamicObject, infactCloseTime, "rptclosedate", "badinfoentry");
                    if (problemNotice == null) continue;
                    SaveServiceHelper.save((DynamicObject[])problemNotice);
                    SendMsgHelper sendMsgHelper = new SendMsgHelper();
                    sendMsgHelper.sendMessage(problemNotice, entryId);
                }
                break;
            }
            case "unaudit": {
                UpdateStatusHelper unAuditHelper = new UpdateStatusHelper();
                for (DynamicObject dynamicObject : dataEntities) {
                    Set entryId = unAuditHelper.getEntryId(dynamicObject, "badinfoentry");
                    problemNotice = unAuditHelper.setValuesByUnAudit(dynamicObject, "badinfoentry");
                    if (problemNotice == null) continue;
                    SaveServiceHelper.save((DynamicObject[])problemNotice);
                    SendMsgHelper sendMsgHelper = new SendMsgHelper();
                    sendMsgHelper.sendMessage(problemNotice, entryId);
                }
                break;
            }
        }
    }
}

