/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.opplugin.problemnotice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.qmc.qcqi.opplugin.validator.ProblemNoticeValidator;

public class ProblemNoticeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("handler");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("feedbackdesc");
        e.getFieldKeys().add("feedbackdesc_tag");
        e.getFieldKeys().add("feedbackstatus");
        e.getFieldKeys().add("feedbacker");
        e.getFieldKeys().add("facebacktime");
        e.getFieldKeys().add("feedattachment");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ProblemNoticeValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            DynamicObject[] dataEntities;
            String accountId = RequestContext.get().getAccountId();
            for (DynamicObject dynObj : dataEntities = e.getDataEntities()) {
                Object pk = dynObj.getPkValue();
                DynamicObjectCollection entryObj = dynObj.getDynamicObjectCollection("entryentity");
                HashSet<Long> receiverSet = new HashSet<Long>();
                for (DynamicObject dyn : entryObj) {
                    DynamicObject handler = dyn.getDynamicObject("handler");
                    receiverSet.add(handler.getLong("id"));
                }
                ArrayList receivers = new ArrayList(receiverSet);
                MessageInfo message = new MessageInfo();
                message.setUserIds(receivers);
                message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
                message.setSendTime(KDDateUtils.now());
                message.setType("message");
                message.setEntityNumber("qcqi_problemnotice");
                message.setBizDataId(Long.valueOf(String.valueOf(pk)));
                message.setTplScene("qcqi_problemnotice_audit");
                String clientUrl = UrlService.getDomainContextUrl();
                String currUrl = clientUrl + "/index.html?formId=qcqi_problemnotice&mb_formId=qcqi_problemnotice_mob&pkId=" + pk + "&accountId=" + accountId;
                message.setContentUrl(currUrl);
                MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            }
        } else if ("unaudit".equals(operationKey)) {
            Long[] ids = (Long[])Arrays.stream(e.getDataEntities()).filter(o -> o.getDynamicObject("billtype").getLong("id") == 1449229810269209600L).map(o -> o.getLong("id")).toArray(Long[]::new);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurProblemNoticeService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{ids});
            if (((Boolean)result.get("success")).booleanValue()) {
                for (DynamicObject dataEntity : e.getDataEntities()) {
                    if (dataEntity.getDynamicObject("billtype").getLong("id") != 1449229810269209600L) continue;
                    DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        entry.set("feedbackdesc", null);
                        entry.set("feedbackdesc_tag", null);
                        entry.set("feedbackstatus", (Object)"A");
                        entry.set("feedbacker", null);
                        entry.set("facebacktime", null);
                        entry.set("feedattachment", null);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            }
        }
    }
}

