/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.opplugin.qcactivity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.DateUtil;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcqi.opplugin.qcactivity.QcountScoreValidator;

public class QcountScoreReviewStatusOp
extends AbstractOperationServicePlugIn {
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("reviewstatus");
        e.getFieldKeys().add("topiccomp");
        e.getFieldKeys().add("reviewcommit");
        e.getFieldKeys().add("scoretype");
        e.getFieldKeys().add("scoreava");
        e.getFieldKeys().add("qcreviewstatus");
        e.getFieldKeys().add("userid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new QcountScoreValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operate = e.getOperationKey();
        ArrayList<DynamicObject> materials = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            String billType = dataEntity.getDynamicObjectType().getName();
            Long id = dataEntity.getLong("id");
            HashSet<Long> srcbillidset = new HashSet<Long>();
            srcbillidset.add(dataEntity.getLong("srcbillid"));
            if ("submit".equals(operate) || "rowreviewin".equals(operate)) {
                this.auditUpdate(id, billType, operate, srcbillidset);
                dataEntity.set("reviewstatus", (Object)Character.valueOf('B'));
                materials.add(dataEntity);
                continue;
            }
            if (AUDIT.equals(operate)) {
                this.auditUpdate(id, billType, operate, srcbillidset);
                if (dataEntity.get("topiccomp") == null) {
                    Date currentDate = DateUtil.getStartOfDay((Date)new Date());
                    dataEntity.set("topiccomp", (Object)currentDate);
                } else {
                    dataEntity.set("topiccomp", dataEntity.get("topiccomp"));
                }
                dataEntity.set("reviewstatus", (Object)Character.valueOf('C'));
                materials.add(dataEntity);
                continue;
            }
            if (UNAUDIT.equals(operate)) {
                this.auditUpdate(id, billType, operate, srcbillidset);
                dataEntity.set("reviewstatus", (Object)Character.valueOf('B'));
                materials.add(dataEntity);
                continue;
            }
            if (!"delete".equals(operate)) continue;
            this.auditUpdate(id, billType, operate, srcbillidset);
        }
        DynamicObject[] materialsArr = materials.toArray(new DynamicObject[materials.size()]);
        SaveServiceHelper.update((DynamicObject[])materialsArr);
    }

    private void auditUpdate(Long id, String srcBillType, String operate, HashSet<Long> srcbillidset) {
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)srcBillType, (Long[])new Long[]{id});
        if (sourceBills == null || sourceBills.isEmpty()) {
            return;
        }
        if (sourceBills.containsKey("qcqi_qcreviewplan")) {
            this.updateReviewStatus(sourceBills, "qcqi_qcreviewplan", operate, srcbillidset);
        }
        if (sourceBills.containsKey("qcqi_qctopicmanage")) {
            this.updateReviewStatus(sourceBills, "qcqi_qctopicmanage", operate, srcbillidset);
        }
        if (sourceBills.containsKey("qcqi_qcactpromanage")) {
            this.updateReviewStatus(sourceBills, "qcqi_qcactpromanage", operate, srcbillidset);
        }
    }

    public void updateReviewStatus(Map<String, HashSet<Long>> sourceBills, String billType, String operate, HashSet<Long> srcbillidset) {
        DynamicObject[] sourceData;
        ArrayList<DynamicObject> materials = new ArrayList<DynamicObject>();
        for (DynamicObject applyitem : sourceData = DynamicObjUtil.getLoadData((String)billType, (Set)sourceBills.get(billType))) {
            if (AUDIT.equals(operate)) {
                if ("qcqi_qcreviewplan".equals(billType)) {
                    applyitem.set("reviewstatus", (Object)Character.valueOf('C'));
                    materials.add(applyitem);
                    continue;
                }
                if (!"qcqi_qctopicmanage".equals(billType) && !"qcqi_qcactpromanage".equals(billType)) continue;
                applyitem.set("topicstatus", (Object)Character.valueOf('D'));
                materials.add(applyitem);
                continue;
            }
            if ("submit".equals(operate) || "rowreviewin".equals(operate) || UNAUDIT.equals(operate)) {
                if ("qcqi_qcreviewplan".equals(billType)) {
                    applyitem.set("reviewstatus", (Object)Character.valueOf('B'));
                    materials.add(applyitem);
                    continue;
                }
                if (!"qcqi_qctopicmanage".equals(billType) && !"qcqi_qcactpromanage".equals(billType)) continue;
                applyitem.set("topicstatus", (Object)Character.valueOf('C'));
                materials.add(applyitem);
                continue;
            }
            if (!"delete".equals(operate)) continue;
            if ("qcqi_qcreviewplan".equals(billType)) {
                applyitem.set("reviewstatus", (Object)Character.valueOf('A'));
                materials.add(applyitem);
                continue;
            }
            if (!"qcqi_qctopicmanage".equals(billType) && !"qcqi_qcactpromanage".equals(billType)) continue;
            applyitem.set("topicstatus", (Object)Character.valueOf('E'));
            materials.add(applyitem);
        }
        if (materials.isEmpty()) {
            return;
        }
        DynamicObject[] materialsArr = materials.toArray(new DynamicObject[materials.size()]);
        SaveServiceHelper.update((DynamicObject[])materialsArr);
    }
}

