/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.report.formplugin.problemnotice;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.qmc.qcqi.business.helper.ProblemNoticeRptHelper;
import kd.qmc.qcqi.common.constant.rpt.RepeatProblemRptConst;

public class ProblemNoticePlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
SearchListener {
    public void registerListener(EventObject e) {
        MulBasedataEdit createOrg;
        super.registerListener(e);
        ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
        rf.addSearchListener((SearchListener)this);
        MulBasedataEdit billType = (MulBasedataEdit)this.getView().getControl("billtype");
        if (billType != null) {
            billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((createOrg = (MulBasedataEdit)this.getView().getControl("org")) != null) {
            createOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        for (String mulBasedataEditFiled : RepeatProblemRptConst.mulBasedataEditF7Fileds) {
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl(mulBasedataEditFiled);
            if (mulBasedataEdit == null) continue;
            mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void search(SearchEvent arg0) {
        ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
        rf.setCollapse(false);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams.containsKey("org")) {
            model.setValue("org", (Object)new Object[]{customParams.get("org")});
        } else {
            RequestContext requestContext = RequestContext.get();
            Object[] objects = new Object[]{requestContext.getOrgId()};
            model.setValue("org", (Object)objects);
        }
        model.setValue("billtype", (Object)RepeatProblemRptConst.billTypeArr);
        model.setValue("startdate", (Object)KDDateUtils.addMonths((Date)KDDateUtils.today(), (int)-6));
        model.setValue("enddate", (Object)KDDateUtils.today());
        for (String filedParam : RepeatProblemRptConst.filedParams) {
            if (!customParams.containsKey(filedParam)) continue;
            Object filedParamValue = customParams.get(filedParam);
            if (filedParamValue instanceof Long) {
                model.setValue(filedParam, (Object)new Object[]{filedParamValue});
            }
            if (filedParamValue instanceof Integer) {
                model.setValue(filedParam, (Object)new Object[]{((Integer)filedParamValue).longValue()});
            }
            if (!(filedParamValue instanceof String)) continue;
            model.setValue(filedParam, filedParamValue);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"conditionflex", "reportlistap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IReportView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        String key = "isInitQuery";
        if (customParams.containsKey(key)) {
            ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
            rf.search();
            rf.setCollapse(false);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        this.getView().setVisible(Boolean.TRUE, new String[]{"conditionflex", "reportlistap"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        HashMap<String, Object> customParam = new HashMap<String, Object>(1);
        customParam.put("countrule", this.getModel().getValue("countrule"));
        this.getQueryParam().setCustomParam(customParam);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.verifyQueryImpl(queryParam);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"showdetail", (CharSequence)operateKey)) {
            this.showListDetail();
        } else if (StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
            rf.setCollapse(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        List createOrgIds = this.getModel().getDataEntity(true).getDynamicObjectCollection("org").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        QFilter qFilter = null;
        switch (key) {
            case "org": {
                qFilter = this.setOrgPermFilter();
                break;
            }
            case "billtype": {
                qFilter = new QFilter("id", "in", (Object)RepeatProblemRptConst.billTypeArr);
                break;
            }
            case "materialid": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
            case "unquaproblem": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"qcbd_unquaproblem", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
            case "supplierid": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
            case "customerid": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
            case "oprworkshop": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_org", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
            case "productionworkshop": {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup)", createOrgIds, (boolean)Boolean.TRUE);
                break;
            }
        }
        e.addCustomQFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (!StringUtils.equals((CharSequence)"org", (CharSequence)fieldName)) continue;
            MulBasedataDynamicObjectCollection newOrgDynamicObjectCollection = (MulBasedataDynamicObjectCollection)newValue;
            MulBasedataDynamicObjectCollection oldOrgDynamicObjectCollection = (MulBasedataDynamicObjectCollection)oldValue;
            if (CollectionUtils.isEmpty((Collection)newOrgDynamicObjectCollection)) {
                model.setValue("org", oldValue);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)oldOrgDynamicObjectCollection)) continue;
            for (String mulBasedataEditF7Filed : RepeatProblemRptConst.mulBasedataEditF7Fileds) {
                model.setValue(mulBasedataEditF7Filed, null);
            }
        }
    }

    private QFilter setOrgPermFilter() {
        String appId;
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"", (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)"qcqi_repeatproblemrpt", (String)"47150e89000000ac");
        QFilter qFilter = result.hasAllOrgPerm() ? null : new QFilter("id", "in", (Object)result.getHasPermOrgs());
        return qFilter;
    }

    private boolean verifyQueryImpl(ReportQueryParam queryParam) {
        boolean a = true;
        FilterInfo filter = queryParam.getFilter();
        StringBuilder sb = new StringBuilder();
        if (Objects.isNull(filter.getValue("org"))) {
            sb.append(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProblemNoticePlugin_0", (String)"qmc-qcqi-report", (Object[])new Object[0]));
        }
        if (Objects.isNull(filter.getValue("billtype"))) {
            sb.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProblemNoticePlugin_1", (String)"qmc-qcqi-report", (Object[])new Object[0]));
        }
        if (Objects.isNull(filter.getValue("startdate")) || Objects.isNull(filter.getValue("enddate"))) {
            sb.append(ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProblemNoticePlugin_2", (String)"qmc-qcqi-report", (Object[])new Object[0]));
        }
        if (Objects.isNull(filter.getValue("countrule"))) {
            sb.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProblemNoticePlugin_3", (String)"qmc-qcqi-report", (Object[])new Object[0]));
        }
        if (sb.length() != 0) {
            this.getView().showTipNotification(sb.toString());
            a = false;
        }
        return a;
    }

    private void showListDetail() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"qcqi_problemnotice", (boolean)true, (int)0, (boolean)false);
        List filters = this.getQueryParam().getFilter().getQFilters();
        QFilter qFilter = ProblemNoticeRptHelper.buildQfilter((ReportQueryParam)this.getQueryParam(), (String)((String)this.getModel().getValue("countrule")));
        filters.add(qFilter);
        showParameter.getListFilterParameter().setQFilters(filters);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        String customParam = "fromProBlemNoticeRpt";
        showParameter.setCustomParam(customParam, (Object)"true");
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

