/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.mservice;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class CorrectPreventServiceImpl {
    private static Log logger = LogFactory.getLog(CorrectPreventServiceImpl.class);

    public MserviceResult batchAddNewEntry(List<Map<String, Object>> reqParamList) {
        logger.info("batchAddNewEntry-reqParamList:" + reqParamList);
        HashMap<Long, DynamicObject> correctPreventCache = new HashMap<Long, DynamicObject>(16);
        MserviceResult result = this.checkReqParamList(reqParamList, correctPreventCache);
        if ("1".equalsIgnoreCase(result.getRetCode())) {
            logger.info("batchAddNewEntry-passcheck.");
            this.batchAddNewEntry(reqParamList, correctPreventCache);
        }
        return result;
    }

    private MserviceResult checkReqParamList(List<Map<String, Object>> reqParamList, Map<Long, DynamicObject> correctPreventCache) {
        String dataErrMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"CorrectPreventServiceImpl_1", (String)"qmc-qcqi-mservice", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(reqParamList)) {
            return new MserviceResult("-1", dataErrMsg, null);
        }
        MserviceResult result = new MserviceResult("1", "", null);
        for (Map<String, Object> reqParam : reqParamList) {
            if (reqParam instanceof Map) {
                Map<String, Object> reqParamMap = reqParam;
                Iterator<Map<String, Object>> id = reqParamMap.get("id");
                if (id instanceof Long) continue;
                result.setRetCode("-1");
                result.setRetMsg(ResManager.loadKDString((String)"\u5355\u636eid\u5fc5\u987b\u662f\u957f\u6574\u578b\u3002", (String)"CorrectPreventServiceImpl_0", (String)"qmc-qcqi-mservice", (Object[])new Object[0]));
                return result;
            }
            result.setRetCode("-1");
            result.setRetMsg(dataErrMsg);
            return result;
        }
        Set idSet = reqParamList.stream().map(x -> x.get("id")).collect(Collectors.toSet());
        logger.info("checkReqParamList-effective-req-id:" + idSet);
        if (CollectionUtils.isNotEmpty(idSet)) {
            DynamicObject[] correctPrevents = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcqi_correctandprevent"));
            correctPreventCache.putAll(Arrays.stream(correctPrevents).collect(Collectors.toMap(x -> x.getLong("id"), x -> x)));
            StringBuilder sb = new StringBuilder();
            for (Map<String, Object> reqParamMap : reqParamList) {
                Long id = (Long)reqParamMap.get("id");
                if (!correctPreventCache.containsKey(id)) {
                    sb.append(String.format(ResManager.loadKDString((String)"id%s\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CorrectPreventServiceImpl_2", (String)"qmc-qcqi-mservice", (Object[])new Object[0]), id));
                    continue;
                }
                Set<Map.Entry<String, Object>> entrySet = reqParamMap.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    String entryName = entry.getKey();
                    if ("id".equalsIgnoreCase(entryName)) continue;
                    Object entryValue = entry.getValue();
                    boolean passCheck = false;
                    if (entryValue instanceof List) {
                        List rowDataList = (List)entryValue;
                        for (Object rowData : rowDataList) {
                            if (!(rowData instanceof Map)) continue;
                            passCheck = true;
                        }
                    }
                    if (passCheck) continue;
                    sb.append(String.format(ResManager.loadKDString((String)"id%1$s\uff0c\u5355\u636e\u4f53%2$s\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CorrectPreventServiceImpl_3", (String)"qmc-qcqi-mservice", (Object[])new Object[0]), id, entryName));
                }
            }
            String errMsg = sb.toString();
            if (StringUtils.isNotEmpty((String)errMsg)) {
                result.setRetCode("-1");
                result.setRetMsg(errMsg);
            }
        }
        return result;
    }

    private void batchAddNewEntry(List<Map<String, Object>> reqParamList, Map<Long, DynamicObject> correctPreventCache) {
        logger.info("batchAddNewEntry-correctPreventCache:" + correctPreventCache);
        for (Map<String, Object> reqParamMap : reqParamList) {
            Long id = (Long)reqParamMap.get("id");
            DynamicObject correctPrevent = correctPreventCache.get(id);
            Set<Map.Entry<String, Object>> entrySet = reqParamMap.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String entryName = entry.getKey();
                if ("id".equalsIgnoreCase(entryName)) continue;
                Object entryValue = entry.getValue();
                List rowDataList = (List)entryValue;
                DynamicObjectCollection entryCollection = correctPrevent.getDynamicObjectCollection(entryName);
                for (Map rowData : rowDataList) {
                    DynamicObject newEntryRow = entryCollection.addNew();
                    Set rowDataEntrySet = rowData.entrySet();
                    block17: for (Map.Entry rowDataEntry : rowDataEntrySet) {
                        String propKey;
                        switch (propKey = (String)rowDataEntry.getKey()) {
                            case "attachment": 
                            case "provefa": 
                            case "provedp": 
                            case "provetmp": 
                            case "proveca": 
                            case "provecm": 
                            case "proveec": 
                            case "provepm": 
                            case "provepl": {
                                DynamicObjDataUtil.setAttachMentValue((DynamicObject)newEntryRow, (String)propKey, rowDataEntry.getValue());
                                continue block17;
                            }
                        }
                        DynamicObjDataUtil.setPropValue((DynamicObject)newEntryRow, (String)propKey, rowDataEntry.getValue());
                    }
                }
            }
        }
        logger.info("batchAddNewEntry-correctPreventCache-afterAddEntry:" + correctPreventCache);
        SaveServiceHelper.save((DynamicObject[])correctPreventCache.values().toArray(new DynamicObject[0]));
    }
}

