/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.mservice.upgrade;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.DateUtil;
import kd.qmc.qcbd.common.util.DynamicObjUtil;

public class QcAwardManageUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(QcAwardManageUpgradeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        try (TXHandle h1 = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                this.repairDatas();
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            finally {
                if (!result.isSuccess()) {
                    h1.markRollback();
                }
            }
        }
        return new UpgradeResult();
    }

    private void repairDatas() {
        QFilter[] qFilters = new QFilter[]{new QFilter("qcteamentry.topiccomp", "!=", null)};
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"qcqi_qcawardmanage", (String)"id", (QFilter[])qFilters);
        List ids = DynamicObjUtil.getIDs((DynamicObjectCollection)colls);
        List idGrpList = AverageAssignUtil.getAssignListByMaxSize((List)ids, (int)10000);
        for (List idGrp : idGrpList) {
            DynamicObject[] load;
            for (DynamicObject dynObj : load = BusinessDataServiceHelper.load((String)"qcqi_qcawardmanage", (String)"id,qcteamentry.topiccomp", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idGrp)})) {
                DynamicObjectCollection qcteamentry = dynObj.getDynamicObjectCollection("qcteamentry");
                for (DynamicObject dyn : qcteamentry) {
                    Date topiccomp = dyn.getDate("topiccomp");
                    Date startOfDay = DateUtil.getStartOfDay((Date)topiccomp);
                    dyn.set("topiccomp", (Object)startOfDay);
                }
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }
}

