/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.business.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.KDDateUtils;

public class ProblemNoticeRptHelper {
    public static QFilter buildQfilter(ReportQueryParam param, String countRule) {
        FilterInfo filterInfo = param.getFilter();
        QFilter qFilter = new QFilter("org", "in", ProblemNoticeRptHelper.getIds(filterInfo.getDynamicObjectCollection("org")));
        qFilter.and("billtype", "in", ProblemNoticeRptHelper.getIds(filterInfo.getDynamicObjectCollection("billtype")));
        qFilter.and("createtime", ">=", (Object)filterInfo.getDate("startdate"));
        qFilter.and("createtime", "<=", (Object)new Date(KDDateUtils.addDays((Date)filterInfo.getDate("enddate"), (int)1).getTime() - 1L));
        if (StringUtils.isNotBlank((CharSequence)countRule)) {
            String[] countRuleArr;
            for (String counRule : countRuleArr = countRule.substring(1, countRule.length() - 1).split(",")) {
                if (StringUtils.equals((CharSequence)"lotnumber", (CharSequence)counRule)) {
                    String lotNumber = filterInfo.getString(counRule);
                    if (!StringUtils.isNotBlank((CharSequence)lotNumber)) continue;
                    qFilter.and("entryentity." + counRule, "=", (Object)lotNumber);
                    continue;
                }
                DynamicObjectCollection ruleDyos = filterInfo.getDynamicObjectCollection(counRule);
                if (!Objects.nonNull(ruleDyos)) continue;
                qFilter.and("entryentity." + counRule, "in", ProblemNoticeRptHelper.getIds(ruleDyos));
            }
        }
        return qFilter;
    }

    public static List<Long> getIds(DynamicObjectCollection dyoCollection) {
        return dyoCollection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public static void showtiPs(BeforeItemClickEvent evt, IFormView formView, int selectRow) {
        if (selectRow == 0) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u5206\u5f55\u884c\uff0c\u518d\u8fdb\u884c\u67e5\u8be2\u3002", (String)"ProblemNoticeRptHelper_0", (String)"qmc-qcqi-business", (Object[])new Object[0]);
            formView.showTipNotification(tips);
            evt.setCancel(true);
        } else if (selectRow > 1) {
            String tips = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u5206\u5f55\u884c\u8fdb\u884c\u67e5\u8be2\uff0c\u4e0d\u80fd\u591a\u9009\u3002", (String)"ProblemNoticeRptHelper_1", (String)"qmc-qcqi-business", (Object[])new Object[0]);
            formView.showTipNotification(tips);
            evt.setCancel(true);
        }
    }

    public static ReportShowParameter showRepeatRpt(DynamicObject dynamicObject, DynamicObject entryRowEntity) {
        long pdWorkShopId;
        long oprWorkShopId;
        long customerId;
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("qcqi_repeatproblemrpt");
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        valueMap.put("isInitQuery", "true");
        valueMap.put("org", dynamicObject.getLong("org.id"));
        valueMap.put("materialid", entryRowEntity.getLong("materialid.id"));
        valueMap.put("unquaproblem", entryRowEntity.getLong("unquaproblem.id"));
        long supplierId = entryRowEntity.getLong("supplierid.id");
        if (supplierId != 0L) {
            valueMap.put("supplierid", supplierId);
        }
        if ((customerId = entryRowEntity.getLong("customerid.id")) != 0L) {
            valueMap.put("customerid", customerId);
        }
        if ((oprWorkShopId = entryRowEntity.getLong("oprworkshop.id")) != 0L) {
            valueMap.put("oprworkshop", oprWorkShopId);
        }
        if ((pdWorkShopId = entryRowEntity.getLong("productionworkshop.id")) != 0L) {
            valueMap.put("productionworkshop", pdWorkShopId);
        }
        valueMap.put("lotnumber", entryRowEntity.getString("lotnumber"));
        reportShowParameter.setCustomParams(valueMap);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return reportShowParameter;
    }
}

