/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.qmc.qcqi.common.enums.ProblemStatusEnum;

public class SendMsgHelper {
    public void sendMessage(DynamicObject[] problemNotice, Set<Long> entryIdSet) {
        String accountId = RequestContext.get().getAccountId();
        for (DynamicObject dynObj : problemNotice) {
            Long pk = dynObj.getLong("id");
            DynamicObjectCollection entryObj = dynObj.getDynamicObjectCollection("entryentity");
            HashSet<Long> receiverSet = new HashSet<Long>();
            for (DynamicObject dyn : entryObj) {
                String problemStatus = dyn.getString("problemstatus");
                Long entryId = dyn.getLong("id");
                if (!ProblemStatusEnum.CLOSED.getValue().equals(problemStatus) || !entryIdSet.contains(entryId)) continue;
                DynamicObject creator = dynObj.getDynamicObject("creator");
                receiverSet.add(creator.getLong("id"));
            }
            ArrayList receivers = new ArrayList(receiverSet);
            if (receivers.isEmpty()) {
                return;
            }
            MessageInfo message = new MessageInfo();
            message.setUserIds(receivers);
            message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            message.setSendTime(KDDateUtils.now());
            message.setType("message");
            message.setEntityNumber("qcqi_problemnotice");
            message.setBizDataId(pk);
            message.setTplScene("qcqi_problemnotice_close");
            String clientUrl = UrlService.getDomainContextUrl();
            String currUrl = clientUrl + "/index.html?formId=qcqi_problemnotice&mb_formId=qcqi_problemnotice_mob&pkId=" + pk + "&accountId=" + accountId;
            message.setContentUrl(currUrl);
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
    }
}

