/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.business.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcqi.common.enums.ProblemStatusEnum;
import kd.qmc.qcqi.common.enums.ProgressStatusEnum;
import kd.qmc.qcqi.common.enums.TopicStatusEnum;

public class UpdateStatusHelper {
    public void setValueByDelete(DynamicObject dynamicObject, String entryentityName) {
        DynamicObject[] problemNotice = this.getDynamicObject(dynamicObject);
        if (problemNotice == null || problemNotice.length == 0) {
            return;
        }
        Set<Long> entryIdSet = this.getEntryId(dynamicObject, entryentityName);
        for (DynamicObject dyn : problemNotice) {
            Long entryId;
            DynamicObjectCollection entryEntity = dyn.getDynamicObjectCollection("entryentity");
            if ("badinfoentry".equals(entryentityName)) {
                for (DynamicObject dynObj : entryEntity) {
                    entryId = dynObj.getLong("id");
                    if (entryIdSet.contains(entryId)) {
                        dynObj.set("progress", null);
                        dynObj.set("rptclosedate", null);
                    }
                    this.setProblemStatus(dynObj);
                }
                continue;
            }
            for (DynamicObject dynObject : entryEntity) {
                entryId = dynObject.getLong("id");
                if (entryIdSet.contains(entryId)) {
                    dynObject.set("topicstatus", null);
                    dynObject.set("infactclosedate", null);
                }
                this.setProblemStatus(dynObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])problemNotice);
    }

    public DynamicObject[] setValueBySave(DynamicObject dynamicObject, String entryEntityName) {
        DynamicObject[] pro = this.getDynamicObject(dynamicObject);
        if (pro == null || pro.length == 0) {
            return null;
        }
        for (DynamicObject dyn : pro) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynObj : entryentity) {
                this.setProblemStatus(dynObj);
            }
        }
        return pro;
    }

    public DynamicObject[] getDynamicObject(DynamicObject dataEntity) {
        Long id;
        DynamicObject[] problemNotice = null;
        String billType = dataEntity.getDynamicObjectType().getName();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{id = Long.valueOf(dataEntity.getLong("id"))});
        if (sourceBills == null || sourceBills.isEmpty()) {
            return null;
        }
        HashSet billIdSet = (HashSet)sourceBills.get("qcqi_problemnotice");
        problemNotice = BusinessDataServiceHelper.load((String)"qcqi_problemnotice", (String)"billno,creator,entryentity.problemstatus,entryentity.progress,entryentity.topicstatus,entryentity.infactclosedate,entryentity.rptclosedate,entryentity.topicclosedate,entryentity.handler", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIdSet)});
        if (problemNotice == null || problemNotice.length == 0) {
            return null;
        }
        return problemNotice;
    }

    public DynamicObject[] setValueByAudit(DynamicObject dynamicObject, String timeName, String closeTimeName, String entryEntityName) {
        DynamicObject[] problemNotice = this.getDynamicObject(dynamicObject);
        if (problemNotice == null || problemNotice.length == 0) {
            return null;
        }
        String name = dynamicObject.getDataEntityType().getName();
        Set<Object> srcEntryIdSet = new HashSet(16);
        if ("qcqi_qcountscore".equals(name)) {
            srcEntryIdSet = this.getSrcEntryIdSet(dynamicObject);
        }
        Set<Long> entryIdSet = this.getEntryId(dynamicObject, entryEntityName);
        for (DynamicObject dyn : problemNotice) {
            Date infactCloseTime = dynamicObject.getDate(timeName);
            String billStatus = dynamicObject.getString("billstatus");
            DynamicObjectCollection entryEntity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynObj : entryEntity) {
                Long entryId = dynObj.getLong("id");
                if ("C".equals(billStatus) && "rptclosedate".equals(closeTimeName)) {
                    if (entryIdSet.contains(entryId)) {
                        dynObj.set("progress", (Object)ProgressStatusEnum.FINISH_ON_TIME.getValue());
                        dynObj.set("rptclosedate", (Object)infactCloseTime);
                    }
                } else if ("C".equals(billStatus) && "topicclosedate".equals(closeTimeName) && srcEntryIdSet.contains(entryId)) {
                    dynObj.set("topicstatus", (Object)TopicStatusEnum.CLOSED.getValue());
                    dynObj.set("topicclosedate", (Object)infactCloseTime);
                }
                this.setProblemStatus(dynObj);
            }
        }
        return problemNotice;
    }

    public DynamicObject setProblemStatus(DynamicObject dynObj) {
        boolean isProcess;
        String problemProgress = dynObj.getString("progress");
        String problemTopicStatus = dynObj.getString("topicstatus");
        boolean bl = isProcess = !(problemTopicStatus != null && !problemTopicStatus.isEmpty() || problemProgress != null && !problemProgress.isEmpty());
        if (isProcess) {
            dynObj.set("problemstatus", (Object)ProblemStatusEnum.NOT_PROCESSED.getValue());
            dynObj.set("infactclosedate", null);
        } else if (problemTopicStatus == null || problemTopicStatus.isEmpty()) {
            if (ProgressStatusEnum.FINISH_ON_TIME.getValue().equals(problemProgress)) {
                dynObj.set("problemstatus", (Object)ProblemStatusEnum.CLOSED.getValue());
                dynObj.set("infactclosedate", (Object)dynObj.getDate("rptclosedate"));
            } else if (ProgressStatusEnum.PROCESSING.getValue().equals(problemProgress) || ProgressStatusEnum.DELAYING.getValue().equals(problemProgress)) {
                dynObj.set("problemstatus", (Object)ProblemStatusEnum.PROCESSING.getValue());
                dynObj.set("infactclosedate", null);
            } else {
                dynObj.set("problemstatus", (Object)ProblemStatusEnum.NOT_PROCESSED.getValue());
                dynObj.set("infactclosedate", null);
            }
        } else if (problemProgress == null || problemProgress.isEmpty()) {
            if (TopicStatusEnum.CLOSED.getValue().equals(problemTopicStatus)) {
                dynObj.set("problemstatus", (Object)ProblemStatusEnum.CLOSED.getValue());
                dynObj.set("infactclosedate", (Object)dynObj.getDate("topicclosedate"));
            } else {
                dynObj.set("problemstatus", (Object)ProblemStatusEnum.PROCESSING.getValue());
                dynObj.set("infactclosedate", null);
            }
        } else if (ProgressStatusEnum.FINISH_ON_TIME.getValue().equals(problemProgress) && TopicStatusEnum.CLOSED.getValue().equals(problemTopicStatus)) {
            dynObj.set("problemstatus", (Object)ProblemStatusEnum.CLOSED.getValue());
            Date rptCloseDte = dynObj.getDate("rptclosedate");
            Date topicCloseDate = dynObj.getDate("topicclosedate");
            if (rptCloseDte != null && topicCloseDate != null) {
                if (rptCloseDte.compareTo(topicCloseDate) > 0) {
                    dynObj.set("infactclosedate", (Object)rptCloseDte);
                } else {
                    dynObj.set("infactclosedate", (Object)topicCloseDate);
                }
            }
        } else if (this.isProblemProcessing(problemProgress, problemTopicStatus)) {
            dynObj.set("problemstatus", (Object)ProblemStatusEnum.PROCESSING.getValue());
            dynObj.set("infactclosedate", null);
        }
        return dynObj;
    }

    private boolean isProblemProcessing(String problemProgress, String problemTopicStatus) {
        boolean isProgressProcessing = (ProgressStatusEnum.PROCESSING.getValue().equals(problemProgress) || ProgressStatusEnum.DELAYING.getValue().equals(problemProgress)) && TopicStatusEnum.CLOSED.getValue().equals(problemTopicStatus);
        boolean isTopicProcessing = ProgressStatusEnum.FINISH_ON_TIME.getValue().equals(problemProgress) && !TopicStatusEnum.CLOSED.getValue().equals(problemTopicStatus);
        return isProgressProcessing || isTopicProcessing;
    }

    public DynamicObject[] setValuesByUnAudit(DynamicObject dynamicObject, String entryEntityName) {
        DynamicObject[] problemNotice = this.getDynamicObject(dynamicObject);
        if (problemNotice == null || problemNotice.length == 0) {
            return null;
        }
        String name = dynamicObject.getDataEntityType().getName();
        Set<Object> srcEntryIdSet = new HashSet(16);
        if ("qcqi_qcountscore".equals(name)) {
            srcEntryIdSet = this.getSrcEntryIdSet(dynamicObject);
        }
        Set<Long> entryIdSet = this.getEntryId(dynamicObject, entryEntityName);
        for (DynamicObject dyn : problemNotice) {
            Long entryId;
            DynamicObjectCollection entryEntity = dyn.getDynamicObjectCollection("entryentity");
            if ("badinfoentry".equals(entryEntityName)) {
                for (DynamicObject dynObj : entryEntity) {
                    entryId = dynObj.getLong("id");
                    if (!entryIdSet.contains(entryId)) continue;
                    dynObj.set("progress", (Object)ProgressStatusEnum.PROCESSING.getValue());
                    dynObj.set("rptclosedate", null);
                    dynObj.set("infactclosedate", null);
                    this.setProblemStatus(dynObj);
                }
                continue;
            }
            for (DynamicObject dynObj : entryEntity) {
                entryId = dynObj.getLong("id");
                if (!srcEntryIdSet.contains(entryId)) continue;
                dynObj.set("topicstatus", (Object)TopicStatusEnum.PUBLISHING.getValue());
                dynObj.set("topicclosedate", null);
                dynObj.set("infactclosedate", null);
                this.setProblemStatus(dynObj);
            }
        }
        return problemNotice;
    }

    public Set<Long> getEntryId(DynamicObject dynamicObject, String entryEntityName) {
        HashSet<Long> entryIdSet = new HashSet<Long>();
        String billName = dynamicObject.getDynamicObjectType().getName();
        if ("qcqi_qcountscore".equals(billName)) {
            entryIdSet.add(dynamicObject.getLong("srcbillentryid"));
        } else {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(entryEntityName);
            for (DynamicObject dynObject : collection) {
                Long entryId = dynObject.getLong("srcbillentryid");
                entryIdSet.add(entryId);
            }
        }
        return entryIdSet;
    }

    public Set<Long> getSrcEntryIdSet(DynamicObject dynamicObject) {
        String billno = dynamicObject.getString("billno");
        DynamicObject qcTopicObj = BusinessDataServiceHelper.loadSingle((String)"qcqi_qctopicmanage", (String)"billno,qcteamentry.srcordernum,qcteamentry.srcbillentryid,qcteamentry.srcbillentity", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        Set<Long> srcEntryIdSet = this.getEntryId(qcTopicObj, "qcteamentry");
        return srcEntryIdSet;
    }
}

