/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.formplugin.botp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.qmc.qcbd.common.util.PurSupplierContacterUtils;
import kd.qmc.qcqi.common.utils.BillNoDealUtil;

public class ProblemNoticeWithSrmBotp
extends AbstractConvertPlugIn {
    private static final String PUR_PROBLEMNOTICE = "pur_problemnotice";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String QCP_BADDEAL = "qcp_baddeal";
    private static final String QCBD_INSOBJ_QCP = "qcbd_insobj_qcp";
    private static final String BOS_ORG = "bos_org";
    private static final String BD_CURRENCY = "bd_currency";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(PUR_PROBLEMNOTICE);
        BillNoDealUtil.dealBillno((ExtendedDataEntity[])entities);
        this.dealReceiptInfo(entities);
        PurSupplierContacterUtils.setSupplierContacter((ExtendedDataEntity[])entities, (String)"contacter", (String)"contacter_id");
    }

    private void dealReceiptInfo(ExtendedDataEntity[] entities) {
        HashSet noticeIds = new HashSet(16);
        Arrays.stream(entities).forEach(bill -> bill.getDataEntity().getDynamicObjectCollection("materialentry").forEach(entry -> noticeIds.add(entry.getLong("srcbillid"))));
        String selectFields = "entryentity.id entryid,entryentity.srcbillid srcbillid,entryentity.srcbillentryid srcbillentryid";
        DynamicObjectCollection noticeDyos = QueryServiceHelper.query((String)"qcqi_problemnotice", (String)selectFields, (QFilter[])new QFilter("id", "in", noticeIds).toArray());
        HashMap<Long, Long> noticeBadDealEntryIdMap = new HashMap<Long, Long>(16);
        noticeBadDealEntryIdMap.putAll(noticeDyos.stream().collect(Collectors.toMap(o -> o.getLong("entryid"), o -> o.getLong("srcbillentryid"))));
        DynamicObjectCollection badDealDyos = QueryServiceHelper.query((String)QCP_BADDEAL, (String)"materialentry.id entryid,materialentry.chkobjentryid chkobjentryid", (QFilter[])new QFilter("id", "in", noticeDyos.stream().map(o -> o.getLong("srcbillid")).collect(Collectors.toSet())).toArray());
        HashMap<Long, Long> badDealInspobjIdMap = new HashMap<Long, Long>(16);
        badDealInspobjIdMap.putAll(badDealDyos.stream().collect(Collectors.toMap(o -> o.getLong("entryid"), o -> o.getLong("chkobjentryid"))));
        QFilter qFilter = new QFilter("entryentity.ass_billentryid", "in", badDealDyos.stream().map(o -> o.getString("entryid")).collect(Collectors.toSet()));
        DynamicObjectCollection inspObjs = QueryServiceHelper.query((String)QCBD_INSOBJ_QCP, (String)"id,srcentitynumber,srcbillid,srcentryid,entryentity.id entryid,entryentity.ass_billentryid ass_billentryid", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> inspobjRecEntryIdMap = new HashMap<Long, Long>(16);
        inspobjRecEntryIdMap.putAll(inspObjs.stream().collect(Collectors.toMap(o -> o.getLong("entryid"), o -> o.getLong("srcentryid"))));
        Map<String, List<DynamicObject>> srcEntityGroup = inspObjs.stream().collect(Collectors.groupingBy(o -> o.getString("srcentitynumber")));
        if (!CollectionUtils.isEmpty(srcEntityGroup)) {
            for (Map.Entry<String, List<DynamicObject>> stringListEntry : srcEntityGroup.entrySet()) {
                Set<Long> srcBillIds = stringListEntry.getValue().stream().map(o -> o.getLong("srcbillid")).collect(Collectors.toSet());
                String srcEntity = stringListEntry.getKey();
                if (StringUtils.equals((CharSequence)IM_PURRECEIVEBILL, (CharSequence)srcEntity)) {
                    Map<Long, DynamicObject> mainIdMyselfMap = ProblemNoticeWithSrmBotp.getRecBillEntryMap(srcBillIds);
                    for (ExtendedDataEntity entity : entities) {
                        DynamicObject dataEntity = entity.getDataEntity();
                        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("materialentry");
                        for (DynamicObject entry : entrys) {
                            Long noticeEntryId = entry.getLong("srcbillentryid");
                            Long badDealEntryId = (Long)noticeBadDealEntryIdMap.get(noticeEntryId);
                            Long inspObjEntryId = (Long)badDealInspobjIdMap.get(badDealEntryId);
                            Long recBillEntryId = (Long)inspobjRecEntryIdMap.get(inspObjEntryId);
                            this.dealDrawValue(mainIdMyselfMap, entry, recBillEntryId);
                        }
                    }
                    continue;
                }
                DynamicObjectCollection srcBillDyos = QueryServiceHelper.query((String)srcEntity, (String)"billentry.id entryid,billentry.srcbillid srcbillid,billentry.srcbillentryid srcbillentryid", (QFilter[])new QFilter("id", "in", srcBillIds).toArray());
                Map<Long, Long> srcAndRecEntryIdsMap = srcBillDyos.stream().collect(Collectors.toMap(o -> o.getLong("entryid"), o -> o.getLong("srcbillentryid")));
                Map sourceBillIds = BFTrackerServiceHelper.findSourceBills((String)srcEntity, (Long[])srcBillIds.toArray(new Long[0]));
                Set<Long> receiveBillIds = new HashSet<Long>();
                String receiveEntity = IM_PURRECEIVEBILL;
                if (sourceBillIds.containsKey(receiveEntity)) {
                    receiveBillIds = (Set)sourceBillIds.get(receiveEntity);
                }
                if (receiveBillIds.isEmpty()) continue;
                Map<Long, DynamicObject> mainIdMyselfMap = ProblemNoticeWithSrmBotp.getRecBillEntryMap(receiveBillIds);
                for (ExtendedDataEntity entity : entities) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entry : entrys) {
                        Long noticeEntryId = entry.getLong("srcbillentryid");
                        Long badDealEntryId = (Long)noticeBadDealEntryIdMap.get(noticeEntryId);
                        Long inspObjEntryId = (Long)badDealInspobjIdMap.get(badDealEntryId);
                        Long srcBillEntryId = (Long)inspobjRecEntryIdMap.get(inspObjEntryId);
                        Long recBillEntryId = srcAndRecEntryIdsMap.get(srcBillEntryId);
                        this.dealDrawValue(mainIdMyselfMap, entry, recBillEntryId);
                    }
                }
            }
        }
    }

    private void dealDrawValue(Map<Long, DynamicObject> mainIdMyselfMap, DynamicObject entry, Long recBillEntryId) {
        DynamicObject recriveBill;
        if (Objects.nonNull(recBillEntryId) && recBillEntryId > 0L && Objects.nonNull(recriveBill = mainIdMyselfMap.get(recBillEntryId))) {
            entry.set("receiptbillno", recriveBill.get("billno"));
            entry.set("receiptbillid", recriveBill.get("id"));
            entry.set("entryrcvorg", this.getDynamicObjectById(BOS_ORG, recriveBill.getLong("org")));
            entry.set("entrysettleorg", this.getDynamicObjectById(BOS_ORG, recriveBill.getLong("entrysettleorg")));
            entry.set("curr", this.getDynamicObjectById(BD_CURRENCY, recriveBill.getLong("settlecurrency")));
        }
    }

    private static Map<Long, DynamicObject> getRecBillEntryMap(Set<Long> receiveBillIds) {
        String selectFields = "id,billno,org,settlecurrency,billentry.id entryid,billentry.entrysettleorg entrysettleorg";
        Map<Long, DynamicObject> mainIdMyselfMap = QueryServiceHelper.query((String)IM_PURRECEIVEBILL, (String)selectFields, (QFilter[])new QFilter("id", "in", receiveBillIds).toArray()).stream().collect(Collectors.toMap(o1 -> o1.getLong("entryid"), o2 -> o2));
        return mainIdMyselfMap;
    }

    private Object getDynamicObjectById(String bos_org, long orgId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)bos_org);
    }
}

