/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.formplugin.problemnotice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import java.util.OptionalInt;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcqi.business.helper.ProblemNoticeRptHelper;

public class ProblemNoticeBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener,
CellClickListener {
    public void initialize() {
        super.initialize();
        EntryGrid matEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (matEntryGrid != null) {
            matEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"deleteentry"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addF7Listener("materialcfgid", "measureunitid", "unquaproblem", "supplierid", "customerid", "productionworkshop", "seriouslevelscheme", "createdepart");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (!entrys.isEmpty()) {
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject materialInfo = (DynamicObject)((DynamicObject)entrys.get(i)).get("materialid");
                LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)materialInfo, (int)i, (Boolean)Boolean.FALSE);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        long billTyie = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"billtype").getLong("id");
        if (1449229810269209600L == billTyie) {
            DynamicObjectCollection entrys = model.getEntryEntity("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject supplier = ((DynamicObject)entrys.get(i)).getDynamicObject("supplierid");
                if (!Objects.nonNull(supplier) || !supplier.getBoolean("issuppcolla")) continue;
                model.setValue("feedbackstatus", (Object)"A", i);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("repeatproblem".equals(evt.getItemKey())) {
            boolean exists = QueryServiceHelper.exists((String)"qcqi_problemnotice", (Object)model.getDataEntity().getPkValue());
            if (!exists) {
                String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u67e5\u8be2\uff0c\u8bf7\u4fdd\u5b58\u5355\u636e\u540e\u518d\u67e5\u8be2\u3002", (String)"ProblemNoticeBillPlugin_0", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                evt.setCancel(true);
                return;
            }
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int selectRow = grid.getSelectRows().length;
            ProblemNoticeRptHelper.showtiPs((BeforeItemClickEvent)evt, (IFormView)view, (int)selectRow);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("repeatproblem".equals(evt.getItemKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            ReportShowParameter reportShowParameter = ProblemNoticeRptHelper.showRepeatRpt((DynamicObject)dataEntity, (DynamicObject)entryRowEntity);
            this.getView().showForm((FormShowParameter)reportShowParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "measureunitid": {
                IFormView view = this.getView();
                DynamicObject mat = (DynamicObject)this.getModel().getValue("materialid");
                ControlUtil.unitCheck((BeforeF7SelectEvent)e, (IFormView)view, (DynamicObject)mat);
                break;
            }
            case "materialcfgid": 
            case "unquaproblem": {
                Object value = this.getModel().getValue("billtype");
                if (value != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"ProblemNoticeBillPlugin_1", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "createdepart": {
                ArrayList<Long> orgIds = new ArrayList<Long>(1);
                orgIds.add(DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org")));
                CommonViewControlHelper.beforeRelationOrgF7((BeforeF7SelectEvent)e, orgIds);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String fieldName = e.getProperty().getName();
        block20: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            int parentRowIndex = changeData.getParentRowIndex();
            switch (fieldName) {
                case "materialid": {
                    DynamicObject material = (DynamicObject)newValue;
                    LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)material, (int)rowIndex, (Boolean)Boolean.TRUE);
                    continue block20;
                }
                case "lotnumber": {
                    DynamicObject materialDyo = (DynamicObject)model.getValue("materialid", rowIndex);
                    String lotNumber = (String)model.getValue("lotnumber", rowIndex);
                    if (materialDyo != null || "".equals(lotNumber)) continue block20;
                    model.setValue("lotnumber", (Object)"", rowIndex);
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\uff0c\u518d\u8f93\u5165\u6279\u53f7\u3002", (String)"ProblemNoticeBillPlugin_7", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                    continue block20;
                }
                case "seriousscore": {
                    BigDecimal seriousScore = (BigDecimal)newValue;
                    DynamicObject seriousLevelScheme = (DynamicObject)model.getValue("seriouslevelscheme", parentRowIndex);
                    if (seriousScore.compareTo(seriousLevelScheme.getBigDecimal("seriousmax")) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6570\u636e\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u4e25\u91cd\u7a0b\u5ea6\u8bc4\u4f30\u65b9\u6848\u201d\u4e2d\u201c\u4e25\u91cd\u6027\u6700\u5927\u503c\u201d\u3002", (String)"ProblemNoticeBillPlugin_3", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                        this.clearSubValue("seriousscore");
                    }
                    this.countSeriousLevelScore(parentRowIndex);
                    continue block20;
                }
                case "happenratescore": {
                    BigDecimal happenRateScore = (BigDecimal)newValue;
                    DynamicObject seriousLevelScheme = (DynamicObject)model.getValue("seriouslevelscheme", parentRowIndex);
                    BigDecimal happenrateMax = seriousLevelScheme.getBigDecimal("happenratemax");
                    if (happenRateScore.compareTo(happenrateMax) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6570\u636e\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u4e25\u91cd\u7a0b\u5ea6\u8bc4\u4f30\u65b9\u6848\u201d\u4e2d\u7684\u201c\u53d1\u751f\u9891\u7387\u6700\u5927\u503c\u201d\u3002", (String)"ProblemNoticeBillPlugin_4", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                        this.clearSubValue("happenratescore");
                    }
                    this.countSeriousLevelScore(parentRowIndex);
                    continue block20;
                }
                case "searchdeepscore": {
                    BigDecimal searchDeepScore = (BigDecimal)newValue;
                    DynamicObject seriousLevelScheme = (DynamicObject)model.getValue("seriouslevelscheme", parentRowIndex);
                    BigDecimal searchDeepMax = seriousLevelScheme.getBigDecimal("searchdeepmax");
                    if (searchDeepScore.compareTo(searchDeepMax) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6570\u636e\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u4e25\u91cd\u7a0b\u5ea6\u8bc4\u4f30\u65b9\u6848\u201d\u4e2d\u201c\u63a2\u6d4b\u5ea6\u6700\u5927\u503c\u201d\u3002", (String)"ProblemNoticeBillPlugin_5", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                        this.clearSubValue("searchdeepscore");
                    }
                    this.countSeriousLevelScore(parentRowIndex);
                    continue block20;
                }
                case "seriouslevelscore": {
                    BigDecimal seriousLevelScore = (BigDecimal)newValue;
                    DynamicObject seriousLevelScheme = (DynamicObject)model.getValue("seriouslevelscheme", parentRowIndex);
                    this.setValueBySeriousLevelScore(seriousLevelScheme, seriousLevelScore, parentRowIndex);
                    continue block20;
                }
                case "seriouslevelscheme": {
                    this.seriousSchemeChange(changeData);
                    continue block20;
                }
                case "supplierid": {
                    this.supplierChanged((DynamicObject)newValue, rowIndex);
                    continue block20;
                }
            }
        }
    }

    private void seriousSchemeChange(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int subEntryRowCount = this.getModel().getEntryRowCount("subentryentity");
        if (Objects.isNull(oldValue) && Objects.nonNull(newValue)) {
            this.getModel().createNewEntryRow("subentryentity");
        } else if (Objects.isNull(newValue) && Objects.nonNull(oldValue) && subEntryRowCount != 0) {
            this.getModel().deleteEntryRow("subentryentity", 0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int rowCount = this.getModel().getEntryEntity("entryentity").getRowCount();
        int[] selectRow = grid.getSelectRows();
        if ("previousentry".equals(opKey)) {
            if (selectRow.length == 0) {
                return;
            }
            OptionalInt min = Arrays.stream(selectRow).min();
            if (0 == min.getAsInt()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7b2c\u4e00\u884c\u3002", (String)"ProblemNoticeBillPlugin_8", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
            }
        }
        if ("nextentry".equals(opKey)) {
            if (selectRow.length == 0) {
                return;
            }
            OptionalInt max = Arrays.stream(selectRow).max();
            if (rowCount - 1 == max.getAsInt()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u6700\u540e\u4e00\u884c\u3002", (String)"ProblemNoticeBillPlugin_9", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void addF7Listener(String ... baseData) {
        for (String str : baseData) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (f7Control == null) continue;
            f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void clearSubValue(String fieldName) {
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subDynObject = (DynamicObject)subEntryEntity.get(0);
        this.getModel().beginInit();
        subDynObject.set(fieldName, (Object)0);
        subDynObject.set("seriouslevelscore", (Object)0);
        subDynObject.set("seriouslevel", null);
        subDynObject.set("improveway", null);
        this.getModel().endInit();
        this.getModel().updateEntryCache(subEntryEntity);
        this.getView().updateView(fieldName, 0);
        this.getView().updateView("seriouslevelscore", 0);
        this.getView().updateView("seriouslevel", 0);
        this.getView().updateView("improveway", 0);
    }

    private DynamicObjectCollection getSubEntry(int parentRowIndex) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("entryentity");
        DynamicObject parentRowObj = (DynamicObject)parentRowObjs.get(parentRowIndex);
        return parentRowObj.getDynamicObjectCollection("subentryentity");
    }

    private void countSeriousLevelScore(int parentRowIndex) {
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subDynObject = (DynamicObject)subEntryEntity.get(0);
        BigDecimal seriousScore = subDynObject.getBigDecimal("seriousscore");
        BigDecimal happenRateScore = subDynObject.getBigDecimal("happenratescore");
        BigDecimal searchDeepScore = subDynObject.getBigDecimal("searchdeepscore");
        int condition1 = seriousScore.compareTo(BigDecimal.ZERO);
        int condition2 = happenRateScore.compareTo(BigDecimal.ZERO);
        int condition3 = searchDeepScore.compareTo(BigDecimal.ZERO);
        if (condition1 != 0 && condition2 != 0 && condition3 != 0) {
            BigDecimal seriousLevelScore = seriousScore.multiply(happenRateScore);
            seriousLevelScore = seriousLevelScore.multiply(searchDeepScore);
            this.getModel().setValue("seriouslevelscore", (Object)seriousLevelScore, 0, parentRowIndex);
        }
    }

    private void setValueBySeriousLevelScore(DynamicObject seriousLevelScheme, BigDecimal newValue, int matRowIndex) {
        DynamicObject seriousLevel = null;
        DynamicObject improveWay = null;
        DynamicObjectCollection eavSchemeEntry = seriousLevelScheme.getDynamicObjectCollection("eavschemeentry");
        for (DynamicObject dynObj : eavSchemeEntry) {
            BigDecimal levelStart = dynObj.getBigDecimal("levelstart");
            BigDecimal levelEnd = dynObj.getBigDecimal("levelend");
            if (newValue.compareTo(levelStart) <= 0 || newValue.compareTo(levelEnd) > 0) continue;
            seriousLevel = dynObj.getDynamicObject("seriouslevel_s");
            improveWay = dynObj.getDynamicObject("improveway");
        }
        DynamicObjectCollection subEntry = this.getSubEntry(matRowIndex);
        DynamicObject subDynObject = (DynamicObject)subEntry.get(0);
        subDynObject.set("seriouslevel", seriousLevel);
        subDynObject.set("improveway", improveWay);
        this.getView().updateView("seriouslevel", 0);
        this.getView().updateView("improveway", 0);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        LotNumberHelper.lotnumberEntryGridBind((IDataModel)this.getModel(), (IFormView)this.getView(), (EntryGridBindDataEvent)e, (String)"entryentity", (String)"materialid");
    }

    public void cellClick(CellClickEvent evt) {
        Object value;
        if (StringQMCUtil.inside((String)evt.getFieldKey(), (String[])new String[]{"materialqty", "details"}).booleanValue() && (value = this.getModel().getValue("billtype")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"ProblemNoticeBillPlugin_1", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        Object value = this.getModel().getValue("seriouslevelscheme", row);
        int subEntryRowCount = this.getModel().getEntryRowCount("subentryentity");
        if (Objects.nonNull(value) && subEntryRowCount != 1) {
            this.getModel().createNewEntryRow("subentryentity");
        }
    }

    private void supplierChanged(DynamicObject newValue, int rowIndex) {
        IDataModel model = this.getModel();
        long billTyie = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"billtype").getLong("id");
        DynamicObject supplier = newValue;
        if (1449229810269209600L == billTyie && Objects.nonNull(supplier) && supplier.getBoolean("issuppcolla")) {
            model.setValue("feedbackstatus", (Object)"A", rowIndex);
        } else {
            model.setValue("feedbackstatus", null, rowIndex);
        }
    }
}

