/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.formplugin.qcactivity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;

public class QcActManageListPlugin
extends AbstractListPlugin {
    public void packageData(PackageDataEvent e) {
        String fieldKey;
        super.packageData(e);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        switch (fieldKey = columnDesc.getFieldKey()) {
            case "activityprog": {
                this.setActiviStatus(e);
                break;
            }
        }
    }

    private void setActiviStatus(PackageDataEvent e) {
        String status = e.getRowData().getString("billstatus");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if ("C".equals(status)) {
            Date activityactual = e.getRowData().getDate("activityactual");
            Date activitycomp = e.getRowData().getDate("activitycomp");
            if (activityactual == null || activitycomp == null) {
                return;
            }
            String activityactualString = formatter.format(activityactual);
            String activitycompString = formatter.format(activitycomp);
            if (QcActManageListPlugin.timeCompare(activitycompString, activityactualString) >= 0) {
                e.setFormatValue((Object)"D");
            } else {
                e.setFormatValue((Object)"C");
            }
        } else {
            Date activitycomp = e.getRowData().getDate("activitycomp");
            if (activitycomp == null) {
                return;
            }
            String activitycompString = formatter.format(activitycomp);
            if (QcActManageListPlugin.timeCompare(QcActManageListPlugin.getCurrentTime(), activitycompString) > 0) {
                e.setFormatValue((Object)"B");
            } else {
                e.setFormatValue((Object)"A");
            }
        }
    }

    public static int timeCompare(String t1, String t2) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(formatter.parse(t1));
            c2.setTime(formatter.parse(t2));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        int result = c1.compareTo(c2);
        return result;
    }

    public static String getCurrentTime() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        return dateString;
    }
}

