/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.formplugin.qcactivity;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.qmc.qcqi.formplugin.qcactivity.ReviewAdminCommon;

public class QcOnlineScoreFormPlugin
extends AbstractBillPlugIn {
    public static final String REVIEW_STANDARD = "reviewstandard";
    public static final String STANDARD_ENTRY = "standardentry";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject reviewstandard = (DynamicObject)model.getValue(REVIEW_STANDARD);
        DynamicObjectCollection standardentry = model.getEntryEntity(STANDARD_ENTRY);
        if ((standardentry == null || standardentry.isEmpty()) && reviewstandard != null) {
            model.getEntryEntity(STANDARD_ENTRY).clear();
            DynamicObjectCollection entryentity = reviewstandard.getDynamicObjectCollection("entryentity");
            int j = 0;
            for (DynamicObject data : entryentity) {
                DynamicObject d = new DynamicObject(model.getEntryEntity(STANDARD_ENTRY).getDynamicObjectType());
                d.set("reviewtype", data.get("reviewtype"));
                d.set("standardvalue", data.get("standardvalue"));
                d.set("reviewmethed", data.get("reviewmethed"));
                d.set("seq", (Object)j);
                ++j;
                model.createNewEntryRow(STANDARD_ENTRY, d);
            }
            model.updateEntryCache(model.getEntryEntity(STANDARD_ENTRY));
            this.getView().updateView(STANDARD_ENTRY);
        }
        String scoreava = (String)model.getValue("scoreava");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = (DynamicObject)model.getValue("reviewuserid");
        if (user == null) {
            return;
        }
        Long reviewuserid = (Long)user.getPkValue();
        if ("B".equals(scoreava) || !userId.equals(reviewuserid)) {
            this.getView().invokeOperation("view");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("trackup".equals(operateKey)) {
            DynamicObject reviewcommit = (DynamicObject)model.getValue("reviewcommit");
            boolean isReviewAdmin = ReviewAdminCommon.isReviewAdmin(reviewcommit);
            if (isReviewAdmin) {
                return;
            }
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"qcqi_qconlinescore", (Long[])new Long[]{(Long)model.getValue("id")});
            String qcountStatus = "";
            if (sourceBills == null || sourceBills.get("qcqi_qcountscore") == null) {
                return;
            }
            Iterator it = ((HashSet)sourceBills.get("qcqi_qcountscore")).iterator();
            if (it.hasNext()) {
                DynamicObject applyitem = BusinessDataServiceHelper.loadSingle(it.next(), (String)"qcqi_qcountscore");
                qcountStatus = applyitem.getString("billstatus");
            }
            if (!"C".equals(qcountStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"QC\u8bc4\u5ba1\u62a5\u544a\u6682\u5b58\u548c\u5df2\u63d0\u4ea4\u72b6\u6001\u4e0b\uff0c\u53ea\u6709\u8bc4\u5ba1\u59d4\u5458\u4f1a\u7ba1\u7406\u5458\u53ef\u67e5\u770b\u548c\u64cd\u4f5c\uff0c\u5355\u636e\u5ba1\u6838\u901a\u8fc7\u540e\u65b9\u53ef\u67e5\u770b\u3002", (String)"QcOnlineScoreFormPlugin_0", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if ("openqcact".equals(operateKey)) {
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"qcqi_qconlinescore", (Long[])new Long[]{(Long)model.getValue("id")});
            if (sourceBills == null || sourceBills.get("qcqi_qcactpromanage") == null) {
                return;
            }
            BillShowParameter bs = new BillShowParameter();
            bs.setPkId(((HashSet)sourceBills.get("qcqi_qcactpromanage")).iterator().next());
            bs.setFormId("qcqi_qcactpromanage");
            bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bs.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)bs);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        if (e.getSource() instanceof DecimalEdit && e.getValue() != null) {
            DecimalEdit decimalEdit = (DecimalEdit)e.getSource();
            String propName = decimalEdit.getKey();
            Object newValue = e.getValue();
            int changeRowIndex = e.getRowIndex();
            switch (propName) {
                case "reviewcount": {
                    if (Double.parseDouble(newValue.toString()) != 0.0) break;
                    DynamicObject scorescheme = (DynamicObject)this.getModel().getValue("scorescheme");
                    if (scorescheme == null || scorescheme.getDynamicObjectCollection("entryentity") == null) {
                        return;
                    }
                    DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
                    this.getModel().setValue("scoregrade", (Object)((DynamicObject)entryentity.get(0)).getDynamicObject("scoregrade"));
                    break;
                }
                case "reviewscore": {
                    if (Double.parseDouble(newValue.toString()) != 0.0) break;
                    this.reviewScoreChange(BigDecimal.ZERO, changeRowIndex);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet;
        String propName = e.getProperty().getName();
        block8: for (ChangeData changeData : valueSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            int changeRowIndex = changeData.getRowIndex();
            if (newValue == null) {
                return;
            }
            switch (propName) {
                case "reviewscore": {
                    this.reviewScoreChange(newValue, changeRowIndex);
                    continue block8;
                }
                case "reviewcount": {
                    this.reviewCountChange(newValue);
                    continue block8;
                }
            }
        }
    }

    private void reviewCountChange(Object newValue) {
        IDataModel model = this.getModel();
        if ("false".equals(this.getPageCache().get("reviewScoreChange"))) {
            model.beginInit();
            DynamicObjectCollection standardentry = model.getEntryEntity(STANDARD_ENTRY);
            for (DynamicObject data : standardentry) {
                data.set("reviewscore", (Object)BigDecimal.ZERO);
            }
            model.updateCache();
            model.endInit();
            this.getView().updateView(STANDARD_ENTRY);
        }
        this.getPageCache().put("reviewScoreChange", "false");
        BigDecimal reviewcount = (BigDecimal)newValue;
        DynamicObject scorescheme = (DynamicObject)model.getValue("scorescheme");
        this.getScoreGrade(reviewcount, scorescheme);
    }

    private void reviewScoreChange(Object newValue, int changeRowIndex) {
        BigDecimal review = (BigDecimal)newValue;
        IDataModel model = this.getModel();
        int standard = (Integer)model.getValue("standardvalue", changeRowIndex);
        if (review.compareTo(BigDecimal.valueOf(standard)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8bc4\u5206\u201d\u5e94\u5c0f\u4e8e\u201c\u6807\u51c6\u5206\u503c\u201d\u3002", (String)"QcOnlineScoreFormPlugin_1", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal reviewcount = BigDecimal.ZERO;
        DynamicObjectCollection standardentry = model.getEntryEntity(STANDARD_ENTRY);
        for (DynamicObject data : standardentry) {
            reviewcount = reviewcount.add(data.getBigDecimal("reviewscore"));
        }
        DynamicObject scorescheme = (DynamicObject)model.getValue("scorescheme");
        this.getScoreGrade(reviewcount, scorescheme);
        this.getPageCache().put("reviewScoreChange", "true");
        model.setValue("reviewcount", (Object)reviewcount);
        model.updateCache();
        this.getView().updateView("reviewcount");
        this.getView().updateView("scoregrade");
    }

    private void getScoreGrade(BigDecimal reviewcount, DynamicObject scorescheme) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject data : entryentity) {
            if (reviewcount.compareTo(data.getBigDecimal("startvalue")) < 0 || reviewcount.compareTo(data.getBigDecimal("endvalue")) > 0) continue;
            model.setValue("scoregrade", (Object)data.getDynamicObject("scoregrade"));
            break;
        }
    }
}

