/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqi.formplugin.qcactivity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcqi.formplugin.qcactivity.ReviewAdminCommon;

public class QcountScoreFormPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject event) {
        super.registerListener(event);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        if (e.getSource() instanceof DecimalEdit && e.getValue() != null) {
            DecimalEdit decimalEdit = (DecimalEdit)e.getSource();
            String propName = decimalEdit.getKey();
            Object newValue = e.getValue();
            int changeRowIndex = e.getRowIndex();
            switch (propName) {
                case "revcount": {
                    this.revCountZeroChange(newValue, changeRowIndex);
                    break;
                }
                case "reviewscore": {
                    if (Double.parseDouble(newValue.toString()) != 0.0) break;
                    this.reviewScoreChange(BigDecimal.ZERO, changeRowIndex);
                    break;
                }
            }
        }
    }

    private void revCountZeroChange(Object newValue, int changeRowIndex) {
        if (Double.parseDouble(newValue.toString()) == 0.0) {
            DynamicObject scorescheme = (DynamicObject)this.getModel().getValue("scorescheme");
            if (scorescheme == null || scorescheme.getDynamicObjectCollection("entryentity") == null) {
                return;
            }
            DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
            this.getModel().setValue("pscoregrade", (Object)((DynamicObject)entryentity.get(0)).getDynamicObject("scoregrade"));
            this.revCountChange(BigDecimal.ZERO, changeRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        Object newValue = changeData.getNewValue();
        int changeRowIndex = changeData.getRowIndex();
        if (newValue == null) {
            return;
        }
        switch (propName) {
            case "reviewscore": {
                this.reviewScoreChange(newValue, changeRowIndex);
                break;
            }
            case "revcount": {
                this.revCountChange(newValue, changeRowIndex);
                break;
            }
            case "scoreava": {
                this.scoreAvaChange(changeRowIndex, newValue, true);
                break;
            }
        }
    }

    private void revCountChange(Object newValue, int changeRowIndex) {
        IDataModel model = this.getModel();
        if ("false".equals(this.getPageCache().get("reviewScoreChange"))) {
            model.beginInit();
            DynamicObjectCollection subentryentity = model.getEntryEntity("subentryentity");
            for (DynamicObject data : subentryentity) {
                data.set("reviewscore", (Object)BigDecimal.ZERO);
            }
            this.getView().updateView("subentryentity");
            model.endInit();
            model.updateCache();
        }
        this.getPageCache().put("reviewScoreChange", "false");
        this.scoreAvaChange(changeRowIndex, newValue, false);
    }

    private void scoreAvaChange(int changeRowIndex, Object newValue, Boolean avaChange) {
        IDataModel model = this.getModel();
        BigDecimal reviewcount = BigDecimal.ZERO;
        BigDecimal revcount = BigDecimal.ZERO;
        if (newValue instanceof BigDecimal) {
            revcount = (BigDecimal)newValue;
        } else if (newValue instanceof String) {
            revcount = (BigDecimal)model.getValue("revcount", changeRowIndex);
        }
        DynamicObjectCollection reviewentry = model.getEntryEntity("reviewentry");
        BigDecimal scoreavaInt = BigDecimal.ZERO;
        for (DynamicObject data : reviewentry) {
            if (!"A".equals(data.getString("scoreava"))) continue;
            reviewcount = reviewcount.add(data.getBigDecimal("revcount"));
            scoreavaInt = scoreavaInt.add(BigDecimal.ONE);
        }
        this.setRevcount(model, revcount, avaChange);
        this.setScoreGrade(model, reviewcount, scoreavaInt, avaChange);
    }

    private void reviewScoreChange(Object newValue, int changeRowIndex) {
        BigDecimal review = (BigDecimal)newValue;
        IDataModel model = this.getModel();
        int standard = (Integer)model.getValue("standardvalue", changeRowIndex);
        if (review.compareTo(BigDecimal.valueOf(standard)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8bc4\u5206\u201d\u5e94\u5c0f\u4e8e\u201c\u6807\u51c6\u5206\u503c\u201d\u3002", (String)"QcountScoreFormPlugin_0", (String)"qmc-qcqi-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal countscore = BigDecimal.ZERO;
        BigDecimal reviewcount = BigDecimal.ZERO;
        DynamicObjectCollection subentryentity = model.getEntryEntity("subentryentity");
        for (DynamicObject data : subentryentity) {
            countscore = countscore.add(data.getBigDecimal("reviewscore"));
        }
        this.getPageCache().put("reviewScoreChange", "true");
        model.setValue("revcount", (Object)countscore, model.getEntryCurrentRowIndex("reviewentry"));
        this.getView().updateView("revcount", model.getEntryCurrentRowIndex("reviewentry"));
        model.updateCache();
        DynamicObjectCollection reviewentry = model.getEntryEntity("reviewentry");
        BigDecimal scoreavaInt = BigDecimal.ZERO;
        for (DynamicObject data : reviewentry) {
            if (!"A".equals(data.getString("scoreava"))) continue;
            reviewcount = reviewcount.add(data.getBigDecimal("revcount"));
            scoreavaInt = scoreavaInt.add(BigDecimal.ONE);
        }
        this.setRevcount(model, countscore, false);
        this.setScoreGrade(model, reviewcount, scoreavaInt, false);
    }

    private void setRevcount(IDataModel model, BigDecimal revcount, Boolean avaChange) {
        if (avaChange.booleanValue()) {
            return;
        }
        DynamicObject scorescheme = (DynamicObject)model.getValue("scorescheme");
        DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject data : entryentity) {
            if (revcount.compareTo(data.getBigDecimal("startvalue")) < 0 || revcount.compareTo(data.getBigDecimal("endvalue")) > 0) continue;
            model.setValue("pscoregrade", (Object)data.getDynamicObject("scoregrade"));
            break;
        }
    }

    private void setScoreGrade(IDataModel model, BigDecimal reviewcount, BigDecimal scoreavaInt, Boolean avaChange) {
        if (avaChange.booleanValue() && Double.parseDouble(reviewcount.toString()) == 0.0) {
            model.setValue("reviewcount", (Object)reviewcount);
            DynamicObject scorescheme = (DynamicObject)this.getModel().getValue("scorescheme");
            if (scorescheme == null || scorescheme.getDynamicObjectCollection("entryentity") == null) {
                return;
            }
            DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
            this.getModel().setValue("scoregrade", (Object)((DynamicObject)entryentity.get(0)).getDynamicObject("scoregrade"));
            return;
        }
        DynamicObject scorescheme = (DynamicObject)model.getValue("scorescheme");
        DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
        BigDecimal avgreview = reviewcount.divide(scoreavaInt.equals(BigDecimal.ZERO) ? BigDecimal.ONE : scoreavaInt, 2, RoundingMode.HALF_DOWN);
        if (avgreview.equals(BigDecimal.ZERO)) {
            model.setValue("scoregrade", null);
        } else {
            for (DynamicObject data : entryentity) {
                if (avgreview.compareTo(data.getBigDecimal("startvalue")) < 0 || avgreview.compareTo(data.getBigDecimal("endvalue")) > 0) continue;
                model.setValue("scoregrade", (Object)data.getDynamicObject("scoregrade"));
                break;
            }
        }
        model.setValue("reviewcount", (Object)avgreview);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection reviewentry;
        String scoretype;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject reviewcommit = (DynamicObject)model.getValue("reviewcommit");
        boolean isReviewAdmin = ReviewAdminCommon.isReviewAdmin(reviewcommit);
        if (!isReviewAdmin) {
            view.setEnable(Boolean.valueOf(false), new String[]{"bar_modify"});
        }
        DynamicObject reviewstandard = (DynamicObject)model.getValue("reviewstandard");
        DynamicObjectCollection subentryentity = model.getEntryEntity("subentryentity");
        if ((subentryentity == null || subentryentity.isEmpty()) && reviewstandard != null) {
            DynamicObjectCollection reviewentry2 = model.getEntryEntity("reviewentry");
            if (reviewentry2 == null || reviewentry2.isEmpty()) {
                return;
            }
            this.setReviewEntry(reviewstandard, reviewentry2, model, view);
        }
        if ("B".equals(scoretype = (String)model.getValue("scoretype"))) {
            this.setReviewCount();
        }
        if (this.isDrawNow(this.getModel().getDataEntity(), "reviewentry")) {
            model.setValue("scoregrade", null);
            this.getView().invokeOperation("save");
            this.getView().invokeOperation("refresh");
            if ("B".equals(scoretype)) {
                this.getView().invokeOperation("pushandsave");
            }
        }
        if (!(reviewentry = model.getEntryEntity("reviewentry")).isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("reviewentry");
            entryGrid.selectRows(0);
        }
    }

    private void setReviewCount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection reviewentry = model.getEntryEntity("reviewentry");
        BigDecimal scoreavaInt = BigDecimal.ZERO;
        BigDecimal reviewcount = BigDecimal.ZERO;
        for (DynamicObject data : reviewentry) {
            if (!"A".equals(data.getString("scoreava"))) continue;
            reviewcount = reviewcount.add(data.getBigDecimal("revcount"));
            scoreavaInt = scoreavaInt.add(BigDecimal.ONE);
        }
        BigDecimal avgreview = reviewcount.divide(scoreavaInt.equals(BigDecimal.ZERO) ? BigDecimal.ONE : scoreavaInt, 2, RoundingMode.HALF_DOWN);
        if (avgreview.equals(BigDecimal.ZERO)) {
            model.setValue("scoregrade", null);
        } else {
            DynamicObject scorescheme = (DynamicObject)model.getValue("scorescheme");
            DynamicObjectCollection entryentity = scorescheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject data : entryentity) {
                if (avgreview.compareTo(data.getBigDecimal("startvalue")) <= 0 || avgreview.compareTo(data.getBigDecimal("endvalue")) > 0) continue;
                model.setValue("scoregrade", (Object)data.getDynamicObject("scoregrade"));
                break;
            }
        }
        model.setValue("reviewcount", (Object)avgreview);
        model.updateEntryCache(model.getEntryEntity("reviewentry"));
        this.getView().updateView("reviewentry");
    }

    public void setReviewEntry(DynamicObject reviewstandard, DynamicObjectCollection reviewentry, IDataModel model, IFormView view) {
        model.getEntryEntity("subentryentity").clear();
        DynamicObjectCollection entryentity = reviewstandard.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < reviewentry.size(); ++i) {
            int j = 0;
            for (DynamicObject data : entryentity) {
                DynamicObject entry = (DynamicObject)reviewentry.get(i);
                DynamicObjectCollection subentry = entry.getDynamicObjectCollection("subentryentity");
                DynamicObject d = new DynamicObject(model.getEntryEntity("subentryentity").getDynamicObjectType());
                d.set("reviewtype", data.get("reviewtype"));
                d.set("standardvalue", data.get("standardvalue"));
                d.set("reviewitem", data.get("reviewitem"));
                d.set("reviewmethed", data.get("reviewmethed"));
                d.set("streviewstandard", data.get("reviewstandard"));
                d.set("seq", (Object)j);
                ++j;
                subentry.add((Object)d);
            }
        }
        model.updateEntryCache(model.getEntryEntity("subentryentity"));
        view.updateView("subentryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject[] applyitem;
            DynamicObjectCollection reviewentry = this.getModel().getEntryEntity("reviewentry");
            Map sourceBills = BFTrackerServiceHelper.findTargetBills((String)"qcqi_qcountscore", (Long[])new Long[]{(Long)this.getModel().getValue("id")});
            for (DynamicObject data : applyitem = BusinessDataServiceHelper.load((String)"qcqi_qconlinescore", (String)"id,srcbillentryid,scoreava", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBills.get("qcqi_qconlinescore"))})) {
                Long srcbillentryid = data.getLong("srcbillentryid");
                for (DynamicObject review : reviewentry) {
                    if (srcbillentryid.longValue() != review.getLong("id")) continue;
                    data.set("scoreava", review.get("scoreava"));
                }
            }
            SaveServiceHelper.update((DynamicObject[])applyitem);
        }
    }

    private boolean isDrawNow(DynamicObject billData, String entrykey) {
        DynamicObjectCollection entrys = billData.getDynamicObjectCollection(entrykey);
        boolean isFromDB = billData.getDataEntityState().getFromDatabase();
        boolean isDraw = entrys.stream().anyMatch(x -> 0L != x.getLong("resrcbillid"));
        return !isFromDB && isDraw;
    }
}

