/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.business.rpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcqs.business.inter.IInsRptCommonInter;
import kd.qmc.qcqs.common.chart.ChartFastData;
import kd.qmc.qcqs.common.chart.ChartSelect;
import kd.qmc.qcqs.common.chart.ChartTool;
import kd.qmc.qcqs.common.chart.ChartUtil;
import kd.qmc.qcqs.common.util.ManuBadAnalysisDimEnum;

public abstract class InsBadDealRptCommonPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
IInsRptCommonInter {
    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeData;
        Object newValue;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length && ChartUtil.valueCheck((Object)(newValue = (changeData = changeSet[i]).getNewValue()), (Object)(oldValue = changeData.getOldValue())); ++i) {
            if ("matgrp".equals(fieldName)) {
                model.setValue("matsearch", null);
                continue;
            }
            if ("chartselect".equals(fieldName)) {
                this.drawChart(Integer.parseInt(model.getValue("chartselect").toString()));
                continue;
            }
            if (!"org".equals(fieldName)) continue;
            model.setValue("matgrp", null);
            model.setValue("matsearch", null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.buildFilters(queryParam);
    }

    private boolean buildFilters(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("org");
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsBadDealRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        Object startDate = model.getValue("daterange_startdate");
        Object endDate = model.getValue("daterange_enddate");
        if (null == startDate || null == endDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsBadDealRptCommonPlugin_1", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection biztypes = (DynamicObjectCollection)model.getValue("biztype");
        if (CollectionUtils.isEmpty((Collection)biztypes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsBadDealRptCommonPlugin_2", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> org = null;
        ArrayList<Long> responorg = null;
        ArrayList<Long> biztype = null;
        ArrayList<Long> matgrp = null;
        ArrayList<Long> matsearch = null;
        List filter = queryParam.getFilter().getQFilters();
        filter.clear();
        filter.add(new QFilter("billstatus", "=", (Object)"C"));
        Object value = model.getValue("org");
        if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
            org = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                org.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("org", "in", org));
        }
        if ((value = model.getValue("responorg")) != null && !((DynamicObjectCollection)value).isEmpty()) {
            responorg = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                responorg.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("materialentry.responorg", "in", responorg));
        }
        filter.add(new QFilter("handdate", ">=", startDate));
        filter.add(new QFilter("handdate", "<=", (Object)new Date(KDDateUtils.addDays((Date)((Date)endDate), (int)1).getTime() - 1L)));
        value = model.getValue("biztype");
        if (value != null) {
            biztype = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                biztype.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("biztype", "in", biztype));
        }
        this.addFilters(filter);
        value = model.getValue("matgrp");
        if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
            matgrp = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                matgrp.add(d.getLong("fbasedataid_id"));
            }
            QFilter f = new QFilter("group.id", "in", matgrp);
            DynamicObjectCollection materialgroupdetailIds = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])f.toArray(), null);
            ArrayList<Long> materialIds = new ArrayList<Long>();
            if (materialgroupdetailIds != null && !materialgroupdetailIds.isEmpty()) {
                for (DynamicObject d : materialgroupdetailIds) {
                    materialIds.add(d.getLong("material.id"));
                }
            }
            filter.add(new QFilter("materialentry.materielid.id", "in", materialIds));
        }
        if ((value = model.getValue("matsearch")) != null && !((DynamicObjectCollection)value).isEmpty()) {
            matsearch = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                matsearch.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("materialentry.materielid", "in", matsearch));
        }
        filter.add(new QFilter("counttype", "=", this.getModel().getValue("counttype")));
        return this.queryData(filter, queryParam);
    }

    @Override
    public abstract boolean queryData(List<QFilter> var1, ReportQueryParam var2);

    @Override
    public abstract List<QFilter> addFilters(List<QFilter> var1);

    public abstract String getChartField();

    public abstract String getChartFieldName();

    public void registerListener(EventObject e) {
        BasedataEdit biztype;
        BasedataEdit org;
        BasedataEdit matgrp;
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{"pre", "next"});
        BasedataEdit matsearch = (BasedataEdit)this.getView().getControl("matsearch");
        if (matsearch != null) {
            matsearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((matgrp = (BasedataEdit)this.getView().getControl("matgrp")) != null) {
            matgrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("org")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((biztype = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("config".equals(evt.getOperationKey())) {
            ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
            chartTool.showSetting((IFormPlugin)this, (IFormView)this.getView());
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        this.chartSelectInit();
        this.showDetailList();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
    }

    private void chartSelectInit() {
        ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
        ComboEdit comboEdit = (ComboEdit)this.getControl("chartselect");
        ChartSelect chartSelect = chartTool.getChartSelect();
        ArrayList<ComboItem> it = new ArrayList<ComboItem>();
        if (chartSelect != null && chartSelect.getChartSelectList() != null && !chartSelect.getChartSelectList().isEmpty() && chartSelect.getSelectedIndex() >= 0) {
            Integer si = chartSelect.getSelectedIndex();
            List checkIndex = chartSelect.getCheckIndex();
            List chartSelectList = chartSelect.getChartSelectList();
            Collections.sort(checkIndex, Collections.reverseOrder());
            for (Integer index : checkIndex) {
                chartSelectList.remove(index);
            }
            if (!chartSelectList.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"chartselect", "chartpanel"});
                int i = 0;
                for (String s : chartSelectList) {
                    it.add(new ComboItem(new LocaleString(s), String.valueOf(i)));
                    ++i;
                }
                comboEdit.setComboItems(it);
                if (si > chartSelectList.size() - 1) {
                    si = 0;
                }
                this.getModel().setValue("chartselect", (Object)si);
                this.drawChart(si);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"chartselect", "chartpanel"});
                this.getModel().setValue("chartselect", (Object)"-1");
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chartselect", "chartpanel"});
            this.getModel().setValue("chartselect", (Object)"-1");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent == null) {
            return;
        }
        String connStr = closedCallBackEvent.getActionId();
        if (StringUtils.isEmpty((String)connStr)) {
            return;
        }
        if ("qcqs_chartsetting".equals(connStr)) {
            this.chartSelectInit();
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Long currOrg = RequestContext.get().getOrgId();
        DynamicObject org = null;
        org = BusinessDataServiceHelper.loadSingle((Object)currOrg, (String)"bos_org");
        long userId = UserServiceHelper.getCurrentUserId();
        String entityName = this.getView().getEntityId();
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        if (org != null && org.getBoolean("fisqc") && hasPermOrgs.contains(currOrg) || PermissionServiceHelper.isAdminUser((long)userId) || PermissionServiceHelper.isSuperUser((long)userId)) {
            model.setValue("org", (Object)new Object[]{currOrg});
        }
        model.setValue("daterange_startdate", (Object)KDDateUtils.getTheMonthStart((int)0));
        model.setValue("daterange_enddate", (Object)KDDateUtils.today());
        model.setValue("biztype", (Object)new Object[]{959929179238017024L, 959929527046481920L});
        model.setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    private void drawChart(int chartIndex) {
        ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
        String counttype = chartTool.getOption(Integer.valueOf(chartIndex)).get("xaxisselect").toString();
        if (this.buildFilters(this.getQueryParam())) {
            DynamicObjectCollection query = (DynamicObjectCollection)this.getQueryParam().getCustomParam().get("queryDataSet");
            DataSet dealResult = this.dealResult(counttype, query);
            ChartFastData chartFastData = this.getChartFastData(dealResult, counttype);
            chartFastData.setChartIndex(Integer.valueOf(chartIndex));
            chartTool.drawChartByFlex((IFormView)this.getView(), "chartpanel", chartFastData);
        }
    }

    private ChartFastData getChartFastData(DataSet result, String counttype) {
        ChartFastData cfd = new ChartFastData();
        if (result != null) {
            int count = result.copy().count("materialno", false);
            String[] xaxisData = new String[count];
            HashMap<String, Number[]> series = new HashMap<String, Number[]>();
            series.put(ResManager.loadKDString((String)"\u4e0d\u826f\u6570\u91cf", (String)"InsBadDealRptCommonPlugin_3", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4e0d\u826f\u5360\u6bd4", (String)"InsBadDealRptCommonPlugin_4", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u7d2f\u8ba1\u4e0d\u826f\u5360\u6bd4", (String)"InsBadDealRptCommonPlugin_5", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            int i = 0;
            for (Row row : result) {
                boolean flag;
                if (ManuBadAnalysisDimEnum.PROBLEMBADGROUP.getId().equals(counttype)) {
                    xaxisData[i] = row.getString("unquaprobnov") + "\n" + row.getString("unquaprobname");
                } else if (ManuBadAnalysisDimEnum.HANDMETHED.getId().equals(counttype)) {
                    xaxisData[i] = row.getString("handmethednov") == null ? "" : row.getString("handmethednov").replace("null", "") + "\n" + row.getString("handmethedname");
                } else if ("3".equals(counttype)) {
                    xaxisData[i] = row.getString(this.getChartField()) == null ? "" : row.getString(this.getChartField()).replace("null", "") + "\n" + row.getString(this.getChartFieldName());
                } else if (ManuBadAnalysisDimEnum.MATERIAL.getId().equals(counttype)) {
                    xaxisData[i] = row.getString("materialnov") + "\n" + row.getString("materialname");
                } else if (ManuBadAnalysisDimEnum.PRODUCTWORKSHOP.getId().equals(counttype)) {
                    flag = ((PersistedArrayRow)row).getRowMeta().toString().contains("productionworkshopnov");
                    if (flag) {
                        xaxisData[i] = row.getString("productionworkshopnov") + "\n" + row.getString("productionworkshopname");
                    }
                } else if (ManuBadAnalysisDimEnum.OPROPERATION.getId().equals(counttype)) {
                    flag = ((PersistedArrayRow)row).getRowMeta().toString().contains("oproperationnov");
                    if (flag) {
                        xaxisData[i] = row.getString("oproperationnov") + "\n" + row.getString("oproperationname");
                    }
                } else if (ManuBadAnalysisDimEnum.OPRWORKSHOP.getId().equals(counttype) && (flag = ((PersistedArrayRow)row).getRowMeta().toString().contains("oprworkshopnov"))) {
                    xaxisData[i] = row.getString("oprworkshopnov") + "\n" + row.getString("oprworkshopname");
                }
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4e0d\u826f\u6570\u91cf", (String)"InsBadDealRptCommonPlugin_3", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("unquaqty");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4e0d\u826f\u5360\u6bd4", (String)"InsBadDealRptCommonPlugin_4", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("unqqtyprop");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u4e0d\u826f\u5360\u6bd4", (String)"InsBadDealRptCommonPlugin_5", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("cumunqqtyprop");
                ++i;
            }
            cfd.setXaxisData(xaxisData);
            cfd.setSeries(series);
        }
        return cfd;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObjectCollection qorg;
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("matgrp".equals(key) || "matsearch".equals(key) || "supsearch".equals(key) || "custsearch".equals(key) || "warehousearch".equals(key)) {
            QFilter qFilter;
            Object v = model.getValue("org");
            ArrayList<Long> orgIds = new ArrayList<Long>();
            if (v != null && !((DynamicObjectCollection)v).isEmpty()) {
                for (DynamicObject d : (DynamicObjectCollection)v) {
                    orgIds.add(d.getLong("fbasedataid_id"));
                }
            }
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            if (orgIds.size() > 0) {
                params.put("useOrgs", orgIds);
                showParameter.setCustomParams(params);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsBadDealRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]), Integer.valueOf(2500));
                e.setCancel(true);
            }
            if ("matsearch".equals(key)) {
                Object value = model.getValue("matgrp");
                if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
                    ArrayList<Long> matgrp = new ArrayList<Long>();
                    for (DynamicObject d : (DynamicObjectCollection)value) {
                        matgrp.add(d.getLong("fbasedataid_id"));
                    }
                    QFilter f = new QFilter("group.id", "in", matgrp);
                    DynamicObjectCollection materialgroupdetailIds = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])f.toArray(), null);
                    ArrayList<Long> materialIds = new ArrayList<Long>();
                    if (materialgroupdetailIds != null && !materialgroupdetailIds.isEmpty()) {
                        for (DynamicObject d : materialgroupdetailIds) {
                            materialIds.add(d.getLong("material.id"));
                        }
                    }
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", materialIds));
                }
            } else if ("warehousearch".equals(key) && orgIds.size() > 0) {
                qFilter = new QFilter("createorg", "in", orgIds);
                qFilter.or(new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5')));
                DynamicObjectCollection warehoseCollectioin = QueryServiceHelper.query((String)"bd_warehouse", (String)"bd_warehouse", (String)"id,createorg,ctrlstrategy", (QFilter[])qFilter.toArray(), null);
                ArrayList<Long> warehoseIds = new ArrayList<Long>();
                if (warehoseCollectioin != null && !warehoseCollectioin.isEmpty()) {
                    for (DynamicObject d : warehoseCollectioin) {
                        warehoseIds.add(d.getLong("id"));
                    }
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", warehoseIds));
            } else if ("matgrp".equals(key)) {
                qFilter = new QFilter("createorg", "in", orgIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("org".equals(key)) {
            long userId = UserServiceHelper.getCurrentUserId();
            if (!PermissionServiceHelper.isAdminUser((long)userId) && !PermissionServiceHelper.isSuperUser((long)userId)) {
                String entityName = this.getView().getEntityId();
                String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
                String appId = this.getView().getFormShowParameter().getAppId();
                HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
                QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (("oprworkshopsearch".equals(key) || "oproperationsearch".equals(key) || "centersearch".equals(key) || "productionsearch".equals(key)) && (qorg = (DynamicObjectCollection)model.getValue("org")).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsBadDealRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]), Integer.valueOf(2500));
            e.setCancel(true);
        }
    }

    private void showDetailList() {
        FormShowParameter showParameter = new FormShowParameter();
        if (this.buildFilters(this.getQueryParam())) {
            List filters = this.getQueryParam().getFilter().getQFilters();
            showParameter.setFormId(this.getListForm());
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("filters", filters);
            showParameter.setCustomParams(params);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexpanelap2");
            this.getView().showForm(showParameter);
        }
    }
}

