/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.business.rpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcqs.business.inter.IInsRptCommonInter;
import kd.qmc.qcqs.common.chart.ChartFastData;
import kd.qmc.qcqs.common.chart.ChartSelect;
import kd.qmc.qcqs.common.chart.ChartTool;
import kd.qmc.qcqs.common.chart.ChartUtil;
import kd.qmc.qcqs.common.util.InsRptCommonQueryUtil;

public abstract class InsQuaRptCommonPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
IInsRptCommonInter {
    private static Log logger = LogFactory.getLog(InsQuaRptCommonPlugin.class);
    private static final String[] HS = new String[]{"batquaratetag", "batquarate", "batunquaratetag", "batunquarate", "proquaratetag", "proquarate", "prounquaratetag", "prounquarate", "ppmtag", "ppmreal"};

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeData;
        Object newValue;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block12: for (int i = 0; i < changeSet.length && ChartUtil.valueCheck((Object)(newValue = (changeData = changeSet[i]).getNewValue()), (Object)(oldValue = changeData.getOldValue())); ++i) {
            switch (fieldName) {
                case "matgrpsta": {
                    model.setValue("matgrp", null);
                    continue block12;
                }
                case "matgrp": {
                    model.setValue("matsearch", null);
                    continue block12;
                }
                case "chartselect": {
                    if (null == newValue) continue block12;
                    this.drawChart(Integer.parseInt(newValue.toString()));
                    continue block12;
                }
                case "org": {
                    model.setValue("matgrp", null);
                    model.setValue("matsearch", null);
                    continue block12;
                }
            }
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            event.setSort(true);
            event.setFilter(true);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.buildFilters(queryParam);
    }

    private boolean buildFilters(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("org");
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsQuaRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        Object startDate = model.getValue("daterange_startdate");
        Object endDate = model.getValue("daterange_enddate");
        if (null == startDate || null == endDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsQuaRptCommonPlugin_1", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection biztypes = (DynamicObjectCollection)model.getValue("biztype");
        if (CollectionUtils.isEmpty((Collection)biztypes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsQuaRptCommonPlugin_2", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        Object mulcounttype = this.getModel().getValue("mulcounttype");
        if (mulcounttype == null || StringUtils.isEmpty((String)mulcounttype.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsQuaRptCommonPlugin_3", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        Object analyindex = this.getModel().getValue("analyindex");
        if (analyindex == null || StringUtils.isEmpty((String)analyindex.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InsQuaRptCommonPlugin_4", (String)"qmc-qcqs-business", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> org = null;
        ArrayList<Long> supplyorg = null;
        ArrayList<Long> biztype = null;
        ArrayList<Long> matgrp = null;
        ArrayList<Long> matsearch = null;
        List filter = queryParam.getFilter().getQFilters();
        filter.clear();
        filter.add(new QFilter("billstatus", "=", (Object)"C"));
        Object value = model.getValue("org");
        if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
            org = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                org.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("org", "in", org));
        }
        if ((value = model.getValue("supplyorg")) != null && !((DynamicObjectCollection)value).isEmpty()) {
            supplyorg = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                supplyorg.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("matintoentity.supplyorg", "in", supplyorg));
        }
        filter.add(new QFilter("inspeenddate", ">=", startDate));
        filter.add(new QFilter("inspeenddate", "<=", (Object)new Date(KDDateUtils.addDays((Date)((Date)endDate), (int)1).getTime() - 1L)));
        value = model.getValue("biztype");
        if (value != null) {
            biztype = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                biztype.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("biztype", "in", biztype));
        }
        this.addFilters(filter);
        value = model.getValue("matgrp");
        if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
            matgrp = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                matgrp.add(d.getLong("fbasedataid_id"));
            }
            QFilter f = new QFilter("group.id", "in", matgrp);
            DynamicObjectCollection materialgroupdetailIds = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])f.toArray(), null);
            ArrayList<Long> materialIds = new ArrayList<Long>();
            if (materialgroupdetailIds != null && !materialgroupdetailIds.isEmpty()) {
                for (DynamicObject d : materialgroupdetailIds) {
                    materialIds.add(d.getLong("material.id"));
                }
            }
            filter.add(new QFilter("matintoentity.materialid.id", "in", materialIds));
        }
        if ((value = model.getValue("matsearch")) != null && !((DynamicObjectCollection)value).isEmpty()) {
            matsearch = new ArrayList<Long>();
            for (DynamicObject d : (DynamicObjectCollection)value) {
                matsearch.add(d.getLong("fbasedataid_id"));
            }
            filter.add(new QFilter("matintoentity.materialid", "in", matsearch));
        }
        filter.add(new QFilter("orgids", "in", org));
        filter.add(new QFilter("mulcounttype", "=", this.getModel().getValue("mulcounttype")));
        return this.queryData(filter, queryParam);
    }

    public void registerListener(EventObject e) {
        BasedataEdit oprworkshopsearch;
        BasedataEdit productionsearch;
        BasedataEdit centersearch;
        BasedataEdit oproperationsearch;
        BasedataEdit biztype;
        BasedataEdit org;
        BasedataEdit matsearch;
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{"pre", "next"});
        BasedataEdit matgrp = (BasedataEdit)this.getView().getControl("matgrp");
        if (matgrp != null) {
            matgrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((matsearch = (BasedataEdit)this.getView().getControl("matsearch")) != null) {
            matsearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("org")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((biztype = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((oproperationsearch = (BasedataEdit)this.getView().getControl("oproperationsearch")) != null) {
            oproperationsearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((centersearch = (BasedataEdit)this.getView().getControl("centersearch")) != null) {
            centersearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((productionsearch = (BasedataEdit)this.getView().getControl("productionsearch")) != null) {
            productionsearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((oprworkshopsearch = (BasedataEdit)this.getView().getControl("oprworkshopsearch")) != null) {
            oprworkshopsearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("config".equals(evt.getOperationKey())) {
            ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
            chartTool.showSetting((IFormPlugin)this, (IFormView)this.getView());
        }
    }

    @Override
    public abstract Map<Integer, Integer[]> getHideMap();

    @Override
    public abstract String[] getHideFields();

    @Override
    public abstract String[] getXname();

    @Override
    public abstract Map<Integer, Integer[]> getXim();

    @Override
    public abstract String getBillForm();

    @Override
    public abstract String getListForm();

    @Override
    public abstract List<QFilter> addFilters(List<QFilter> var1);

    @Override
    public abstract boolean queryData(List<QFilter> var1, ReportQueryParam var2);

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        this.analyindexCheck(event);
        Map<Integer, Integer[]> im = this.getHideMap();
        String[] split = this.getModel().getValue("mulcounttype").toString().split(",");
        List columns = event.getColumns();
        for (String field : this.getHideFields()) {
            for (AbstractReportColumn column : columns) {
                ReportColumn rptColumn = (ReportColumn)column;
                if (!field.equals(rptColumn.getFieldKey())) continue;
                rptColumn.setHide(true);
            }
        }
        boolean df = false;
        for (String s : split) {
            Integer[] integers;
            if ("".equals(s)) continue;
            int c = Integer.parseInt(s);
            for (Integer integer : integers = im.get(c)) {
                for (AbstractReportColumn column : columns) {
                    ReportColumn rptColumn = (ReportColumn)column;
                    if (this.getHideFields()[integer].equals(rptColumn.getFieldKey())) {
                        rptColumn.setHide(false);
                    }
                    if (("1".equals(s) || "2".equals(s)) && df && ("rptyear".equals(rptColumn.getFieldKey()) || "rptmonth".equals(rptColumn.getFieldKey()))) {
                        rptColumn.setHide(true);
                    }
                    if (!"3".equals(s) || !"rptyear".equals(rptColumn.getFieldKey()) && !"rptmonth".equals(rptColumn.getFieldKey())) continue;
                    rptColumn.setHide(true);
                    df = true;
                }
            }
        }
        this.chartSelectInit();
        this.showDetailList();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent == null) {
            return;
        }
        String connStr = closedCallBackEvent.getActionId();
        if (StringUtils.isEmpty((String)connStr)) {
            return;
        }
        if ("qcqs_chartsetting".equals(connStr)) {
            this.chartSelectInit();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long currOrg = RequestContext.get().getOrgId();
        DynamicObject org = null;
        org = BusinessDataServiceHelper.loadSingle((Object)currOrg, (String)"bos_org");
        long userId = UserServiceHelper.getCurrentUserId();
        String entityName = this.getView().getEntityId();
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        if (org != null && org.getBoolean("fisqc") && (hasPermOrgs.contains(currOrg) || PermissionServiceHelper.isAdminUser((long)userId) || PermissionServiceHelper.isSuperUser((long)userId))) {
            model.setValue("org", (Object)new Object[]{currOrg});
        }
        model.setValue("daterange_startdate", (Object)KDDateUtils.getTheMonthStart((int)0));
        model.setValue("daterange_enddate", (Object)KDDateUtils.today());
        model.setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    private void chartSelectInit() {
        ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
        ComboEdit comboEdit = (ComboEdit)this.getControl("chartselect");
        ChartSelect chartSelect = chartTool.getChartSelect();
        ArrayList<ComboItem> it = new ArrayList<ComboItem>();
        if (chartSelect != null && chartSelect.getChartSelectList() != null && !chartSelect.getChartSelectList().isEmpty() && chartSelect.getSelectedIndex() >= 0) {
            Integer si = chartSelect.getSelectedIndex();
            List checkIndex = chartSelect.getCheckIndex();
            List chartSelectList = chartSelect.getChartSelectList();
            Collections.sort(checkIndex, Collections.reverseOrder());
            for (Integer index : checkIndex) {
                chartSelectList.remove(index);
            }
            if (!chartSelectList.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"chartselect", "chartpanel"});
                int i = 0;
                for (String s : chartSelectList) {
                    LocaleString localeString = new LocaleString(s);
                    logger.info("kd.qmc.qcqs.business.rpt.InsQuaRptCommonPlugin.chartSelectInit s:" + localeString);
                    it.add(new ComboItem(localeString, String.valueOf(i)));
                    ++i;
                }
                comboEdit.setComboItems(it);
                if (si > chartSelectList.size() - 1) {
                    si = 0;
                }
                this.getModel().setValue("chartselect", (Object)si);
                this.drawChart(si);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"chartselect", "chartpanel"});
                this.getModel().setValue("chartselect", (Object)"-1");
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chartselect", "chartpanel"});
            this.getModel().setValue("chartselect", (Object)"-1");
        }
    }

    private void drawChart(Integer chartIndex) {
        IDataModel model = this.getModel();
        ChartTool chartTool = new ChartTool((IFormView)this.getView(), this.getView().getEntityId());
        Map option = chartTool.getOption(chartIndex);
        String mulcounttype = String.valueOf(option.get("mulxaxisselect"));
        if (this.buildFilters(this.getQueryParam())) {
            DynamicObjectCollection query = (DynamicObjectCollection)this.getQueryParam().getCustomParam().get("queryDataSet");
            ArrayList<Long> org = null;
            Object value = model.getValue("org");
            if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
                org = new ArrayList<Long>();
                for (DynamicObject d : (DynamicObjectCollection)value) {
                    org.add(d.getLong("fbasedataid_id"));
                }
            }
            DataSet dealResult = this.dealResult(mulcounttype, query, org);
            ChartFastData chartFastData = this.getChartFastData(dealResult, mulcounttype);
            chartFastData.setChartIndex(chartIndex);
            chartTool.drawChartByFlex((IFormView)this.getView(), "chartpanel", chartFastData);
        }
    }

    private ChartFastData getChartFastData(DataSet result, String mulcounttype) {
        ChartFastData cfd = new ChartFastData();
        if (result != null) {
            int count = result.copy().count("matgrono", false);
            String[] xaxisData = new String[count];
            HashMap<String, Number[]> series = new HashMap<String, Number[]>();
            series.put(ResManager.loadKDString((String)"\u68c0\u9a8c\u6279\u6b21", (String)"InsQuaRptCommonPlugin_5", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u5408\u683c\u6279\u6b21", (String)"InsQuaRptCommonPlugin_6", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4e0d\u826f\u6279\u6b21", (String)"InsQuaRptCommonPlugin_7", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u6279\u5408\u683c\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_8", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u6279\u5408\u683c\u7387", (String)"InsQuaRptCommonPlugin_9", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u6279\u4e0d\u826f\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_10", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u6279\u4e0d\u826f\u7387", (String)"InsQuaRptCommonPlugin_11", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u68c0\u9a8c\u6570\u91cf", (String)"InsQuaRptCommonPlugin_12", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u5408\u683c\u6570\u91cf", (String)"InsQuaRptCommonPlugin_13", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4e0d\u826f\u6570\u91cf", (String)"InsQuaRptCommonPlugin_14", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4ea7\u54c1\u5408\u683c\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_15", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4ea7\u54c1\u5408\u683c\u7387", (String)"InsQuaRptCommonPlugin_16", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0d\u826f\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_17", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0d\u826f\u7387", (String)"InsQuaRptCommonPlugin_18", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"PPM\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_19", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            series.put(ResManager.loadKDString((String)"PPM\u5b9e\u9645\u503c", (String)"InsQuaRptCommonPlugin_20", (String)"qmc-qcqs-business", (Object[])new Object[0]), new Number[count]);
            String rptName = this.getView().getEntityId();
            int i = 0;
            for (Row row : result) {
                int r = 1;
                Map<Object, Object> im = new HashMap<Integer, Integer[]>(9);
                im.put(r, new Integer[]{0});
                im.put(++r, new Integer[]{0, 1});
                im.put(++r, new Integer[]{2});
                im.put(++r, new Integer[]{15, 4});
                im.put(++r, new Integer[]{16, 6});
                im.put(++r, new Integer[]{18, 10});
                im.put(++r, new Integer[]{19, 12});
                im.put(++r, new Integer[]{17, 8});
                im.put(++r, new Integer[]{20, 14});
                if ("qcqs_manuinsquarpt".equals(rptName)) {
                    im = this.getXim();
                }
                String[] split = mulcounttype.split(",");
                LinkedHashSet<String> ss = new LinkedHashSet<String>(20);
                for (String s : split) {
                    Integer[] integers;
                    if ("".equals(s)) continue;
                    for (Integer integer : integers = (Integer[])im.get(Integer.parseInt(s))) {
                        ss.add(this.getXname()[integer]);
                    }
                }
                for (String s : split) {
                    if ("".equals(s) || !"3".equals(s)) continue;
                    ss.remove(this.getXname()[0]);
                    ss.remove(this.getXname()[1]);
                }
                StringBuilder sb = new StringBuilder();
                for (String string : ss) {
                    if ("rptyear".equals(string)) {
                        sb.append(row.getString(string));
                        continue;
                    }
                    if ("rptmonth".equals(string)) {
                        sb.append("-");
                        sb.append(row.getString(string));
                        continue;
                    }
                    sb.append(InsRptCommonQueryUtil.stringCheck((Object)row.getString(string)));
                    sb.append(' ');
                }
                xaxisData[i] = sb.toString();
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u68c0\u9a8c\u6279\u6b21", (String)"InsQuaRptCommonPlugin_5", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("batchtotal");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u5408\u683c\u6279\u6b21", (String)"InsQuaRptCommonPlugin_6", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("quabatch");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4e0d\u826f\u6279\u6b21", (String)"InsQuaRptCommonPlugin_7", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("unqualifybatch");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u6279\u5408\u683c\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_8", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("batquaratetag");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u6279\u5408\u683c\u7387", (String)"InsQuaRptCommonPlugin_9", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("batquarate");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u6279\u4e0d\u826f\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_10", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("batunquaratetag");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u6279\u4e0d\u826f\u7387", (String)"InsQuaRptCommonPlugin_11", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("batunquarate");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u68c0\u9a8c\u6570\u91cf", (String)"InsQuaRptCommonPlugin_12", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("insqty");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u5408\u683c\u6570\u91cf", (String)"InsQuaRptCommonPlugin_13", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("quaqty");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4e0d\u826f\u6570\u91cf", (String)"InsQuaRptCommonPlugin_14", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("unquaqty");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u5408\u683c\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_15", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("proquaratetag");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u5408\u683c\u7387", (String)"InsQuaRptCommonPlugin_16", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("proquarate");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0d\u826f\u7387\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_17", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("prounquaratetag");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0d\u826f\u7387", (String)"InsQuaRptCommonPlugin_18", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("prounquarate");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"PPM\u76ee\u6807\u503c", (String)"InsQuaRptCommonPlugin_19", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("ppmtag");
                ((Number[])series.get((Object)ResManager.loadKDString((String)"PPM\u5b9e\u9645\u503c", (String)"InsQuaRptCommonPlugin_20", (String)"qmc-qcqs-business", (Object[])new Object[0])))[i] = row.getBigDecimal("ppmreal");
                ++i;
            }
            cfd.setXaxisData(xaxisData);
            cfd.setSeries(series);
        }
        return cfd;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObjectCollection qorg;
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("matgrp".equals(key) || "matsearch".equals(key) || "supsearch".equals(key) || "warehousearch".equals(key) || "custsearch".equals(key)) {
            QFilter qFilter;
            Object v = model.getValue("org");
            ArrayList<Long> orgIds = new ArrayList<Long>();
            if (v != null && !((DynamicObjectCollection)v).isEmpty()) {
                for (DynamicObject d : (DynamicObjectCollection)v) {
                    orgIds.add(d.getLong("fbasedataid_id"));
                }
            }
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            if (orgIds.size() > 0) {
                params.put("useOrgs", orgIds);
                showParameter.setCustomParams(params);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsQuaRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]), Integer.valueOf(2500));
                e.setCancel(true);
            }
            if ("matsearch".equals(key)) {
                Object value = model.getValue("matgrp");
                if (value != null && !((DynamicObjectCollection)value).isEmpty()) {
                    ArrayList<Long> matgrp = new ArrayList<Long>();
                    for (DynamicObject d : (DynamicObjectCollection)value) {
                        matgrp.add(d.getLong("fbasedataid_id"));
                    }
                    QFilter f = new QFilter("group.id", "in", matgrp);
                    DynamicObjectCollection materialgroupdetailIds = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])f.toArray(), null);
                    ArrayList<Long> materialIds = new ArrayList<Long>();
                    if (materialgroupdetailIds != null && !materialgroupdetailIds.isEmpty()) {
                        for (DynamicObject d : materialgroupdetailIds) {
                            materialIds.add(d.getLong("material.id"));
                        }
                    }
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", materialIds));
                }
            } else if ("warehousearch".equals(key) || "custsearch".equals(key)) {
                qFilter = new QFilter("createorg", "in", orgIds);
                qFilter.or("ctrlstrategy", "=", (Object)Character.valueOf('5'));
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else if ("matgrp".equals(key)) {
                qFilter = new QFilter("createorg", "in", orgIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("org".equals(key)) {
            long userId = UserServiceHelper.getCurrentUserId();
            if (!PermissionServiceHelper.isAdminUser((long)userId) && !PermissionServiceHelper.isSuperUser((long)userId)) {
                String entityName = this.getView().getEntityId();
                String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
                String appId = this.getView().getFormShowParameter().getAppId();
                HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
                QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (("oprworkshopsearch".equals(key) || "oproperationsearch".equals(key) || "centersearch".equals(key) || "productionsearch".equals(key)) && (qorg = (DynamicObjectCollection)model.getValue("org")).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InsQuaRptCommonPlugin_0", (String)"qmc-qcqs-business", (Object[])new Object[0]), Integer.valueOf(2500));
            e.setCancel(true);
        }
    }

    private void showDetailList() {
        FormShowParameter showParameter = new FormShowParameter();
        if (this.buildFilters(this.getQueryParam())) {
            List filters = this.getQueryParam().getFilter().getQFilters();
            showParameter.setFormId(this.getListForm());
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("filters", filters);
            showParameter.setCustomParams(params);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexpanelap2");
            this.getView().showForm(showParameter);
        }
    }

    private void analyindexCheck(CreateColumnEvent event) {
        ReportColumn rptColumn;
        HashMap<Integer, Integer[]> im = new HashMap<Integer, Integer[]>();
        im.put(1, new Integer[]{0, 1});
        im.put(2, new Integer[]{4, 5});
        im.put(3, new Integer[]{2, 3});
        im.put(4, new Integer[]{6, 7});
        im.put(5, new Integer[]{8, 9});
        List columns = event.getColumns();
        for (String s : HS) {
            for (AbstractReportColumn column : columns) {
                rptColumn = (ReportColumn)column;
                if (!s.equals(rptColumn.getFieldKey())) continue;
                rptColumn.setHide(true);
            }
        }
        String[] split = this.getModel().getValue("analyindex").toString().split(",");
        ArrayList<String> al = new ArrayList<String>(split.length);
        for (String s : split) {
            Integer[] integers;
            if ("".equals(s)) continue;
            for (Integer integer : integers = (Integer[])im.get(Integer.parseInt(s))) {
                al.add(HS[integer]);
            }
        }
        for (String s : al) {
            for (AbstractReportColumn column : columns) {
                rptColumn = (ReportColumn)column;
                if (!s.equals(rptColumn.getFieldKey())) continue;
                rptColumn.setHide(false);
            }
        }
    }
}

