/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.common.chart;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.constant.ChartSettingConst;
import kd.qmc.qcbd.common.util.ChartSettingUtil;
import kd.qmc.qcqs.common.chart.ChartFastData;
import kd.qmc.qcqs.common.chart.ChartSelect;
import kd.qmc.qcqs.common.chart.ChartUtil;
import kd.qmc.qcqs.common.chart.MyChartData;

public class ChartTool {
    private static Log logger = LogFactory.getLog(ChartTool.class);
    private ChartFastData chartFastData;
    private Integer chartIndex = null;
    private String formKey;
    private int xaxisSelect = 1;
    private String mulxaxisSelect = "1,2";
    private String settingName = "";
    private ChartSelect chartSelect;
    private int maxXlength = 10;
    private List<Map<String, Object>> option;
    private boolean showTitle = true;
    private boolean showLegend = true;
    private boolean showTooltip = true;
    private String barMaxWidth = "20%";
    private int maxLegendLength = 10;
    private static String[] sa = new String[]{"customchartap1", "customchartap2", "customchartap3", "customchartap4", "customchartap5", "customchartap6", "customchartap7", "customchartap8"};
    private IFormView sv;
    private static final int MAXPIE = 8;

    public ChartTool(IFormView view, String formKey) {
        this.sv = view;
        this.formKey = formKey;
    }

    public ChartTool(String formkey) {
        this.formKey = formkey;
    }

    public static ChartTool initChart(IFormView view, String formkey) {
        return new ChartTool(view, formkey);
    }

    public int getChartIndex() {
        return this.chartIndex;
    }

    public void setChartIndex(int chartIndex) {
        this.chartIndex = chartIndex;
    }

    public ChartSelect getChartSelect() {
        this.optionInit();
        return this.chartSelect;
    }

    public void setChartSelect(ChartSelect chartSelect) {
        this.chartSelect = chartSelect;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public Map<String, Object> getOption(Integer chartIndex) {
        this.chartIndex = chartIndex;
        this.optionInit();
        HashMap<String, Object> rm = new HashMap<String, Object>(16);
        rm.put("xaxisselect", this.xaxisSelect);
        rm.put("mulxaxisselect", this.mulxaxisSelect);
        return rm;
    }

    public void drawChart(ChartFastData chartFastData) {
        this.chartFastData = chartFastData;
        this.chartIndex = chartFastData.getChartIndex();
        this.optionInint(this.sv.getParentView());
        this.sv.setVisible(Boolean.FALSE, sa);
        if (this.option == null || this.option.isEmpty()) {
            this.sv.setVisible(Boolean.FALSE, new String[]{"customchartap"});
            return;
        }
        if (this.isPie()) {
            this.pieInit();
        } else {
            Chart customchart = (Chart)this.sv.getControl("customchartap");
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass("kd.bos.form.chart.Chart");
                Field colorFld = clazz.getDeclaredField("chartData");
                AccessibleObject[] colorAcce = new AccessibleObject[]{colorFld};
                AccessibleObject.setAccessible(colorAcce, true);
                colorFld.set(customchart, (Object)new MyChartData());
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.actionClassNotFound, new Object[]{String.format(ResManager.loadKDString((String)"\u7c7b\u8bbf\u95ee\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:%s\u3002", (String)"ChartTool_0", (String)"qmc-qcqs-common", (Object[])new Object[0]), e.getMessage())});
            }
            this.initXAxis(customchart);
            customchart.addTooltip("trigger", (Object)"axis");
            String targetValue = ResManager.loadKDString((String)"\u7387\u76ee\u6807\u503c", (String)"ChartTool_1", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String actualValue = ResManager.loadKDString((String)"\u7387\u5b9e\u9645\u503c", (String)"ChartTool_2", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String quaRate = ResManager.loadKDString((String)"\u5408\u683c\u7387", (String)"ChartTool_3", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String badRate = ResManager.loadKDString((String)"\u4e0d\u826f\u7387", (String)"ChartTool_4", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String proportion = ResManager.loadKDString((String)"\u5360\u6bd4", (String)"ChartTool_5", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String formatter = "function (params) {var html=params[0].name+'<br>';for(var i=0;i<params.length;i++){html+='<span style=\"display:inline-block;margin-right:5px;border-radius:10px;width:10px;height:10px;background-color:'+params[i].color+';\"></span>';var seriesName = params[i].seriesName;if(seriesName.indexOf('" + targetValue + "',seriesName.length-" + targetValue.length() + ")!=-1||seriesName.indexOf('" + actualValue + "',seriesName.length-" + actualValue.length() + ")!=-1||seriesName.indexOf('" + quaRate + "',seriesName.length-" + quaRate.length() + ")!=-1||seriesName.indexOf('" + badRate + "',seriesName.length-" + badRate.length() + ")!=-1||seriesName.indexOf('" + proportion + "',seriesName.length-" + proportion.length() + ")!=-1){html+=params[i].seriesName+\":\"+params[i].value.toFixed(2)+\"%<br>\";}else if(seriesName.indexOf('PPM',0)!=-1){html+=params[i].seriesName+\":\"+params[i].value.toFixed(1)+\"<br>\";}else{html+=params[i].seriesName+\":\"+params[i].value+\"<br>\";}}return html;}";
            customchart.addTooltip("formatter", (Object)formatter);
            ArrayList<String> funcPathList = new ArrayList<String>();
            funcPathList.add("tooltip.formatter");
            this.setFuncPath(customchart, funcPathList);
            HashMap<String, String> axisPointType = new HashMap<String, String>(16);
            axisPointType.put("type", "shadow");
            customchart.addTooltip("axisPointer", axisPointType);
            customchart.setShowTitle(false);
            customchart.setShowLegend(this.showLegend);
            customchart.setLegendPropValue("x", (Object)"center");
            customchart.setLegendPropValue("y", (Object)"bottom");
            customchart.setMargin(Position.top, "10px");
            customchart.setMargin(Position.bottom, "65px");
            customchart.setMargin(Position.left, "110px");
            customchart.setMargin(Position.right, "110px");
            customchart.setShowTooltip(this.showTooltip);
            customchart.setTitlePropValue("text", (Object)this.settingName);
            customchart.setTitlePropValue("x", (Object)20);
            customchart.bindData((BindingContext)null);
        }
    }

    private void optionInint(IFormView parentView) {
        DynamicObject[] dc = this.getSeting(parentView);
        this.encaObjectInit(dc);
    }

    private DynamicObject[] getSeting(IFormView parentView) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String formkey = parentView.getEntityId();
        String selectFields = "number,name,userid,xaxisselect,mulxaxisselect,checkbox,creator,rptflag,biztype,seqindex,schemtype,entryentity.seq,entryentity.seriesnames,entryentity.charttype,entryentity.color,entryentity.datalabel,entryentity.secondyaxis,entryentity.checked";
        QFilter filter = new QFilter("creator", "=", (Object)currentUserId);
        filter.and("issys", "=", (Object)false);
        filter.and("rptflag.number", "=", (Object)formkey);
        DynamicObject[] dc = BusinessDataServiceHelper.load((String)"qcqs_charsettingschem", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"seqindex");
        if (dc == null || dc.length == 0) {
            QFilter subFilter = new QFilter("issys", "=", (Object)true);
            subFilter.and(new QFilter("rptflag.number", "=", (Object)formkey));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"qcqs_charsettingschem", (String)selectFields, (QFilter[])new QFilter[]{subFilter});
            DynamicObject s = this.setNewObject(obj, currentUserId);
            dc = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{s});
        }
        return dc;
    }

    private boolean isPie() {
        boolean f = false;
        for (Map<String, Object> op : this.option) {
            if (!"C".equals(op.get("charttype").toString()) || !Boolean.parseBoolean(op.get("checked").toString())) continue;
            f = true;
            break;
        }
        return f;
    }

    private Map<String, Object> optionMatch(String seriesName) {
        for (Map<String, Object> op : this.option) {
            if (!op.get("seriesname").equals(seriesName)) continue;
            return op;
        }
        return null;
    }

    private void optionInit() {
        DynamicObject[] dc = this.getSetting(this.formKey);
        this.encaObjectInit(dc);
    }

    private void encaObjectInit(DynamicObject[] dc) {
        if (dc != null && dc.length != 0) {
            if (this.chartIndex == null) {
                this.chartIndex = 0;
            }
            ArrayList<String> chartSelectList = new ArrayList<String>(dc.length);
            this.chartSelect = new ChartSelect();
            ArrayList<Integer> il = new ArrayList<Integer>();
            this.chartSelect.setCheckIndex(il);
            int r = 0;
            for (DynamicObject map : dc) {
                if ("false".equals(map.get("checkbox").toString())) {
                    this.chartSelect.getCheckIndex().add(r);
                }
                ++r;
                Object mapName = map.get("name");
                String name = ((ILocaleString)map.get("name")).getLocaleValue();
                logger.info("kd.qmc.qcqs.common.chart.ChartTool.encaObjectInit name:" + name + ";mapName:" + mapName);
                chartSelectList.add(name);
            }
            logger.info("kd.qmc.qcqs.common.chart.ChartTool.encaObjectInit chartSelectList:" + chartSelectList);
            this.chartSelect.setChartSelectList(chartSelectList);
            this.chartSelect.setSelectedIndex(this.chartIndex);
            DynamicObject firstShow = dc[this.chartIndex];
            if (null == firstShow) {
                this.option = new ArrayList<Map<String, Object>>(10);
                return;
            }
            if (firstShow.get("name") != null) {
                this.settingName = ((ILocaleString)firstShow.get("name")).getLocaleValue();
            }
            DynamicObjectCollection entryentity = firstShow.getDynamicObjectCollection("entryentity");
            if (StringUtils.isNotEmpty((String)String.valueOf(firstShow.get("xaxisselect")))) {
                this.xaxisSelect = Integer.parseInt(firstShow.get("xaxisselect").toString());
            }
            if (StringUtils.isNotEmpty((String)String.valueOf(firstShow.get("mulxaxisselect")))) {
                this.mulxaxisSelect = firstShow.get("mulxaxisselect").toString();
            }
            LinkedHashMap tihss = new LinkedHashMap();
            ChartSettingUtil chartSettingUtil = new ChartSettingUtil();
            tihss.putAll((Map)chartSettingUtil.getFORMSETTINGMAP().get(this.formKey));
            ArrayList<Map<String, Object>> lso = new ArrayList<Map<String, Object>>(tihss.size());
            for (Map.Entry entry : tihss.entrySet()) {
                String key = (String)entry.getKey();
                HashMap<String, String> mso = new HashMap<String, String>(16);
                if (entryentity != null && !entryentity.isEmpty()) {
                    for (DynamicObject map : entryentity) {
                        ILocaleString seriesName = (ILocaleString)((DynamicObject)map.get("seriesnames")).get("name");
                        if (!key.equals(seriesName.getLocaleValue())) continue;
                        mso.put("seriesname", key);
                        mso.put("charttype", String.valueOf(map.get("charttype")));
                        mso.put("datalabel", String.valueOf(map.get("datalabel")));
                        mso.put("secondyaxis", String.valueOf(map.get("secondyaxis")));
                        mso.put("color", String.valueOf(map.get("color")));
                        mso.put("checked", String.valueOf(map.get("checked")));
                        break;
                    }
                }
                if (mso.size() <= 0) continue;
                lso.add(mso);
            }
            this.option = lso;
        }
    }

    public void drawChartByFlex(IFormView view, String flexKey, ChartFastData chartFastData) {
        FormShowParameter showParameter = new FormShowParameter();
        if (this.isPie()) {
            showParameter.setFormId("qcqs_chartviewpie");
        } else {
            showParameter.setFormId("qcqs_chartview");
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("formKey", this.formKey);
        try {
            params.put("chartFastData", JSONUtils.toString((Object)chartFastData));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ChartTool_6", (String)"qmc-qcqs-common", (Object[])new Object[0]), e.getMessage())});
        }
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flexKey);
        view.showForm(showParameter);
    }

    private void pieInit() {
        this.sv.setVisible(Boolean.FALSE, new String[]{"customchartap"});
        Map<String, Number[]> series = this.chartFastData.getSeries();
        int s = 0;
        for (Map.Entry<String, Number[]> map : series.entrySet()) {
            String seriesName = map.getKey();
            Map<String, Object> optionMatch = this.optionMatch(seriesName);
            if (optionMatch == null || !Boolean.parseBoolean(optionMatch.get("checked").toString())) continue;
            CustomChart customchart = (CustomChart)this.sv.getControl(sa[s]);
            customchart.setShowLegend(false);
            Axis ys = customchart.createYAxis(null, AxisType.value);
            ys.setPropValue("show", (Object)Boolean.FALSE);
            Axis xs = customchart.createXAxis(null, AxisType.category);
            xs.setPropValue("show", (Object)Boolean.FALSE);
            PieSeries pieSeries = customchart.createPieSeries(map.getKey());
            String[] xaxisData = this.chartFastData.getXaxisData();
            int i = 0;
            BigDecimal sum = BigDecimal.ZERO;
            TreeMap<String, Number> m = new TreeMap<String, Number>();
            for (String xaxisName : xaxisData) {
                m.put(xaxisName, map.getValue()[i]);
                sum = sum.add(new BigDecimal(map.getValue()[i].toString()));
                ++i;
            }
            i = 0;
            Map<String, Object> descSortMap = ChartTool.getDescSortMap(m);
            for (Map.Entry en : (List)descSortMap.get("entry")) {
                if (i == 10 && ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_7", (String)"qmc-qcqs-common", (Object[])new Object[0]).equals(en.getKey())) {
                    this.myAddData(pieSeries, (String)en.getKey(), (Number)en.getValue(), "#C0C0C0");
                } else {
                    this.myAddData(pieSeries, (String)en.getKey(), (Number)en.getValue(), ChartSettingConst.getPieinitcolor()[i]);
                }
                ++i;
            }
            String myFomatter = String.format("function(a){ if(a.name=='%1$s'){return a.seriesName +'<br/>%2$s:<br/>'+a.value+'(" + descSortMap.get("otherPer") + "%%)'};if(a.value==0){return a.seriesName +'<br/>'+ a.name+':<br/>'+'0(0.00%%)';};return a.seriesName +'<br/>'+ a.name+':<br/>'+a.value+'('+Math.round(eval(a.value/" + sum + ") * 10000) / 100+'%%)'}", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]));
            String formatter = String.format("function(a){ if(a.name=='%1$s'){return a.seriesName +'<br/>%2$s:<br/>'+a.value+'('+a.percent+'%%)'};if(a.value==0){return a.seriesName +'<br/>'+ a.name+':<br/>'+'0(0.00%%)';};return a.seriesName +'<br/>'+ a.name+':<br/>'+a.value+'('+a.percent+'%%)'}", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]));
            if (this.formKey.equals("qcqs_insbadealrpt")) {
                customchart.addTooltip("formatter", (Object)myFomatter);
            } else {
                customchart.addTooltip("formatter", (Object)formatter);
            }
            customchart.addTooltip("position", (Object)"bottom");
            Label label = new Label();
            label.setShow(Boolean.parseBoolean(optionMatch.get("datalabel").toString()));
            String labelFormatter = "function(a){ if(a.value==0){return'0.00%';};return a.percent+'%'}";
            String myLabelFormatter = String.format("function(a){ if(a.value==0){return'0.00%%';};if(a.name=='%s'){return '" + descSortMap.get("otherPer") + "%%'};return Math.round(eval(a.value/" + sum + ") * 10000) / 100+'%%'}", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]));
            if (this.formKey.equals("qcqs_insbadealrpt")) {
                label.setFormatter(myLabelFormatter);
            } else {
                label.setFormatter(labelFormatter);
            }
            pieSeries.setLabel(label);
            ArrayList<String> funcPathList = new ArrayList<String>();
            funcPathList.add("tooltip.formatter");
            funcPathList.add("series.0.label.normal.formatter");
            funcPathList.add("legend.formatter");
            funcPathList.add("legend.tooltip.formatter");
            this.setFuncPath((Chart)customchart, funcPathList);
            customchart.setShowTooltip(true);
            customchart.setTitlePropValue("text", (Object)seriesName);
            customchart.setTitlePropValue("left", (Object)"center");
            customchart.setTitlePropValue("top", (Object)"85%");
            customchart.setShowTitle(this.showTitle);
            customchart.setShowLegend(this.showLegend);
            HashMap<String, String> tooltip = new HashMap<String, String>(16);
            tooltip.put("show", "true");
            String rs = "";
            if (descSortMap.get("other") != null) {
                rs = descSortMap.get("other").toString();
            }
            String str = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_8", (String)"qmc-qcqs-common", (Object[])new Object[0]);
            String legendTpFormatter = "function(a){ if(a.name.length==" + str.length() + 8 + "&&a.name=='" + str + "'){return '" + rs + "';};return a.name;}";
            tooltip.put("formatter", legendTpFormatter);
            customchart.setLegendPropValue("tooltip", tooltip);
            String legendFormatter = "function (name) {if(name.length==" + str.length() + 8 + "&&name=='" + str + "'){return '" + str + "';};if (!name) return '';if(name.length>" + this.maxLegendLength + "){return name.slice(0," + this.maxLegendLength + ") + '...';}else {return name;}}";
            customchart.setLegendPropValue("formatter", (Object)legendFormatter);
            customchart.setLegendVertical(true);
            customchart.setLegendPropValue("right", (Object)"-5");
            pieSeries.setPropValue("radius", (Object)"50%");
            pieSeries.setPropValue("startAngle", (Object)"60");
            pieSeries.setCenter("40%", "50%");
            this.sv.setVisible(Boolean.TRUE, new String[]{"customchartap" + ++s});
            if (s < 8) continue;
            break;
        }
    }

    private static Map<String, Object> getDescSortMap(TreeMap<String, Number> map) {
        HashMap<String, Object> rm = new HashMap<String, Object>(16);
        ArrayList<Map.Entry<String, Number>> lstEntry = new ArrayList<Map.Entry<String, Number>>(map.entrySet());
        Collections.sort(lstEntry, (e1, e2) -> {
            BigDecimal o1 = new BigDecimal(((Number)e1.getValue()).toString());
            BigDecimal o2 = new BigDecimal(((Number)e2.getValue()).toString());
            return o2.compareTo(o1);
        });
        ArrayList resultList = new ArrayList();
        if (lstEntry.size() > 10) {
            BigDecimal sum = BigDecimal.ZERO;
            ArrayList<Map.Entry> subList = new ArrayList<Map.Entry>();
            int i = 0;
            for (Map.Entry entry : lstEntry) {
                sum = sum.add(new BigDecimal(((Number)entry.getValue()).toString()));
                if (i >= 10) {
                    subList.add(entry);
                } else {
                    resultList.add(entry);
                }
                ++i;
            }
            BigDecimal otherSum = BigDecimal.ZERO;
            StringBuilder stringBuilder = new StringBuilder();
            int r = 0;
            BigDecimal otherSumPer = BigDecimal.ZERO;
            for (Map.Entry entry : subList) {
                otherSumPer = otherSumPer.add(new BigDecimal(((Number)entry.getValue()).toString()).multiply(new BigDecimal(100)).divide(sum, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                otherSum = otherSum.add(new BigDecimal(((Number)entry.getValue()).toString()));
                if (r < 9) {
                    stringBuilder.append(((String)entry.getKey()).replace('\n', ' '));
                    stringBuilder.append("<br>");
                } else if (r == 9) {
                    stringBuilder.append(((String)entry.getKey()).replace('\n', ' '));
                    stringBuilder.append("<br>......");
                }
                ++r;
            }
            rm.put("other", stringBuilder.toString());
            rm.put("otherPer", otherSumPer);
            TreeMap<String, BigDecimal> tmpmap = new TreeMap<String, BigDecimal>();
            tmpmap.put(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ChartTool_7", (String)"qmc-qcqs-common", (Object[])new Object[0]), otherSum);
            for (Map.Entry entry : tmpmap.entrySet()) {
                resultList.add(entry);
            }
            rm.put("entry", resultList);
        } else {
            rm.put("entry", lstEntry);
        }
        return rm;
    }

    public void showSetting(IFormPlugin plugin, IFormView view) {
        String formkey = view.getEntityId();
        DynamicObject[] setting = this.getSetting(formkey);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("qcqs_chartsetting");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("setting", setting);
        params.put("formkey", formkey);
        parameter.setCustomParams(params);
        String connStr = "qcqs_chartsetting";
        CloseCallBack closeCallBack = new CloseCallBack(plugin, connStr);
        parameter.setCloseCallBack(closeCallBack);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
    }

    public DynamicObject[] getSetting(String formkey) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String selectFields = "id,number,name,userid,xaxisselect,mulxaxisselect,checkbox,creator,rptflag,biztype,seqindex,schemtype,entryentity.seq,entryentity.seriesnames,entryentity.charttype,entryentity.color,entryentity.datalabel,entryentity.secondyaxis,entryentity.checked";
        QFilter filter = new QFilter("creator", "=", (Object)currentUserId);
        filter.and("issys", "=", (Object)false);
        filter.and("rptflag.number", "=", (Object)formkey);
        DynamicObject[] dc = BusinessDataServiceHelper.load((String)"qcqs_charsettingschem", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"seqindex");
        if (dc == null || dc.length == 0) {
            QFilter subFilter = new QFilter("issys", "=", (Object)true);
            subFilter.and(new QFilter("rptflag.number", "=", (Object)formkey));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"qcqs_charsettingschem", (String)selectFields, (QFilter[])new QFilter[]{subFilter});
            DynamicObject s = this.setNewObject(obj, currentUserId);
            dc = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{s});
        }
        return dc;
    }

    private String getCodeNumber() {
        QFilter filter1 = new QFilter("bizobjectid", "=", (Object)"qcqs_charsettingschem");
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        Boolean flag = QueryServiceHelper.exists((String)"bos_coderule", (QFilter[])new QFilter[]{filter1, filter2});
        String codeNumber = null;
        if (flag.booleanValue()) {
            Long currOrg = RequestContext.get().getOrgId();
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"qcqs_charsettingschem");
            codeNumber = CodeRuleServiceHelper.getNumber((String)"qcqs_charsettingschem", (DynamicObject)obj, (String)String.valueOf(currOrg));
        }
        return codeNumber;
    }

    private ILocaleString getObjectName(DynamicObject obj) {
        String formKey = this.sv.getEntityId();
        ILocaleString name = (ILocaleString)obj.get("name");
        return ChartUtil.getRptLocaleStringName(formKey, name);
    }

    private DynamicObject setNewObject(DynamicObject obj, long currentUserId) {
        DynamicObject s = BusinessDataServiceHelper.newDynamicObject((String)"qcqs_charsettingschem");
        s.set("creator", (Object)currentUserId);
        String number = this.getCodeNumber();
        s.set("number", (Object)number);
        ILocaleString returnName = this.getObjectName(obj);
        s.set("name", (Object)returnName);
        Long currOrg = RequestContext.get().getOrgId();
        s.set("createorg", (Object)currOrg);
        s.set("status", (Object)"C");
        s.set("enable", (Object)"1");
        s.set("useorg", (Object)currOrg);
        s.set("ctrlstrategy", (Object)"7");
        s.set("rptflag", obj.get("rptflag"));
        s.set("issys", (Object)false);
        s.set("xaxisselect", obj.get("xaxisselect"));
        s.set("mulxaxisselect", obj.get("mulxaxisselect"));
        s.set("checkbox", obj.get("checkbox"));
        s.set("seqindex", (Object)1);
        DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection mycol = s.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : col) {
            DynamicObject entry = new DynamicObject(mycol.getDynamicObjectType());
            entry.set("seq", dyn.get("seq"));
            entry.set("seriesnames", (Object)((DynamicObject)dyn.get("seriesnames")));
            entry.set("charttype", dyn.get("charttype"));
            entry.set("color", dyn.get("color"));
            entry.set("datalabel", dyn.get("datalabel"));
            entry.set("secondyaxis", dyn.get("secondyaxis"));
            entry.set("checked", dyn.get("checked"));
            mycol.add((Object)entry);
        }
        s.set("entryentity", (Object)mycol);
        return s;
    }

    private void initXAxis(Chart customchart) {
        Map<String, Object> optionMatch;
        String seriesName;
        boolean showAxis = false;
        Axis x = customchart.createXAxis(null, AxisType.category);
        String[] xaxisData = this.chartFastData.getXaxisData();
        x.setPropValue("data", (Object)xaxisData);
        HashMap<String, Object> xs = new HashMap<String, Object>(16);
        xs.put("interval", 0);
        xs.put("showMinLabel", Boolean.TRUE);
        xs.put("showMaxLabel", Boolean.TRUE);
        String dataFormatter = "function(itemValue, index) {var result = '';var arr = itemValue.split('\\n');for (var i = 0; i < (arr.length > 2? 2 : arr.length); i++) {var v = arr[i].substring(0, " + this.maxXlength + ") + '...';var vt = arr[i].length > " + this.maxXlength + " ? v : arr[i];result = result + '\\n' + vt;}if(arr.length > 3){result = result + '...';} return result.substring(1);}";
        xs.put("formatter", dataFormatter);
        x.setPropValue("axisLabel", xs);
        ArrayList<String> funcPathList = new ArrayList<String>();
        funcPathList.add("xAxis.0.axisLabel.formatter");
        this.setFuncPath(customchart, funcPathList);
        Map<String, Number[]> series = this.chartFastData.getSeries();
        ArrayList<Map.Entry<String, Object>> bel = new ArrayList<Map.Entry<String, Object>>();
        ArrayList<Map.Entry<String, Number[]>> lel = new ArrayList<Map.Entry<String, Number[]>>();
        for (Map.Entry<String, Number[]> entry : series.entrySet()) {
            seriesName = entry.getKey();
            optionMatch = this.optionMatch(seriesName);
            if (optionMatch == null || !Boolean.parseBoolean(optionMatch.get("checked").toString())) continue;
            if ("A".equals(optionMatch.get("charttype").toString())) {
                bel.add(entry);
                continue;
            }
            if (!"B".equals(optionMatch.get("charttype").toString())) continue;
            lel.add(entry);
        }
        bel.addAll(lel);
        for (Map.Entry<String, Object> entry : bel) {
            seriesName = entry.getKey();
            optionMatch = this.optionMatch(seriesName);
            if (optionMatch == null || !Boolean.parseBoolean(optionMatch.get("checked").toString())) continue;
            BarSeries s = null;
            if ("A".equals(optionMatch.get("charttype").toString())) {
                s = customchart.createBarSeries(entry.getKey());
            } else if ("B".equals(optionMatch.get("charttype").toString())) {
                s = customchart.createLineSeries(entry.getKey());
            } else {
                return;
            }
            Number[] data = (Number[])entry.getValue();
            ItemValue[] il = new ItemValue[data.length];
            int i = 0;
            if (data.length != 0) {
                for (Number number : data) {
                    ItemValue is;
                    il[i] = is = new ItemValue(number, null);
                    ++i;
                }
                showAxis = true;
            }
            s.setData(il);
            Label label = new Label();
            label.setShow(Boolean.parseBoolean(optionMatch.get("datalabel").toString()));
            if (Boolean.parseBoolean(optionMatch.get("secondyaxis").toString())) {
                s.setPropValue("yAxisIndex", (Object)1);
                label.setFormatter("{c} %");
                s.setPropValue("valueType", (Object)"percent");
            }
            s.setItemColor(optionMatch.get("color").toString());
            s.setLabel(label);
            if (data.length < 6) {
                s.setPropValue("barMaxWidth", (Object)(10 + data.length * 2 + "%"));
                continue;
            }
            s.setPropValue("barMaxWidth", (Object)this.barMaxWidth);
        }
        if (!showAxis) {
            x.setPropValue("show", (Object)Boolean.FALSE);
        }
        this.initYAxis(customchart, showAxis);
    }

    private void initYAxis(Chart customchart, boolean showYAxis) {
        Axis ym = customchart.createYAxis(null, AxisType.value);
        ym.setPropValue("type", (Object)"value");
        ArrayList<String> sl = new ArrayList<String>();
        sl.add("0%");
        sl.add("5%");
        ym.setPropValue("boundaryGap", sl);
        ArrayList<String> funcPathList = new ArrayList<String>();
        funcPathList.add("yAxis.0.max");
        this.setFuncPath(customchart, funcPathList);
        Axis ys = customchart.createYAxis(null, AxisType.value);
        HashMap<String, String> fs = new HashMap<String, String>(16);
        String dataFormatter = "{value} %";
        fs.put("formatter", dataFormatter);
        ys.setPropValue("axisLabel", fs);
        ys.setPropValue("max", (Object)120);
        if (!showYAxis) {
            ym.setPropValue("show", (Object)Boolean.FALSE);
            ys.setPropValue("show", (Object)Boolean.FALSE);
        }
    }

    private void setFuncPath(Chart customChart, List<String> funcPathList) {
        if (funcPathList != null && !funcPathList.isEmpty()) {
            for (String funcPath : funcPathList) {
                String[] split = funcPath.split("\\.");
                ArrayList<String> fp = new ArrayList<String>(Arrays.asList(split));
                customChart.addFuncPath(fp);
            }
        }
    }

    public void myAddData(PieSeries pieSeries, String name, Number value, String color) {
        ArrayList datas = pieSeries.getData();
        if (datas == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = cl.loadClass("kd.bos.form.chart.Series");
                Field field = clazz.getDeclaredField("values");
                AccessibleObject[] colorAcce = new AccessibleObject[]{field};
                AccessibleObject.setAccessible(colorAcce, true);
                datas = new ArrayList(16);
                Map values = (Map)field.get(pieSeries);
                values.put("data", datas);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.actionClassNotFound, new Object[]{String.format(ResManager.loadKDString((String)"\u7c7b\u8bbf\u95ee\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:%s\u3002", (String)"ChartTool_0", (String)"qmc-qcqs-common", (Object[])new Object[0]), e.getMessage())});
            }
        }
        HashMap<String, Object> val = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((String)name)) {
            val.put("name", name);
        } else {
            val.put("name", " ");
        }
        val.put("value", value);
        if (!StringUtils.isEmpty((String)color)) {
            HashMap style = new HashMap(16);
            HashMap<String, String> normalMap = new HashMap<String, String>(16);
            normalMap.put("color", color);
            style.put("normal", normalMap);
            val.put("itemStyle", style);
        }
        datas.add(val);
    }
}

