/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;

public class InsRptCommonQueryUtil {
    public static DataSet DataSetquerySortDeal(ReportQueryParam param, DataSet dealResult, String mulcounttype, String[] fields, Map<Integer, Integer[]> hideMap) {
        String sortInfo = null;
        List headQFilter = param.getFilter().getHeadFilters();
        String expr = InsRptCommonQueryUtil.rebuildHeadQFilter(headQFilter, mulcounttype, fields, hideMap);
        if (!headQFilter.isEmpty() && StringUtils.isNotEmpty((CharSequence)expr)) {
            dealResult = dealResult.where(expr);
        }
        if (param.getSortInfo() != null) {
            sortInfo = param.getSortInfo();
            String replace = sortInfo.replace(" desc", "").replace(" asc", "");
            if (!InsRptCommonQueryUtil.getHideFields(mulcounttype, fields, hideMap).contains(replace)) {
                sortInfo = sortInfo.replace("insqtystr", "insqty");
                sortInfo = sortInfo.replace("quaqtystr", "quaqty");
                sortInfo = sortInfo.replace("unquaqtystr", "unquaqty");
                sortInfo = sortInfo.replace("rptyear", "year");
                sortInfo = sortInfo.replace("rptmonth", "month");
                dealResult = dealResult.orderBy(new String[]{sortInfo});
            }
        }
        return dealResult;
    }

    public static List<String> getHideFields(String mulcounttype, String[] fields, Map<Integer, Integer[]> hideMap) {
        List<String> mulcounttypeList = Arrays.asList(mulcounttype.split(","));
        ArrayList<String> hideFields = new ArrayList<String>(fields.length);
        for (Map.Entry<Integer, Integer[]> entry : hideMap.entrySet()) {
            if (mulcounttypeList.contains(entry.getKey().toString())) continue;
            for (Integer i : entry.getValue()) {
                hideFields.add(fields[i]);
            }
        }
        if (mulcounttypeList.contains("3")) {
            hideFields.add("rptyear");
            hideFields.add("rptmonth");
        }
        return hideFields;
    }

    public static String rebuildHeadQFilter(List<QFilter> headQFilter, String mulcounttype, String[] fields, Map<Integer, Integer[]> hideMap) {
        String expr = "";
        List<String> asList = Arrays.asList("orgno", "supplyorgno", "supplierno", "matgrono", "materialno", "subinspectorno", "baseunit", "oprworkshopno", "oprworkcenterno", "productionworkshopno", "oproperationno");
        if (!headQFilter.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (QFilter qFilter : headQFilter) {
                String property = qFilter.getProperty();
                if (InsRptCommonQueryUtil.getHideFields(mulcounttype, fields, hideMap).contains(property)) continue;
                if (asList.contains(property)) {
                    qFilter.__setProperty(property + "v");
                }
                String string = qFilter.toString();
                if ((property.indexOf("bat") != -1 || property.indexOf("pro") != -1 || property.indexOf("ppm") != -1 || "insqty".equals(property) || "quaqty".equals(property) || "unquaqty".equals(property)) && !property.contains("oproperation") && !property.contains("productionworkshop")) {
                    string = qFilter.toString().replace("'", "");
                }
                sb.append(" and ");
                sb.append(string);
            }
            expr = sb.length() == 0 ? "" : sb.substring(5);
        }
        return expr;
    }

    public static String formatQtyString(String qtyString) {
        int indexOf = qtyString.indexOf(46);
        StringBuilder sb = new StringBuilder(qtyString);
        indexOf = indexOf > 0 ? (indexOf -= 3) : qtyString.length() - 3;
        while (indexOf > 0) {
            sb.insert(indexOf, ',');
            indexOf -= 3;
        }
        return sb.toString();
    }

    public static String[] getSortMulcounttype(String[] mulcounttype) {
        ArrayList<String> sl = new ArrayList<String>();
        boolean dateCheck = false;
        for (String s : mulcounttype) {
            if ("".equals(s)) continue;
            sl.add(s);
            if (!"3".equals(s)) continue;
            dateCheck = true;
        }
        if (dateCheck) {
            sl.remove("2");
            sl.remove("1");
        }
        mulcounttype = sl.toArray(new String[sl.size()]);
        Arrays.sort(mulcounttype, (e1, e2) -> {
            int i1 = Integer.parseInt(e1);
            int i2 = Integer.parseInt(e2);
            return i1 - i2;
        });
        return mulcounttype;
    }

    public static String stringCheck(Object string) {
        if (string == null) {
            return "";
        }
        return string.toString();
    }

    public static Long longCheck(Long l) {
        if (l == 0L) {
            return null;
        }
        return l;
    }

    public static BigDecimal tagRateCheck(Object object) {
        if (object == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(object.toString());
    }
}

