/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.formplugin.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcqs.common.chart.ChartTool;
import kd.qmc.qcqs.common.chart.ChartUtil;

public class ChartSettingPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String SETTINGOPERATION = "settingoperation";
    private static final String ROWINDEX = "rowIndex";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (ChartUtil.valueCheck((Object)newValue, (Object)oldValue)) continue;
            return;
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        Map params = formParamter.getCustomParams();
        model.setValue("constmapkey", params.get("constmapkey"));
        List o = (List)params.get("setting");
        for (Object to : o) {
            if (to == null) continue;
            Map map = (Map)to;
            int i = model.createNewEntryRow("entryentity");
            model.setValue("checked", map.get("checkbox"), i);
            Map locMap = (Map)map.get("name");
            String strName = this.dealMulLanguage(locMap);
            model.setValue("settingname", (Object)strName, i);
            model.setValue("formkey", ((Map)map.get("rptflag")).get("number"), i);
            model.setValue("userid", map.get("creator"), i);
            model.setValue("number", map.get("number"), i);
            String settingdetail_tag = ChartUtil.dynToJson((Map)map);
            model.setValue("settingdetail_tag", (Object)settingdetail_tag, i);
        }
    }

    private String dealMulLanguage(Map<String, Object> locMap) {
        String strName = null;
        for (Map.Entry<String, Object> entry : locMap.entrySet()) {
            String key = entry.getKey();
            if (!Lang.get().name().equals(key)) continue;
            strName = String.valueOf(locMap.get(key));
            break;
        }
        if (null == strName) {
            strName = String.valueOf(locMap.get("zh_CN"));
        }
        return strName;
    }

    private void showFormSetting(Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("qcqs_csdetail");
        String connStr = "qcqs_csdetail";
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, connStr);
        if (params != null) {
            showParameter.setCustomParams(params);
        }
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String rd;
        IDataModel model = this.getModel();
        if (closedCallBackEvent == null) {
            return;
        }
        String connStr = closedCallBackEvent.getActionId();
        if (StringUtils.isEmpty((String)connStr)) {
            return;
        }
        if ("qcqs_csdetail".equals(connStr) && (rd = (String)closedCallBackEvent.getReturnData()) != null) {
            try {
                Map m = (Map)JSONUtils.cast((String)rd, Map.class);
                Integer rowIndex = Integer.parseInt(m.get(ROWINDEX).toString());
                String str = JSONUtils.toString(m.get("data"));
                model.setValue("settingdetail_tag", (Object)str, rowIndex.intValue());
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ChartSettingPlugin_0", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]), e.getMessage())});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IDataModel model = this.getModel();
        if ("ok".equals(evt.getItemKey())) {
            FormShowParameter formParamter = this.getView().getFormShowParameter();
            Map params = formParamter.getCustomParams();
            String formkey = params.get("formkey").toString();
            ChartTool chartTool = new ChartTool(this.getView().getParentView(), formkey);
            DynamicObject[] settings = chartTool.getSetting(formkey);
            ArrayList<Long> idSetList = new ArrayList<Long>(10);
            for (DynamicObject oo : settings) {
                idSetList.add(oo.getLong("id"));
            }
            DynamicObject[] setting = BusinessDataServiceHelper.load((Object[])idSetList.toArray(new Long[idSetList.size()]), (DynamicObjectType)settings[0].getDynamicObjectType());
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            Map<String, Object> map = null;
            if (entryEntity == null || entryEntity.isEmpty()) {
                ArrayList<Object> arrList = new ArrayList<Object>(16);
                for (DynamicObject dyn : setting) {
                    arrList.add(dyn.getPkValue());
                }
                DeleteServiceHelper.delete((IDataEntityType)setting[0].getDynamicObjectType(), (Object[])arrList.toArray(new Object[arrList.size()]));
            } else {
                map = this.doSchemSaveObject(setting, entryEntity);
            }
            if (null != map) {
                ArrayList seqList = (ArrayList)map.get("seqList");
                if (seqList.size() > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u6790\u56fe\u8bbe\u7f6e\u7b2c%s\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChartSettingPlugin_1", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]), seqList.toString()));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection updateCol = (DynamicObjectCollection)map.get("updateCol");
                SaveServiceHelper.update((DynamicObject[])((DynamicObject[])updateCol.toArray((Object[])new DynamicObject[updateCol.size()])));
                DynamicObjectCollection addCol = (DynamicObjectCollection)map.get("addCol");
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])addCol.toArray((Object[])new DynamicObject[addCol.size()])));
                DynamicObjectCollection delCol = (DynamicObjectCollection)map.get("delCol");
                if (delCol.size() > 0) {
                    ArrayList<Long> idList = new ArrayList<Long>(16);
                    for (DynamicObject dyn : delCol) {
                        idList.add(dyn.getLong("id"));
                    }
                    DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)delCol.get(0)).getDynamicObjectType(), (Object[])idList.toArray(new Object[idList.size()]));
                }
            }
            model.setDataChanged(false);
            this.getView().close();
        }
    }

    private Map<String, Object> doSchemSaveObject(DynamicObject[] setting, DynamicObjectCollection entryEntity) {
        ArrayList<String> entryNum = new ArrayList<String>(16);
        for (DynamicObject dyn : entryEntity) {
            entryNum.add(dyn.getString("number"));
        }
        DynamicObjectCollection updateCol = new DynamicObjectCollection();
        DynamicObjectCollection addCol = new DynamicObjectCollection();
        DynamicObjectCollection delCol = new DynamicObjectCollection();
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        for (DynamicObject dyn : entryEntity) {
            for (DynamicObject obj : setting) {
                if (!obj.getString("number").equals(dyn.getString("number"))) continue;
                if (StringUtils.isEmpty((String)dyn.getString("settingname"))) {
                    seqList.add(dyn.getInt("seq"));
                    continue;
                }
                DynamicObject updatObj = this.dealObjectSetValue(obj, dyn);
                updateCol.add((Object)updatObj);
            }
        }
        for (DynamicObject dyn : entryEntity) {
            if (!StringUtils.isEmpty((String)dyn.getString("number"))) continue;
            if (StringUtils.isEmpty((String)dyn.getString("settingname"))) {
                seqList.add(dyn.getInt("seq"));
                continue;
            }
            DynamicObject dynj = this.dealSaveObj(dyn);
            addCol.add((Object)dynj);
        }
        for (DynamicObject dyn : setting) {
            if (!StringUtils.isNotEmpty((String)dyn.getString("number")) || entryNum.contains(dyn.getString("number"))) continue;
            delCol.add((Object)dyn);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("updateCol", updateCol);
        map.put("addCol", addCol);
        map.put("delCol", delCol);
        map.put("seqList", seqList);
        return map;
    }

    private String getCodeNumber() {
        QFilter filter1 = new QFilter("bizobjectid", "=", (Object)"qcqs_charsettingschem");
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        Boolean flag = QueryServiceHelper.exists((String)"bos_coderule", (QFilter[])new QFilter[]{filter1, filter2});
        String codeNumber = null;
        if (flag.booleanValue()) {
            Long currOrg = RequestContext.get().getOrgId();
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"qcqs_charsettingschem");
            codeNumber = CodeRuleServiceHelper.getNumber((String)"qcqs_charsettingschem", (DynamicObject)obj, (String)String.valueOf(currOrg));
        }
        return codeNumber;
    }

    private DynamicObject dealSaveObj(DynamicObject dyn) {
        DynamicObject s = BusinessDataServiceHelper.newDynamicObject((String)"qcqs_charsettingschem");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        s.set("seqindex", dyn.get("seq"));
        s.set("creator", (Object)currentUserId);
        String number = this.getCodeNumber();
        s.set("number", (Object)number);
        LocaleString locName = new LocaleString(dyn.getString("settingname"));
        s.set("name", (Object)locName);
        Long currOrg = RequestContext.get().getOrgId();
        s.set("createorg", (Object)currOrg);
        s.set("status", (Object)"C");
        s.set("enable", (Object)"1");
        s.set("useorg", (Object)currOrg);
        s.set("ctrlstrategy", (Object)"7");
        String formkey = this.getView().getParentView().getEntityId();
        DynamicObject entityObj = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formkey)});
        if (null != entityObj) {
            s.set("rptflag", entityObj.get("id"));
        }
        s.set("issys", (Object)false);
        s.set("checkbox", dyn.get("checked"));
        if (StringUtils.isEmpty((String)dyn.getString("settingdetail_tag"))) {
            return null;
        }
        Map ml = null;
        try {
            ml = (Map)JSONUtils.cast((String)dyn.getString("settingdetail_tag"), Map.class);
        }
        catch (IOException e1) {
            throw new KDException((Throwable)e1, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ChartSettingPlugin_0", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]), e1.getMessage())});
        }
        if (null != ml) {
            String value = null;
            if (null != ml.get("xaxisselect")) {
                value = this.slpitSym(ml.get("xaxisselect").toString());
            }
            String mulvalue = null;
            if (null != ml.get("mulxaxisselect")) {
                mulvalue = this.slpitSym(ml.get("mulxaxisselect").toString());
            }
            s.set("xaxisselect", (Object)value);
            s.set("mulxaxisselect", (Object)mulvalue);
            List col = (List)ml.get("entryentity");
            DynamicObjectCollection mycol = s.getDynamicObjectCollection("entryentity");
            for (Map dynj : col) {
                DynamicObject entry = new DynamicObject(mycol.getDynamicObjectType());
                entry.set("seq", dynj.get("seq"));
                entry.set("seriesnames", dynj.get("seriesnames"));
                entry.set("charttype", dynj.get("charttype"));
                entry.set("color", dynj.get("color"));
                entry.set("datalabel", dynj.get("datalabel"));
                entry.set("secondyaxis", dynj.get("secondyaxis"));
                entry.set("checked", dynj.get("checked"));
                mycol.add((Object)entry);
            }
            s.set("entryentity", (Object)mycol);
        }
        return s;
    }

    private DynamicObject dealObjectSetValue(DynamicObject obj, DynamicObject dyn) {
        obj.set("seqindex", dyn.get("seq"));
        LocaleString posie = new LocaleString(dyn.getString("settingname"));
        obj.set("name", (Object)posie);
        String tag = dyn.getString("settingdetail_tag");
        Map ml = null;
        try {
            ml = (Map)JSONUtils.cast((String)tag, Map.class);
        }
        catch (IOException e1) {
            throw new KDException((Throwable)e1, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ChartSettingPlugin_0", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]), e1.getMessage())});
        }
        String value = null;
        if (null != ml.get("xaxisselect")) {
            value = this.slpitSym(ml.get("xaxisselect").toString());
        }
        String mulvalue = null;
        if (null != ml.get("mulxaxisselect")) {
            mulvalue = this.slpitSym(ml.get("mulxaxisselect").toString());
        }
        obj.set("xaxisselect", (Object)value);
        obj.set("mulxaxisselect", (Object)mulvalue);
        List entryList = (List)ml.get("entryentity");
        DynamicObjectCollection objEntry = obj.getDynamicObjectCollection("entryentity");
        for (Map map : entryList) {
            for (DynamicObject ojbk : objEntry) {
                String mapSeriesId;
                String objSeriesId = String.valueOf(((DynamicObject)ojbk.get("seriesnames")).getPkValue());
                if (!objSeriesId.equals(mapSeriesId = String.valueOf(map.get("seriesnames")))) continue;
                ojbk.set("charttype", map.get("charttype"));
                ojbk.set("color", map.get("color"));
                ojbk.set("datalabel", map.get("datalabel"));
                ojbk.set("secondyaxis", map.get("secondyaxis"));
                ojbk.set("checked", map.get("checked"));
            }
        }
        obj.set("entryentity", (Object)objEntry);
        return obj;
    }

    private String slpitSym(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            int length = value.length();
            if (',' == value.charAt(0) && ',' == value.charAt(length - 1)) {
                value = value.substring(1, length - 1);
                return value;
            }
        } else {
            return value;
        }
        return value;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int i = e.getRowDataEntities()[0].getRowIndex();
        String formkey = this.getView().getParentView().getEntityId();
        String rptName = this.getSettingname(formkey);
        this.getModel().setValue("settingname", (Object)rptName, i);
        String selectFields = "id,number,name,userid,xaxisselect,mulxaxisselect,checkbox,creator,rptflag,biztype,entryentity.seq,entryentity.seriesnames,entryentity.charttype,entryentity.color,entryentity.datalabel,entryentity.secondyaxis,entryentity.checked";
        QFilter subFilter = new QFilter("issys", "=", (Object)true);
        subFilter.and(new QFilter("rptflag.number", "=", (Object)formkey));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"qcqs_charsettingschem", (String)selectFields, (QFilter[])new QFilter[]{subFilter});
        String detailTag = ChartUtil.objectToString((DynamicObject)obj);
        this.getModel().setValue("settingdetail_tag", (Object)detailTag, i);
    }

    private String getSettingname(String formKey) {
        String rptName = ChartUtil.getRptName((String)formKey, (String)"");
        return rptName;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
        int[] rows = e.getRowIndexs();
        if (entryCol.size() == 1 || entryCol.size() == rows.length) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u65b9\u6848\u3002", (String)"ChartSettingPlugin_3", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]));
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        IDataModel model = this.getModel();
        int row = cellClickEvent.getRow();
        String fieldName = cellClickEvent.getFieldKey();
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        Map p = formParamter.getCustomParams();
        String formkey = p.get("formkey").toString();
        if (SETTINGOPERATION.equals(fieldName)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put(ROWINDEX, row);
            params.put("formkey", formkey);
            params.put("data", model.getValue("settingdetail_tag", row));
            params.put("constmapkey", model.getValue("constmapkey"));
            this.showFormSetting(params);
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

