/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcqs.formplugin.chart;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ColorUtils;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;

public class ColorSelectPlugin
extends AbstractFormPlugin {
    private static final String ENTITY = "qcqs_colorselect";
    private static final String COLOR_FLEX = "colorflex";
    private static final String BTN_OK = "btnok";
    private static final String COLOR_VALUE = "colorvalue";
    private static final String CACHEKEY_COLOR = "color";
    private static final String ALPHA = "alpha";
    private static final String BACK_COLOR = "backcolor";

    public void afterCreateNewData(EventObject e) {
        try {
            int row = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("row").toString());
            this.getModel().setValue("row", (Object)row);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ColorSelectPlugin_0", (String)"qmc-qcqs-formplugin", (Object[])new Object[0]), ex.getMessage())});
        }
        Object customParam = this.getView().getFormShowParameter().getCustomParam(CACHEKEY_COLOR);
        if (Objects.nonNull(customParam)) {
            String colorStr = (String)customParam;
            if (StringUtils.startsWith((CharSequence)colorStr, (CharSequence)"rgba")) {
                colorStr = colorStr.substring(5, colorStr.length() - 1);
                String[] split = StringUtils.split((String)colorStr, (String)",");
                int red = Integer.parseInt(split[0]);
                int green = Integer.parseInt(split[1]);
                int blue = Integer.parseInt(split[2]);
                Color color = new Color(red, green, blue);
                ColorUtils colorUtils = new ColorUtils();
                colorStr = colorUtils.toHexFromColor(color);
                String alphaStr = split[3];
                int alpha = new BigDecimal(alphaStr).multiply(new BigDecimal("100")).intValue();
                this.getModel().setValue(ALPHA, (Object)alpha);
            }
            this.getModel().setValue(COLOR_VALUE, (Object)colorStr);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormRoot rootControl = (FormRoot)this.getView().getRootControl();
        for (Control item : rootControl.getItems()) {
            if (!StringUtils.equals((CharSequence)COLOR_FLEX, (CharSequence)item.getKey())) continue;
            Container container = (Container)item;
            for (Control containerItem : container.getItems()) {
                Label label = (Label)containerItem;
                label.addClickListener((ClickListener)this);
            }
        }
        Button button = (Button)this.getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control instanceof Label) {
            Map<String, String> colorMap = this.getColorMap();
            if (colorMap.isEmpty()) {
                this.setColorCache(colorMap);
            }
            String color = colorMap.get(control.getKey());
            this.getModel().setValue(COLOR_VALUE, (Object)color);
        } else if (control instanceof Button) {
            int alpha = (Integer)this.getModel().getValue(ALPHA);
            String colorStr = (String)this.getModel().getValue(COLOR_VALUE);
            if (alpha < 100) {
                double pellucidity = new BigDecimal(String.valueOf((float)alpha / 100.0f)).setScale(2, 4).doubleValue();
                ColorUtils colorUtils = new ColorUtils();
                Color color = colorUtils.toColorFromString(colorStr);
                colorStr = "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + pellucidity + ")";
            }
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put(CACHEKEY_COLOR, colorStr);
            r.put("row", this.getModel().getValue("row"));
            this.getView().returnDataToParent(r);
            this.getView().close();
        }
    }

    private void setColorCache(Map<String, String> colorMap) {
        String entityId = MetadataDao.getIdByNumber((String)ENTITY, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        for (ControlAp item : formMetadata.getItems()) {
            colorMap.put(item.getKey(), item.getBackColor());
            System.out.println("-----" + item.getWidth());
        }
        this.getPageCache().put(CACHEKEY_COLOR, SerializationUtils.toJsonString(colorMap));
    }

    private Map<String, String> getColorMap() {
        String json = this.getPageCache().get(CACHEKEY_COLOR);
        return StringUtils.isBlank((CharSequence)json) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)json, Map.class);
    }
}

