/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.common.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Base64Utils;

public class RSAHelper {
    private static final Log logger = LogFactory.getLog(RSAHelper.class);
    public static final String CHARSET = "utf-8";
    public static final int KEY_SIZE = 2048;

    public static Map<String, String> getKeyPair() {
        return RSAHelper.getKeyPair(2048);
    }

    public static Map<String, String> getKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPrivateKey oraprivateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey orapublicKey = (RSAPublicKey)keyPair.getPublic();
            HashMap<String, String> pairInfo = new HashMap<String, String>();
            byte[] publicKeybyte = orapublicKey.getEncoded();
            Base64 base64 = new Base64();
            String publicKeyString = base64.encodeToString(publicKeybyte);
            pairInfo.put("publicKey", publicKeyString);
            byte[] privateKeybyte = oraprivateKey.getEncoded();
            String privateKeyString = base64.encodeToString(privateKeybyte);
            pairInfo.put("privateKey", privateKeyString);
            return pairInfo;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static PublicKey getPublicKey(String publicKeyBase64) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Base64 base64 = new Base64();
        X509EncodedKeySpec publicpkcs8KeySpec = new X509EncodedKeySpec(base64.decode(publicKeyBase64));
        PublicKey publicKey = keyFactory.generatePublic(publicpkcs8KeySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String privateKeyBase64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Base64 base64 = new Base64();
        PKCS8EncodedKeySpec privatekcs8KeySpec = new PKCS8EncodedKeySpec(base64.decode(privateKeyBase64));
        PrivateKey privateKey = keyFactory.generatePrivate(privatekcs8KeySpec);
        return privateKey;
    }

    public static String encipher(String content, String publicKeyBase64) {
        return RSAHelper.encipher(content, publicKeyBase64, 200);
    }

    private static String encipher(String content, String publicKeyBase64, int segmentSize) {
        try {
            PublicKey publicKey = RSAHelper.getPublicKey(publicKeyBase64);
            return RSAHelper.encipher(content, publicKey, segmentSize);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private static String encipher(String ciphertext, Key key, int segmentSize) {
        try {
            byte[] srcBytes = ciphertext.getBytes("UTF-8");
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
            cipher.init(1, key);
            byte[] resultBytes = null;
            resultBytes = segmentSize > 0 ? RSAHelper.cipherDoFinal(cipher, srcBytes, segmentSize) : cipher.doFinal(srcBytes);
            String base64Str = Base64Utils.encodeToString((byte[])resultBytes);
            return base64Str;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static byte[] cipherDoFinal(Cipher cipher, byte[] srcBytes, int segmentSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        if (segmentSize <= 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5206\u6bb5\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0", (String)"RSAHelper_0", (String)"rpac-rpacp-common", (Object[])new Object[0]));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int inputLen = srcBytes.length;
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > segmentSize ? cipher.doFinal(srcBytes, offSet, segmentSize) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * segmentSize;
        }
        byte[] data = out.toByteArray();
        out.close();
        return data;
    }

    public static String decipher(String contentBase64, String privateKeyBase64) {
        return RSAHelper.decipher(contentBase64, privateKeyBase64, 256);
    }

    public static String decipher(String contentBase64, String privateKeyBase64, int segmentSize) {
        try {
            PrivateKey privateKey = RSAHelper.getPrivateKey(privateKeyBase64);
            return RSAHelper.decipher(contentBase64, privateKey, segmentSize);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String decipher(String contentBase64, Key key, int segmentSize) {
        try {
            byte[] srcBytes = Base64Utils.decodeFromString((String)contentBase64);
            Cipher deCipher = Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
            deCipher.init(2, key);
            byte[] decBytes = null;
            decBytes = segmentSize > 0 ? RSAHelper.cipherDoFinal(deCipher, srcBytes, segmentSize) : deCipher.doFinal(srcBytes);
            String decrytStr = new String(decBytes, "UTF-8");
            return decrytStr;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String sign(String data, String privateKeyValue) {
        try {
            PrivateKey privateKey = RSAHelper.getPrivateKey(privateKeyValue);
            byte[] keyBytes = privateKey.getEncoded();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(key);
            signature.update(data.getBytes(CHARSET));
            return new String(Base64.encodeBase64((byte[])signature.sign()), CHARSET);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static boolean verify(String srcData, String publicKeyValue, String sign) {
        try {
            PublicKey publicKey = RSAHelper.getPublicKey(publicKeyValue);
            byte[] keyBytes = publicKey.getEncoded();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(key);
            signature.update(srcData.getBytes(CHARSET));
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes(CHARSET)));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }
}

