/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.common.utils;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class IsrpaSignUtil {
    private static final Log logger = LogFactory.getLog(IsrpaSignUtil.class);

    public static String genPOSTSignatureStr(Map<String, Object> param, String accessToken, String timestamp) throws KDException {
        String str = IsrpaSignUtil.resortPOSTStrSite(param, timestamp);
        if (StringUtils.isEmpty((CharSequence)str)) {
            logger.error("\u6784\u9020\u6e90\u4e32\u5931\u8d25.generate source string error");
            return null;
        }
        return IsrpaSignUtil.generateSignatureStr(str, accessToken);
    }

    private static String resortPOSTStrSite(Map<String, Object> param, String timestamp) throws KDException {
        if (StringUtils.isEmpty((CharSequence)timestamp)) {
            logger.error("\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a...");
            throw new KDException(new ErrorCode("500", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a", (String)"IsrpaSignUtil_0", (String)"rpac-rpacp-common", (Object[])new Object[0])), new Object[0]);
        }
        String str = IsrpaSignUtil.getPostParamStr(param);
        StringBuilder sb = new StringBuilder(!StringUtils.isEmpty((CharSequence)str) ? str.concat("&") : "");
        return sb.append("timestamp=").append(timestamp).toString();
    }

    public static String getPostParamStr(Map<String, Object> param) {
        String s = !CollectionUtils.isEmpty(param) ? IsrpaSignUtil.sortMap(param) : "";
        logger.info("\u53c2\u6570\u6392\u5e8f\u540e:" + s);
        return s;
    }

    private static String sortMap(Map<String, Object> param) {
        TreeMap<String, Object> paramTreeMap = new TreeMap<String, Object>(param);
        String s = JSON.toJSONString(paramTreeMap);
        return s;
    }

    private static String generateSignatureStr(String str, String accessToken) throws KDException {
        try {
            logger.info("\u62fc\u63a5\u7684\u5b57\u7b26\u4e32\uff1a" + str);
            String encodeStr = IsrpaSignUtil.UrlEncodeSpecial(str);
            if (StringUtils.isEmpty((CharSequence)encodeStr)) {
                logger.error("url encode \u5931\u8d25...urlencode error.");
                throw new KDException(new ErrorCode("500", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"IsrpaSignUtil_1", (String)"rpac-rpacp-common", (Object[])new Object[0])), new Object[0]);
            }
            logger.info("\u52a0\u7b7e\u524d\u7684\u5b57\u7b26\u4e32\uff1a" + encodeStr + ",accessToken:" + accessToken);
            String sha256Str = IsrpaSignUtil.HMACSHA256StrByKey(encodeStr, accessToken);
            logger.info("HMACSHA256StrByKey\u7ed3\u679c:" + sha256Str);
            if (StringUtils.isEmpty((CharSequence)sha256Str)) {
                logger.error("sha256\u52a0\u5bc6\u5931\u8d25\uff0csha256 error.");
                throw new KDException(new ErrorCode("500", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"IsrpaSignUtil_1", (String)"rpac-rpacp-common", (Object[])new Object[0])), new Object[0]);
            }
            String base64Encoder = IsrpaSignUtil.BASE64Encoder(sha256Str);
            logger.info("header\u4e2d\u52a0\u7b7e\u540e\u7684\u7ed3\u679c\uff1a" + base64Encoder);
            return base64Encoder;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6get\u8bf7\u6c42\u7684\u52a0\u7b7e\u5b57\u7b26\u4e32\u5931\u8d25...", (Throwable)e);
            throw new KDException(new ErrorCode("500", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"IsrpaSignUtil_1", (String)"rpac-rpacp-common", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static String UrlEncodeSpecial(String str) {
        String newSources = null;
        if (StringUtils.isEmpty((CharSequence)str)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a...");
            return null;
        }
        try {
            newSources = URLEncoder.encode(str, "UTF8");
            newSources = newSources.replace("+", "%20");
            newSources = newSources.replace("*", "%2A");
            newSources = newSources.replace("~", "%7E");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u7b7e\u5f02\u5e38...", (Throwable)e);
        }
        return newSources;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        byte[] var6 = array;
        int var7 = array.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            byte item = var6[var8];
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String BASE64Encoder(String str) {
        String signature = Base64.encodeBase64String((byte[])str.getBytes(StandardCharsets.UTF_8));
        signature = signature.replaceAll("\r|\n", "");
        return signature;
    }
}

