/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.common.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpUtils;
import kd.bos.util.StringUtils;
import kd.rpac.rpacp.common.enums.ErrorCodeEnum;

public class RPAHttpUtil
extends HttpUtils {
    private static Log logger = LogFactory.getLog(RPAHttpUtil.class);
    public static final String REQUEST_CONTENT_TYPE = "application/json;charset=utf-8";

    public static String request(String url, String requestType, Map<String, String> header, String argument) {
        return RPAHttpUtil.request(url, requestType, header, argument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String requestType, Map<String, String> header, String argument, boolean replaceSpace) {
        String string;
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("request url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        OutputStream write = null;
        BufferedInputStream reader = null;
        InputStream raw = null;
        try {
            int size;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod(requestType.toUpperCase());
            connection.setRequestProperty("Content-Type", REQUEST_CONTENT_TYPE);
            connection.setRequestProperty("accept", "application/json");
            connection.setRequestProperty("Charset", "UTF-8");
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            if (StringUtils.isNotEmpty((String)argument)) {
                connection.setDoOutput(true);
                write = connection.getOutputStream();
                write.write(argument.getBytes(Charset.forName("UTF-8")));
            }
            raw = connection.getInputStream();
            reader = new BufferedInputStream(raw);
            byte[] buffer = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty((String)encoding)) {
                encoding = "UTF-8";
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = "UTF-8";
                }
            }
            Charset charset = Charset.forName(encoding);
            boolean var12 = false;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String result = sb.toString();
            string = replaceSpace && result.indexOf(10) != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
            RPAHttpUtil.safeClose(write);
        }
        catch (IOException var14) {
            logger.error(ErrorCodeEnum.REQUEST_ERROR.getMsg(), (Throwable)var14);
            String string2 = StringUtils.getEmpty();
            return string2;
        }
        finally {
            RPAHttpUtil.safeClose(write);
            RPAHttpUtil.safeClose(raw);
            RPAHttpUtil.safeClose(reader);
        }
        RPAHttpUtil.safeClose(raw);
        RPAHttpUtil.safeClose(reader);
        return string;
    }

    public static void safeClose(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
        }
    }
}

